/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.basicauthentication;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.gui.swing.jdgui.GUIUtils;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtComboColumn;
import org.appwork.swing.exttable.columns.ExtPasswordEditorColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeListener;
import org.jdownloader.auth.AuthenticationController;
import org.jdownloader.auth.AuthenticationInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class AuthTableModel
extends ExtTableModel<AuthenticationInfo>
implements ChangeListener {
    private static final long serialVersionUID = 1L;

    public AuthTableModel() {
        super("AuthTableModel");
        AuthenticationController.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtCheckColumn<AuthenticationInfo>(_GUI.T.authtablemodel_column_enabled()){
            private static final long serialVersionUID = 1L;

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                    private static final long serialVersionUID = 1L;
                    private final Icon ok;
                    {
                        this.ok = NewTheme.I().getIcon("ok", 14);
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon(this.ok);
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        return this;
                    }
                };
                return ret;
            }

            public int getMaxWidth() {
                return 30;
            }

            public boolean isHidable() {
                return false;
            }

            protected boolean getBooleanValue(AuthenticationInfo value) {
                return value.isEnabled();
            }

            public boolean isEditable(AuthenticationInfo obj) {
                return true;
            }

            protected void setBooleanValue(boolean value, AuthenticationInfo object) {
                object.setEnabled(value);
            }
        });
        this.addColumn((ExtColumn)new ExtComboColumn<AuthenticationInfo, AuthenticationInfo.Type>(_GUI.T.authtablemodel_column_type(), null){
            private static final long serialVersionUID = 1L;
            private ComboBoxModel<AuthenticationInfo.Type> typeModel;
            {
                this.typeModel = new DefaultComboBoxModel<AuthenticationInfo.Type>(new AuthenticationInfo.Type[]{AuthenticationInfo.Type.FTP, AuthenticationInfo.Type.HTTP});
            }

            public boolean isHidable() {
                return false;
            }

            protected String modelItemToString(AuthenticationInfo.Type selectedItem, AuthenticationInfo value) {
                switch (selectedItem) {
                    case FTP: {
                        return _GUI.T.authtablemodel_column_type_ftp();
                    }
                    case HTTP: {
                        return _GUI.T.authtablemodel_column_type_http();
                    }
                }
                return null;
            }

            public ComboBoxModel<AuthenticationInfo.Type> updateModel(ComboBoxModel<AuthenticationInfo.Type> dataModel, AuthenticationInfo value) {
                return this.typeModel;
            }

            public boolean isEditable(AuthenticationInfo obj) {
                return true;
            }

            public boolean isEnabled(AuthenticationInfo obj) {
                return obj.isEnabled();
            }

            public int getDefaultWidth() {
                return 60;
            }

            public int getMinWidth() {
                return 30;
            }

            protected AuthenticationInfo.Type getSelectedItem(AuthenticationInfo object) {
                return object.getType();
            }

            protected void setSelectedItem(AuthenticationInfo object, AuthenticationInfo.Type value) {
                object.setType(value);
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<AuthenticationInfo>(_GUI.T.authtablemodel_column_host()){
            private static final long serialVersionUID = 1L;

            public boolean isHidable() {
                return false;
            }

            public String getStringValue(AuthenticationInfo value) {
                return value.getHostmask();
            }

            public boolean isEditable(AuthenticationInfo obj) {
                return true;
            }

            public boolean isEnabled(AuthenticationInfo obj) {
                return obj.isEnabled();
            }

            protected void setStringValue(String value, AuthenticationInfo object) {
                object.setHostmask(value);
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<AuthenticationInfo>(_GUI.T.authtablemodel_column_realm()){
            private static final long serialVersionUID = 1L;

            public boolean isHidable() {
                return true;
            }

            public String getStringValue(AuthenticationInfo value) {
                return value.getRealm();
            }

            public boolean isDefaultVisible() {
                return false;
            }

            public boolean isEditable(AuthenticationInfo obj) {
                return true;
            }

            public boolean isEnabled(AuthenticationInfo obj) {
                return obj.isEnabled();
            }

            protected void setStringValue(String value, AuthenticationInfo object) {
                object.setRealm(value);
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<AuthenticationInfo>(_GUI.T.authtablemodel_column_username()){
            private static final long serialVersionUID = 1L;

            public boolean isHidable() {
                return false;
            }

            public String getStringValue(AuthenticationInfo value) {
                return GUIUtils.getAccountName(value.getUsername());
            }

            public boolean isEditable(AuthenticationInfo obj) {
                return !CFG_GUI.CFG.isPresentationModeEnabled();
            }

            public boolean isEnabled(AuthenticationInfo obj) {
                return obj.isEnabled();
            }

            protected void setStringValue(String value, AuthenticationInfo object) {
                object.setUsername(value);
            }
        });
        this.addColumn((ExtColumn)new ExtPasswordEditorColumn<AuthenticationInfo>(_GUI.T.authtablemodel_column_password()){
            private static final long serialVersionUID = 1L;

            public boolean isHidable() {
                return false;
            }

            public int getMaxWidth() {
                return 140;
            }

            public int getDefaultWidth() {
                return 110;
            }

            public int getMinWidth() {
                return 100;
            }

            protected String getPlainStringValue(AuthenticationInfo value) {
                return value.getPassword();
            }

            public boolean isEnabled(AuthenticationInfo obj) {
                return obj.isEnabled();
            }

            protected void setStringValue(String value, AuthenticationInfo object) {
                object.setPassword(value);
            }
        });
        this.addColumn((ExtColumn)new ExtCheckColumn<AuthenticationInfo>(_GUI.T.authtablemodel_column_always()){
            private static final long serialVersionUID = 1L;

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                    private static final long serialVersionUID = 1L;
                    private final Icon ok;
                    {
                        this.ok = NewTheme.I().getIcon("basicauth", 14);
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon(this.ok);
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        return this;
                    }
                };
                return ret;
            }

            public int getMaxWidth() {
                return 30;
            }

            public boolean isHidable() {
                return false;
            }

            protected boolean getBooleanValue(AuthenticationInfo value) {
                return value.isAlwaysFlag();
            }

            public boolean isEditable(AuthenticationInfo obj) {
                return true;
            }

            protected void setBooleanValue(boolean value, AuthenticationInfo object) {
                object.setAlwaysFlag(value);
            }
        });
    }

    public void onChangeEvent(ChangeEvent event) {
        this._fireTableStructureChanged(new ArrayList(AuthenticationController.getInstance().list()), false);
    }
}

