/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.LinkgrabberFilter;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.filter.LinkgrabberFilterRule;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.translate._JDT;

public class ExportAction
extends AppAction {
    private static final long serialVersionUID = 1L;
    private final List<LinkgrabberFilterRule> rules;
    private final LinkgrabberFilter linkgrabberFilter;

    public boolean isEnabled() {
        return this.rules == null || this.rules.size() > 0;
    }

    public ExportAction(LinkgrabberFilter linkgrabberFilter, List<LinkgrabberFilterRule> selection) {
        this.setName(_GUI.T.LinkgrabberFilter_LinkgrabberFilter_export());
        this.setIconKey("export");
        this.setTooltipText(_JDT.T.ExportAction_ExportAction_tt());
        this.rules = selection;
        this.linkgrabberFilter = linkgrabberFilter;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            List export = this.rules;
            if (export == null) {
                export = this.linkgrabberFilter.getTable().getModel().getTableData();
            }
            if (export == null || export.size() == 0) {
                return;
            }
            final String ext = ((LinkgrabberFilterRule)export.get(0)).isAccept() ? ".views" : ".filter";
            ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.LinkgrabberFilter_export_dialog_title(), null, null);
            d.setFileSelectionMode(FileChooserSelectionMode.FILES_ONLY);
            d.setStorageID("filter" + ext);
            d.setFileFilter(new FileFilter[]{new FileFilter(){

                @Override
                public String getDescription() {
                    return "*" + ext;
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || StringUtils.endsWithCaseInsensitive((String)f.getName(), (String)ext);
                }
            }});
            d.setType(FileChooserType.SAVE_DIALOG);
            d.setMultiSelection(false);
            Dialog.I().showDialog((AbstractDialog)d);
            File saveto = d.getSelectedFile();
            if (saveto != null) {
                if (!saveto.getName().endsWith(ext)) {
                    saveto = new File(saveto.getAbsolutePath() + ext);
                }
                try {
                    if (saveto.exists() && !saveto.delete()) {
                        throw new IOException("Could not delete/overwrite:" + saveto);
                    }
                    IO.writeStringToFile((File)saveto, (String)JSonStorage.serializeToJson((Object)export));
                }
                catch (IOException e1) {
                    LogController.CL().log((Throwable)e1);
                    Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e1.getMessage(), (Throwable)e1);
                }
            }
        }
        catch (DialogNoAnswerException e1) {
            LogController.CL().log((Throwable)e1);
        }
    }
}

