/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.proxy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.NoProxySelector;
import jd.controlling.proxy.PacProxySelectorImpl;
import jd.controlling.proxy.SingleBasicProxySelectorImpl;
import jd.controlling.proxy.SingleDirectGatewaySelector;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;

public class HostColumn
extends ExtTextColumn<AbstractProxySelectorImpl> {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong TASK = new AtomicLong(0L);
    private static final ScheduledExecutorService SCHEDULER = DelayedRunnable.getNewScheduledExecutorService();

    public HostColumn() {
        super(_GUI.T.gui_column_host2());
    }

    protected Icon getIcon(AbstractProxySelectorImpl value) {
        return super.getIcon((Object)value);
    }

    public boolean isSortable(AbstractProxySelectorImpl obj) {
        return false;
    }

    protected void setStringValue(String value, AbstractProxySelectorImpl object) {
        if (object instanceof NoProxySelector) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (object instanceof SingleDirectGatewaySelector) {
            ((SingleDirectGatewaySelector)object).getProxy().setLocal(value);
            return;
        }
        if (object instanceof SingleBasicProxySelectorImpl) {
            ((SingleBasicProxySelectorImpl)object).setHost(value);
            return;
        }
        if (object instanceof PacProxySelectorImpl) {
            ((PacProxySelectorImpl)object).setPACUrl(value);
            return;
        }
        throw new IllegalStateException("Unknown Factory Type: " + object.getClass());
    }

    public String getStringValue(AbstractProxySelectorImpl value) {
        try {
            if (value instanceof NoProxySelector) {
                return "";
            }
            if (value instanceof SingleDirectGatewaySelector) {
                return ((SingleDirectGatewaySelector)value).getProxy().getLocal();
            }
            if (value instanceof SingleBasicProxySelectorImpl) {
                return ((SingleBasicProxySelectorImpl)value).getProxy().getHost();
            }
            if (value instanceof PacProxySelectorImpl) {
                return ((PacProxySelectorImpl)value).getPACUrl();
            }
            throw new IllegalStateException("Unknown Factory Type: " + value.getClass());
        }
        catch (Throwable e) {
            return "Invalid Proxy: " + JSonStorage.serializeToJson((Object)value.toProxyData());
        }
    }

    public boolean isEditable(AbstractProxySelectorImpl value) {
        if (value instanceof NoProxySelector) {
            return false;
        }
        if (value instanceof SingleDirectGatewaySelector) {
            return true;
        }
        return true;
    }

    public boolean isEnabled(AbstractProxySelectorImpl obj) {
        return true;
    }

    public ExtTooltip createToolTip(Point position, AbstractProxySelectorImpl obj) {
        ConnectionTooltip ret;
        if (obj instanceof AbstractProxySelectorImpl && (ret = new ConnectionTooltip(obj)).getComponentCount() > 0) {
            return ret;
        }
        return null;
    }

    public void setValue(Object value, AbstractProxySelectorImpl object) {
        super.setValue(value, (Object)object);
    }

    public int getDefaultWidth() {
        return 200;
    }

    public int getMinWidth() {
        return 100;
    }

    public boolean isHidable() {
        return false;
    }

    private class ConnectionTooltip
    extends ExtTooltip {
        private static final long serialVersionUID = -6581783135666367021L;

        public ConnectionTooltip(final AbstractProxySelectorImpl impl) {
            this.panel = new TooltipPanel("ins 3,wrap 1", "[grow,fill]", "[grow,fill]");
            final String proxyString = impl.toDetailsString();
            Icon icon = AbstractProxySelectorImpl.Type.DIRECT.equals((Object)impl.getType()) || AbstractProxySelectorImpl.Type.NONE.equals((Object)impl.getType()) ? NewTheme.I().getIcon("modem", 16) : NewTheme.I().getIcon("proxy_rotate", 16);
            JLabel lbl = new JLabel(_GUI.T.ConnectionColumn_getStringValue_connection(proxyString + " (000.000.000.000)"), icon, 10);
            this.panel.add((Component)lbl);
            SwingUtils.setOpaque((JComponent)lbl, (boolean)false);
            Color color = UIManager.getColor("Appwork.Tooltip.Foreground");
            if (color != null) {
                lbl.setForeground(color);
            }
            final JLabel finalLbl = lbl;
            final long taskID = TASK.incrementAndGet();
            SCHEDULER.execute(new Runnable(){

                @Override
                public void run() {
                    if (taskID == TASK.get()) {
                        BalancedWebIPCheck ipCheck = new BalancedWebIPCheck(new ProxySelectorInterface(){

                            public boolean updateProxy(Request request, int retryCounter) {
                                return false;
                            }

                            public boolean reportConnectException(Request request, int retryCounter, IOException e) {
                                return false;
                            }

                            public List<HTTPProxy> getProxiesByURL(URL uri) {
                                return impl.getProxiesByURL(uri);
                            }
                        });
                        try {
                            final IP ip = ipCheck.getExternalIP();
                            new EDTRunner(){

                                protected void runInEDT() {
                                    finalLbl.setText(_GUI.T.ConnectionColumn_getStringValue_connection(proxyString + " (" + ip.getIP() + ")"));
                                }
                            };
                        }
                        catch (IPCheckException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.panel.setOpaque(false);
            if (this.panel.getComponentCount() > 0) {
                this.add((Component)this.panel);
            }
        }

        public TooltipPanel createContent() {
            return null;
        }

        public String toText() {
            return null;
        }
    }
}

