/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.reconnect;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import jd.nutils.Formatter;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.translate._JDT;

public class ReconnectTester
extends MigPanel
implements SettingsComponent,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton btnTest;
    private JLabel lblDuration;
    private JLabel lblTime;
    private JLabel lblCurrentIP;
    private JLabel lblSuccessIcon;
    private JLabel lblStatusMessage;
    private JLabel lblBeforeIpLabel;
    private JLabel lblBeforeIP;

    public ReconnectTester() {
        super("ins 0, wrap 6", "[]5[right]20[right]20[right]20[right]20[right]", "[fill]");
        this.initComponents();
        this.layoutComponents();
        this.fill();
    }

    private void fill() {
    }

    private void layoutComponents() {
        this.add(this.btnTest, "spany 2,pushy,growy");
        this.add(this.lblDuration);
        this.add(this.lblTime);
        JLabel lbl = new JLabel(_JDT.T.gui_config_reconnect_showcase_currentip());
        lbl.setEnabled(false);
        this.add(lbl);
        this.add(this.lblCurrentIP, "growx,pushx");
        this.add(this.lblSuccessIcon, "spany,alignx right");
        this.add(this.lblStatusMessage, "spanx 2");
        this.add(this.lblBeforeIpLabel);
        this.add(this.lblBeforeIP, "growx,pushx");
    }

    private void initComponents() {
        this.btnTest = new JButton(_JDT.T.gui_config_reconnect_showcase_reconnect2());
        this.btnTest.setIcon((Icon)new AbstractIcon("play", 20));
        this.btnTest.addActionListener(this);
        this.lblDuration = new JLabel(_JDT.T.gui_config_reconnect_showcase_time());
        this.lblDuration.setEnabled(false);
        this.lblTime = new JLabel("---");
        this.lblCurrentIP = new JLabel("---");
        this.lblSuccessIcon = new JLabel((Icon)new AbstractIcon("ok", 32));
        this.lblSuccessIcon.setEnabled(false);
        this.lblSuccessIcon.setHorizontalTextPosition(2);
        this.lblStatusMessage = new JLabel(_JDT.T.gui_config_reconnect_showcase_message_none());
        this.lblStatusMessage.setEnabled(false);
        this.lblBeforeIpLabel = new JLabel(_JDT.T.gui_config_reconnect_showcase_lastip());
        this.lblBeforeIpLabel.setEnabled(false);
        this.lblBeforeIP = new JLabel("---");
    }

    @Override
    public boolean isMultiline() {
        return true;
    }

    public void addStateUpdateListener(StateUpdateListener listener) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public String getConstraints() {
        return "wmin 10,height 30:n:n";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnTest) {
            this.testReconnect();
        }
    }

    private void testReconnect() {
        LoggerFactory.getDefaultLogger().info("Reconnect Testing");
        this.btnTest.setEnabled(false);
        LoggerFactory.getDefaultLogger().info("Start Reconnect");
        this.lblStatusMessage.setText(_JDT.T.gui_warning_reconnect_running());
        this.lblStatusMessage.setEnabled(true);
        this.lblBeforeIP.setText("?");
        this.lblBeforeIP.setEnabled(true);
        this.lblBeforeIpLabel.setEnabled(true);
        this.lblCurrentIP.setText("?");
        new Thread(this.getClass().getName()){
            {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int retries;
                ReconnectConfig config;
                ScheduledFuture<?> timer;
                ScheduledExecutorService scheduler;
                block6: {
                    final IP ip = IPController.getInstance().getIP();
                    new EDTRunner(){

                        protected void runInEDT() {
                            ReconnectTester.this.lblBeforeIP.setText(ip.toString());
                        }
                    };
                    scheduler = DelayedRunnable.getNewScheduledExecutorService();
                    timer = scheduler.scheduleAtFixedRate(new Runnable(){
                        private final long startTimeStamp = System.currentTimeMillis();

                        @Override
                        public void run() {
                            new EDTRunner(){

                                protected void runInEDT() {
                                    ReconnectTester.this.lblTime.setText(Formatter.formatSeconds((long)((System.currentTimeMillis() - startTimeStamp) / 1000L)));
                                    ReconnectTester.this.lblTime.setEnabled(true);
                                    ReconnectTester.this.lblDuration.setEnabled(true);
                                }
                            };
                        }
                    }, 1L, 1L, TimeUnit.SECONDS);
                    config = (ReconnectConfig)JsonConfig.create(ReconnectConfig.class);
                    retries = config.getMaxReconnectRetryNum();
                    try {
                        config.setMaxReconnectRetryNum(0);
                        boolean ret = false;
                        try {
                            if (DownloadWatchDog.getInstance().requestReconnect(true) == Reconnecter.ReconnectResult.SUCCESSFUL) {
                                ret = true;
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        final String currentIP = config.isIPCheckGloballyDisabled() ? "?" : IPController.getInstance().getIP().toString();
                        if (ret) {
                            new EDTRunner(){

                                protected void runInEDT() {
                                    if (config.isIPCheckGloballyDisabled()) {
                                        ReconnectTester.this.lblStatusMessage.setText(_JDT.T.gui_warning_reconnectunknown());
                                    } else {
                                        ReconnectTester.this.lblStatusMessage.setText(_JDT.T.gui_warning_reconnectSuccess());
                                    }
                                    ReconnectTester.this.lblSuccessIcon.setIcon((Icon)new AbstractIcon("true", 32));
                                    ReconnectTester.this.lblSuccessIcon.setEnabled(true);
                                    ReconnectTester.this.lblStatusMessage.setEnabled(true);
                                    ReconnectTester.this.lblCurrentIP.setText(currentIP);
                                }
                            };
                            break block6;
                        }
                        new EDTRunner(){

                            protected void runInEDT() {
                                ReconnectTester.this.lblStatusMessage.setText(_JDT.T.gui_warning_reconnectFailed());
                                ReconnectTester.this.lblSuccessIcon.setIcon((Icon)new AbstractIcon("false", 32));
                                ReconnectTester.this.lblSuccessIcon.setEnabled(true);
                                ReconnectTester.this.lblCurrentIP.setText(currentIP);
                            }
                        };
                    }
                    catch (Throwable throwable) {
                        config.setMaxReconnectRetryNum(retries);
                        timer.cancel(true);
                        scheduler.shutdown();
                        new EDTRunner(){

                            protected void runInEDT() {
                                ReconnectTester.this.btnTest.setEnabled(true);
                            }
                        };
                        throw throwable;
                    }
                }
                config.setMaxReconnectRetryNum(retries);
                timer.cancel(true);
                scheduler.shutdown();
                new /* invalid duplicate definition of identical inner class */;
            }
        }.start();
    }

    public void updateCurrentIP(final IP ip) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectTester.this.lblCurrentIP.setText(ip.toString());
            }
        };
    }
}

