/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.util.BigIntegers;

public class BcTlsECDomain
implements TlsECDomain {
    protected final BcTlsCrypto crypto;
    protected final ECDomainParameters domainParameters;

    public static BcTlsSecret calculateECDHAgreement(BcTlsCrypto bcTlsCrypto, ECPrivateKeyParameters eCPrivateKeyParameters, ECPublicKeyParameters eCPublicKeyParameters) {
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init((CipherParameters)eCPrivateKeyParameters);
        BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement((CipherParameters)eCPublicKeyParameters);
        byte[] byArray = BigIntegers.asUnsignedByteArray((int)eCDHBasicAgreement.getFieldSize(), (BigInteger)bigInteger);
        return bcTlsCrypto.adoptLocalSecret(byArray);
    }

    public static ECDomainParameters getDomainParameters(TlsECConfig tlsECConfig) {
        ECDomainParameters eCDomainParameters = BcTlsECDomain.getDomainParameters(tlsECConfig.getNamedGroup());
        if (eCDomainParameters == null) {
            throw new IllegalArgumentException("No EC configuration provided");
        }
        return eCDomainParameters;
    }

    public static ECDomainParameters getDomainParameters(int n) {
        if (!NamedGroup.refersToASpecificCurve(n)) {
            return null;
        }
        String string = NamedGroup.getCurveName(n);
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName((String)string);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByName((String)string)) == null) {
            return null;
        }
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public BcTlsECDomain(BcTlsCrypto bcTlsCrypto, TlsECConfig tlsECConfig) {
        this.crypto = bcTlsCrypto;
        this.domainParameters = BcTlsECDomain.getDomainParameters(tlsECConfig);
    }

    public BcTlsSecret calculateECDHAgreement(ECPrivateKeyParameters eCPrivateKeyParameters, ECPublicKeyParameters eCPublicKeyParameters) {
        return BcTlsECDomain.calculateECDHAgreement(this.crypto, eCPrivateKeyParameters, eCPublicKeyParameters);
    }

    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] byArray) {
        return this.domainParameters.getCurve().decodePoint(byArray);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] byArray) throws IOException {
        try {
            ECPoint eCPoint = this.decodePoint(byArray);
            return new ECPublicKeyParameters(eCPoint, this.domainParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    public byte[] encodePoint(ECPoint eCPoint) {
        return eCPoint.getEncoded(false);
    }

    public byte[] encodePublicKey(ECPublicKeyParameters eCPublicKeyParameters) {
        return this.encodePoint(eCPublicKeyParameters.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.domainParameters, this.crypto.getSecureRandom()));
        return eCKeyPairGenerator.generateKeyPair();
    }
}

