/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSASigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.PQCUtil;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;

public class BcTlsMLDSASigner
extends BcTlsSigner {
    private final int signatureScheme;

    public static BcTlsMLDSASigner create(BcTlsCrypto bcTlsCrypto, MLDSAPrivateKeyParameters mLDSAPrivateKeyParameters, int n) {
        if (n != PQCUtil.getMLDSASignatureScheme(mLDSAPrivateKeyParameters.getParameters())) {
            return null;
        }
        return new BcTlsMLDSASigner(bcTlsCrypto, mLDSAPrivateKeyParameters, n);
    }

    private BcTlsMLDSASigner(BcTlsCrypto bcTlsCrypto, MLDSAPrivateKeyParameters mLDSAPrivateKeyParameters, int n) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)mLDSAPrivateKeyParameters);
        this.signatureScheme = n;
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        MLDSASigner mLDSASigner = new MLDSASigner();
        mLDSASigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        return new BcTlsStreamSigner((Signer)mLDSASigner);
    }
}

