/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.interfaces.MLKEMPublicKey;
import org.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.jcajce.spec.MLKEMPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

class KemUtil {
    KemUtil() {
    }

    static PublicKey decodePublicKey(JcaTlsCrypto jcaTlsCrypto, String string, byte[] byArray) throws TlsFatalAlert {
        try {
            KeyFactory keyFactory = jcaTlsCrypto.getHelper().createKeyFactory(string);
            if (keyFactory.getProvider() instanceof BouncyCastleProvider) {
                try {
                    MLKEMParameterSpec mLKEMParameterSpec = MLKEMParameterSpec.fromName((String)string);
                    MLKEMPublicKeySpec mLKEMPublicKeySpec = new MLKEMPublicKeySpec(mLKEMParameterSpec, byArray);
                    return keyFactory.generatePublic((KeySpec)mLKEMPublicKeySpec);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            X509EncodedKeySpec x509EncodedKeySpec = KemUtil.createX509EncodedKeySpec(KemUtil.getAlgorithmOID(string), byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    static byte[] encodePublicKey(PublicKey publicKey) throws TlsFatalAlert {
        if (publicKey instanceof MLKEMPublicKey) {
            return ((MLKEMPublicKey)publicKey).getPublicData();
        }
        if (!"X.509".equals(publicKey.getFormat())) {
            throw new TlsFatalAlert(80, "Public key format unrecognized");
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            return subjectPublicKeyInfo.getPublicKeyData().getOctets();
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
    }

    static KeyFactory getKeyFactory(JcaTlsCrypto jcaTlsCrypto, String string) {
        try {
            return jcaTlsCrypto.getHelper().createKeyFactory(string);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static KeyGenerator getKeyGenerator(JcaTlsCrypto jcaTlsCrypto, String string) {
        try {
            return jcaTlsCrypto.getHelper().createKeyGenerator(string);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static KeyPairGenerator getKeyPairGenerator(JcaTlsCrypto jcaTlsCrypto, String string) {
        try {
            KeyPairGenerator keyPairGenerator = jcaTlsCrypto.getHelper().createKeyPairGenerator("ML-KEM");
            keyPairGenerator.initialize((AlgorithmParameterSpec)MLKEMParameterSpec.fromName((String)string), jcaTlsCrypto.getSecureRandom());
            return keyPairGenerator;
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static boolean isKemSupported(JcaTlsCrypto jcaTlsCrypto, String string) {
        return string != null && KemUtil.getKeyFactory(jcaTlsCrypto, string) != null && KemUtil.getKeyGenerator(jcaTlsCrypto, string) != null && KemUtil.getKeyPairGenerator(jcaTlsCrypto, string) != null;
    }

    private static X509EncodedKeySpec createX509EncodedKeySpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        return new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded("DER"));
    }

    private static ASN1ObjectIdentifier getAlgorithmOID(String string) {
        if ("ML-KEM-512".equalsIgnoreCase(string)) {
            return NISTObjectIdentifiers.id_alg_ml_kem_512;
        }
        if ("ML-KEM-768".equalsIgnoreCase(string)) {
            return NISTObjectIdentifiers.id_alg_ml_kem_768;
        }
        if ("ML-KEM-1024".equalsIgnoreCase(string)) {
            return NISTObjectIdentifiers.id_alg_ml_kem_1024;
        }
        throw new IllegalArgumentException("unknown kem name " + string);
    }
}

