/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import jd.captcha.JACMethod;
import jd.captcha.LetterComperator;
import jd.captcha.configuration.JACScript;
import jd.captcha.gui.BasicWindow;
import jd.captcha.gui.ImageComponent;
import jd.captcha.gui.ScrollPaneWindow;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.utils.Utilities;
import jd.gui.userio.DummyFrame;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.Executer;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;
import org.appwork.utils.Files;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.logging.LogController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAntiCaptcha {
    private BasicWindow bw2;
    private BasicWindow bw3;
    private JDialog f;
    private String imageType;
    public JACScript jas;
    public List<Letter> letterDB;
    private int[][] letterMap = null;
    private int letterNum;
    private String methodDirName;
    private boolean showDebugGui = false;
    private Vector<ScrollPaneWindow> spw = new Vector();
    private Captcha workingCaptcha;
    private boolean extern;
    private String command;
    private String dstFile;
    private String srcFile;
    private Image sourceImage;
    private final LogSource logger;
    private final JACMethod method;
    public static final HashSet<String> SYNCMAP = new HashSet();

    public static void testMethod(File file, String methodName) throws InterruptedException {
        LogSource logger = LogController.CL();
        int checkCaptchas = 20;
        int totalLetters = 0;
        int correctLetters = 0;
        if (methodName == null) {
            methodName = file.getName();
        }
        File captchaDir = new File(file.getAbsolutePath() + "/captchas");
        logger.info("Test Method: " + methodName);
        new JAntiCaptcha(methodName);
        File[] entries = captchaDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jpg") || pathname.getName().endsWith(".png") || pathname.getName().endsWith(".gif");
            }
        });
        ScrollPaneWindow w = new ScrollPaneWindow();
        w.setTitle(" Test Captchas: " + file.getAbsolutePath());
        w.resizeWindow(100);
        logger.info("Found Testcaptchas: " + entries.length);
        int testNum = Math.min(checkCaptchas, entries.length);
        logger.info("Test " + testNum + " Captchas");
        int i = 0;
        for (i = 0; i < testNum; ++i) {
            File captchaFile = entries[(int)(Math.random() * (double)entries.length)];
            logger.info("JJJJJJJJ" + captchaFile);
            Image img = Utilities.loadImage(captchaFile);
            w.setText(0, i, captchaFile.getName());
            w.setImage(1, i, img);
            w.repack();
            JAntiCaptcha jac = new JAntiCaptcha(methodName);
            Captcha cap = jac.createCaptcha(img);
            if (cap == null) {
                logger.severe("Captcha Bild konnte nicht eingelesen werden");
                continue;
            }
            w.setImage(2, i, cap.getImage());
            String code = jac.checkCaptcha(captchaFile, cap);
            w.setImage(3, i, cap.getImage());
            w.setText(4, i, "JAC:" + code);
            w.repack();
            String inputCode = JOptionPane.showInputDialog((Component)((Object)w), "Bitte Captcha Code eingeben", code);
            w.setText(5, i, "User:" + inputCode);
            w.repack();
            if (code == null) {
                code = "";
            }
            if (inputCode == null) {
                inputCode = "";
            }
            code = code.toLowerCase();
            inputCode = inputCode.toLowerCase();
            for (int x = 0; x < inputCode.length(); ++x) {
                ++totalLetters;
                if (inputCode.length() != code.length() || inputCode.charAt(x) != code.charAt(x)) continue;
                ++correctLetters;
            }
            logger.info("Erkennung: " + correctLetters + "/" + totalLetters + " = " + Utilities.getPercent(correctLetters, totalLetters) + "%");
        }
        w.setText(0, i + 1, "Erkennung: " + Utilities.getPercent(correctLetters, totalLetters) + "%");
        w.setText(4, i + 1, "Richtig: " + correctLetters);
        w.setText(5, i + 1, "Falsch: " + (totalLetters - correctLetters));
        JOptionPane.showMessageDialog(new JFrame(), "Erkennung: " + correctLetters + "/" + totalLetters + " = " + Utilities.getPercent(correctLetters, totalLetters) + "%");
    }

    public static void testMethods(File[] methods) throws InterruptedException {
        for (File element : methods) {
            JAntiCaptcha.testMethod(element, null);
        }
    }

    public boolean isExtern() {
        return this.extern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAntiCaptcha(String methodName) {
        LogSource rebirthLogger = LogController.getRebirthLogger();
        this.logger = rebirthLogger != null ? LogController.getFastPluginLogger((String)rebirthLogger.getName()) : LogController.CL((boolean)false);
        try {
            this.method = JACMethod.forServiceName(methodName);
            if (this.method == null) {
                this.logger.severe("no such method found! " + methodName);
                return;
            }
            this.methodDirName = this.method.getFileName();
            this.getJACInfo();
            this.jas = new JACScript(this, this.methodDirName);
            long time = System.currentTimeMillis();
            this.loadMTHFile();
            time = System.currentTimeMillis() - time;
            this.logger.fine("LoadTime: " + time);
            this.logger.fine("letter DB loaded: Buchstaben: " + this.letterDB.size());
        }
        finally {
            this.logger.setLevel(Level.OFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAntiCaptcha() {
        LogSource rebirthLogger = LogController.getRebirthLogger();
        this.logger = rebirthLogger != null ? LogController.getFastPluginLogger((String)rebirthLogger.getName()) : LogController.CL((boolean)false);
        try {
            this.method = null;
            this.jas = new JACScript(this);
            long time = System.currentTimeMillis();
            this.loadMTHFile();
            time = System.currentTimeMillis() - time;
            this.logger.fine("LoadTime: " + time);
            this.logger.fine("letter DB loaded: Buchstaben: " + this.letterDB.size());
        }
        finally {
            this.logger.setLevel(Level.OFF);
        }
    }

    public String checkCaptcha(File file, Captcha captcha) throws InterruptedException {
        LetterComperator akt;
        int i;
        if (this.extern) {
            return this.callExtern();
        }
        this.workingCaptcha = captcha;
        this.jas.executePrepareCommands(file, captcha);
        Letter[] letters = captcha.getLetters(this.getLetterNum());
        if (letters == null) {
            captcha.setValityPercent(100.0);
            this.logger.severe("Captcha konnte nicht erkannt werden!");
            return null;
        }
        String ret = "";
        double correct = 0.0;
        Vector<LetterComperator> newLettersVector = new Vector<LetterComperator>();
        for (i = 0; i < letters.length; ++i) {
            letters[i].setId(i);
            akt = letters[i].detected != null ? letters[i].detected : this.getLetter(letters[i]);
            akt.getA().setId(i);
            newLettersVector.add(akt);
        }
        if (letters.length > this.getLetterNum()) {
            Collections.sort(newLettersVector, new Comparator<LetterComperator>(){

                @Override
                public int compare(LetterComperator obj1, LetterComperator obj2) {
                    if (obj1.getValityPercent() < obj2.getValityPercent()) {
                        return -1;
                    }
                    if (obj1.getValityPercent() > obj2.getValityPercent()) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.logger.info(this.getLetterNum() + "");
            if (!this.jas.getBoolean("autoLetterNum")) {
                for (i = newLettersVector.size() - 1; i >= this.getLetterNum(); --i) {
                    newLettersVector.remove(i);
                }
            }
            Collections.sort(newLettersVector, new Comparator<LetterComperator>(){

                @Override
                public int compare(LetterComperator obj1, LetterComperator obj2) {
                    if (obj1.getA().getId() < obj2.getA().getId()) {
                        return -1;
                    }
                    if (obj1.getA().getId() > obj2.getA().getId()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        if (this.getJas().getString("useLettercomparatorFilter") != null && this.getJas().getString("useLettercomparatorFilter").length() > 0) {
            String[] ref = this.getJas().getString("useLettercomparatorFilter").split("\\.");
            if (ref.length != 2) {
                captcha.setValityPercent(100.0);
                this.logger.severe("useLettercomparatorFilter should have the format Class.Method");
                return null;
            }
            String cl = ref[0];
            String methodname = ref[1];
            try {
                Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                Class[] parameterTypes = new Class[]{newLettersVector.getClass(), this.getClass()};
                Method method = newClass.getMethod(methodname, parameterTypes);
                Object[] arguments = new Object[]{newLettersVector, this};
                Object instance = null;
                method.invoke(instance, arguments);
            }
            catch (Exception e) {
                this.logger.severe("Fehler in useLettercomparatorFilter:" + e.getLocalizedMessage() + " / " + this.getJas().getString("useLettercomparatorFilter"));
                this.logger.log((Throwable)e);
            }
        }
        for (i = 0; i < newLettersVector.size(); ++i) {
            akt = (LetterComperator)newLettersVector.get(i);
            if (akt == null || akt.getValityPercent() >= 100.0) {
                ret = ret + "-";
                correct += 100.0;
                continue;
            }
            ret = ret + akt.getDecodedValue();
            akt.getA().setId(i);
            correct += akt.getValityPercent();
        }
        if (newLettersVector.size() == 0) {
            captcha.setValityPercent(100.0);
            return null;
        }
        captcha.setLetterComperators(newLettersVector.toArray(new LetterComperator[0]));
        this.logger.finer("Vality: " + (int)(correct / (double)newLettersVector.size()));
        captcha.setValityPercent(correct / (double)newLettersVector.size());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDB() {
        File path = Utilities.directoryChooser();
        int i = 0;
        for (Letter letter : this.letterDB) {
            BufferedImage img = letter.getFullImage();
            File file = new File(path + "/letterDB/" + i++ + "_" + letter.getDecodedValue() + ".png");
            FileCreationManager.getInstance().mkdir(file);
            FileOutputStream fos = null;
            try {
                this.logger.info("Write Db: " + file);
                fos = new FileOutputStream(file);
                ImageProvider.writeImage((RenderedImage)img, (String)"png", (OutputStream)fos);
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private BufferedImage toBufferedImage(Image i) {
        if (i instanceof BufferedImage) {
            return (BufferedImage)i;
        }
        Image img = new ImageIcon(i).getImage();
        BufferedImage b = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g = b.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String callExtern() {
        this.logger.info("acquire lock: " + this.methodDirName);
        while (true) {
            var1_1 = JAntiCaptcha.SYNCMAP;
            synchronized (var1_1) {
                if (JAntiCaptcha.SYNCMAP.add(this.methodDirName)) {
                    this.logger.info("locked: " + this.methodDirName);
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.log((Throwable)e);
                return null;
            }
        }
        fos = null;
        try {
            file = JDUtilities.getResourceFile((String)this.srcFile);
            FileCreationManager.getInstance().mkdir(file.getParentFile());
            ext = Files.getExtension((String)file.getName());
            fos = new FileOutputStream(file);
            ImageProvider.writeImage((RenderedImage)this.toBufferedImage(this.sourceImage), (String)ext, (OutputStream)fos);
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ext = null;
            var4_11 = JAntiCaptcha.SYNCMAP;
            synchronized (var4_11) {
                this.logger.info("release lock: " + this.methodDirName);
                JAntiCaptcha.SYNCMAP.remove(this.methodDirName);
            }
            return ext;
        }
        this.logger.info("start: " + this.command);
        exec = new Executer(JDUtilities.getResourceFile((String)this.command).getAbsolutePath());
        exec.setRunin(JDUtilities.getResourceFile((String)this.command).getParent());
        exec.setWaitTimeout(300);
        exec.start();
        exec.waitTimeout();
        try {
            exec.interrupt();
        }
        catch (Throwable ext) {
            // empty catch block
        }
        res = JDIO.readFileToString((File)JDUtilities.getResourceFile((String)this.dstFile));
        this.logger.info("returned with: " + res);
        if (res != null) ** GOTO lbl-1000
        var4_12 = null;
        return var4_12;
lbl-1000:
        // 1 sources

        {
            var4_13 = res.trim();
        }
        return var4_13;
        {
            finally {
                try {
                    fos.close();
                }
                catch (Throwable var4_10) {}
            }
        }
        finally {
            var11_22 = JAntiCaptcha.SYNCMAP;
            synchronized (var11_22) {
                this.logger.info("release lock: " + this.methodDirName);
                JAntiCaptcha.SYNCMAP.remove(this.methodDirName);
            }
        }
    }

    public String checkCaptcha(File captchafile) throws InterruptedException {
        this.logger.finer("check " + captchafile);
        Image captchaImage = Utilities.loadImage(captchafile);
        Captcha captcha = this.createCaptcha(captchaImage);
        if (captcha != null) {
            captcha.setCaptchaFile(captchafile);
        }
        return this.checkCaptcha(captchafile, captcha);
    }

    public Captcha createCaptcha(Image captchaImage) throws InterruptedException {
        this.sourceImage = captchaImage;
        if (this.extern) {
            return null;
        }
        if (captchaImage.getWidth(null) <= 0 || captchaImage.getHeight(null) <= 0) {
            this.logger.severe("Image Dimensionen zu klein. Image hat keinen Inahlt. Pfad/Url pr\u00fcfen!");
            return null;
        }
        Captcha ret = Captcha.getCaptcha(captchaImage, this);
        if (ret == null) {
            return null;
        }
        ret.setOwner(this);
        return ret;
    }

    private void createLetterDBFormMTH(Document mth) {
        this.letterDB = new ArrayList<Letter>();
        long start1 = System.currentTimeMillis();
        try {
            if (mth == null || mth.getFirstChild() == null) {
                return;
            }
            NodeList nl = mth.getFirstChild().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node childNode = nl.item(i);
                if (childNode.getNodeName().equals("letter")) {
                    NamedNodeMap att = childNode.getAttributes();
                    Letter tmp = new Letter();
                    tmp.setOwner(this);
                    String id = JDUtilities.getAttribute((Node)childNode, (String)"id");
                    if (!tmp.setTextGrid(childNode.getTextContent())) {
                        this.logger.severe("Error in Letters DB line: " + i + ":" + childNode.getTextContent() + " id:" + id);
                        continue;
                    }
                    if (id != null) {
                        tmp.setId(Integer.parseInt(id));
                    }
                    tmp.setSourcehash(att.getNamedItem("captchaHash").getNodeValue());
                    tmp.setDecodedValue(att.getNamedItem("value").getNodeValue());
                    tmp.setBadDetections(Integer.parseInt(JDUtilities.getAttribute((Node)childNode, (String)"bad")));
                    tmp.setGoodDetections(Integer.parseInt(JDUtilities.getAttribute((Node)childNode, (String)"good")));
                    this.letterDB.add(tmp);
                    continue;
                }
                if (!childNode.getNodeName().equals("map")) continue;
                this.logger.fine("Parse LetterMap");
                long start2 = System.currentTimeMillis();
                String[] map = childNode.getTextContent().split("\\|");
                this.letterMap = new int[map.length][map.length];
                for (int x = 0; x < map.length; ++x) {
                    String[] row = map[x].split("\\,");
                    for (int y = 0; y < map.length; ++y) {
                        this.letterMap[x][y] = Integer.parseInt(row[y]);
                    }
                }
                this.logger.fine("LetterMap Parsing time: " + (System.currentTimeMillis() - start2));
            }
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            this.logger.severe("Fehler bein lesen der MTH Datei!!. Methode kann nicht funktionieren!");
        }
        this.logger.fine("Mth Parsing time: " + (System.currentTimeMillis() - start1));
    }

    private Document createXMLFromLetterDB() {
        Document xml = JDUtilities.parseXmlString((String)"<jDownloader></jDownloader>");
        if (this.letterMap != null) {
            Element element = xml.createElement("map");
            xml.getFirstChild().appendChild(element);
            element.appendChild(xml.createTextNode(this.getLetterMapString()));
        }
        int i = 0;
        for (Letter letter : this.letterDB) {
            Element element = xml.createElement("letter");
            xml.getFirstChild().appendChild(element);
            element.appendChild(xml.createTextNode(letter.getPixelString()));
            element.setAttribute("id", i++ + "");
            element.setAttribute("value", letter.getDecodedValue());
            element.setAttribute("captchaHash", letter.getSourcehash());
            element.setAttribute("good", letter.getGoodDetections() + "");
            element.setAttribute("bad", letter.getBadDetections() + "");
        }
        return xml;
    }

    private void destroyScrollPaneWindows() {
        while (this.spw.size() > 0) {
            this.spw.remove(0).destroy();
        }
    }

    public void displayLibrary() {
        if (this.letterDB == null || this.letterDB.size() == 0) {
            return;
        }
        JFrame w = new JFrame();
        this.sortLetterDB();
        JPanel p = new JPanel(new GridLayout(this.letterDB.size() + 1, 3));
        w.add(new JScrollPane(p));
        Letter[] list = new Letter[this.letterDB.size()];
        int y = 0;
        int i = 0;
        ListIterator<Letter> iter = this.letterDB.listIterator(this.letterDB.size());
        final ArrayList rem = new ArrayList();
        while (iter.hasPrevious()) {
            Letter tmp;
            list[i] = tmp = iter.previous();
            JLabel lbl = null;
            lbl = tmp.getGoodDetections() == 0 && tmp.getBadDetections() > 3 || (double)tmp.getBadDetections() / (double)tmp.getGoodDetections() >= 3.0 ? new JLabel("<html><p><font color=\"#ff0000\" size=\"3\">" + tmp.getId() + ": " + tmp.getDecodedValue() + "(" + tmp.getGoodDetections() + "/" + tmp.getBadDetections() + ") Size: " + tmp.toPixelObject(0.85).getSize() + "</font> </p></html>") : new JLabel(tmp.getId() + ": " + tmp.getDecodedValue() + "(" + tmp.getGoodDetections() + "/" + tmp.getBadDetections() + ") Size: " + tmp.toPixelObject(0.85).getSize());
            ImageComponent img = new ImageComponent(tmp.getImage());
            JCheckBox bt = new JCheckBox("DELETE");
            final int ii = i++;
            bt.addActionListener(new ActionListener(){
                public Integer id;
                {
                    this.id = ii;
                }

                @Override
                public void actionPerformed(ActionEvent arg) {
                    JCheckBox src = (JCheckBox)arg.getSource();
                    if (src.getText().equals("DELETE")) {
                        rem.add(this.id);
                    } else {
                        rem.remove(this.id);
                    }
                }
            });
            p.add(lbl);
            p.add(img);
            p.add(bt);
            ++y;
        }
        JButton b = new JButton("Invoke");
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Letter> list = new ArrayList<Letter>();
                int s = JAntiCaptcha.this.letterDB.size();
                for (Integer i : rem) {
                    try {
                        Letter let = JAntiCaptcha.this.letterDB.get(s - 1 - i);
                        list.add(let);
                    }
                    catch (Exception ew) {
                        JAntiCaptcha.this.logger.log((Throwable)ew);
                    }
                }
                for (Letter letter : list) {
                    JAntiCaptcha.this.removeLetterFromLibrary(letter);
                }
                JAntiCaptcha.this.saveMTHFile();
                JAntiCaptcha.this.displayLibrary();
            }
        });
        w.pack();
        WindowManager.getInstance().setVisible((Window)w, true, WindowManager.FrameState.OS_DEFAULT);
    }

    public String getCodeFromFileName(String name) {
        return new Regex(name, "captcha_(.*?)_code(.*?)\\.(.*?)").getMatch(1);
    }

    public File[] getImages(String path) {
        File dir = new File(path);
        if (dir == null || !dir.exists()) {
            this.logger.severe("Image dir nicht gefunden " + path);
        }
        this.logger.info(dir + "");
        File[] entries = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                JAntiCaptcha.this.logger.info(pathname.getName());
                return pathname.getName().endsWith(".bmp") || pathname.getName().endsWith(".jpg") || pathname.getName().endsWith(".png") || pathname.getName().endsWith(".gif");
            }
        });
        return entries;
    }

    public String getImageType() {
        return this.imageType;
    }

    private void getJACInfo() {
        File f = this.getResourceFile("jacinfo.xml");
        if (!f.exists()) {
            this.logger.severe("jacinfo.xml is missing2");
            return;
        }
        Document doc = JDUtilities.parseXmlString((String)JDIO.readFileToString((File)f));
        if (doc == null) {
            this.logger.severe("jacinfo.xml is missing2");
            return;
        }
        NodeList nl = doc.getFirstChild().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            if (childNode.getNodeName().equals("method")) {
                try {
                    this.extern = JDUtilities.getAttribute((Node)childNode, (String)"type").equalsIgnoreCase("extern");
                }
                catch (Exception exception) {}
                continue;
            }
            if (childNode.getNodeName().equals("command")) {
                this.srcFile = JDUtilities.getAttribute((Node)childNode, (String)"src");
                this.dstFile = JDUtilities.getAttribute((Node)childNode, (String)"dst");
                this.command = JDUtilities.getAttribute((Node)childNode, (String)"cmd");
                continue;
            }
            if (!childNode.getNodeName().equals("format")) continue;
            try {
                this.setLetterNum(Integer.parseInt(JDUtilities.getAttribute((Node)childNode, (String)"letterNum")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setImageType(JDUtilities.getAttribute((Node)childNode, (String)"type"));
        }
    }

    public JACScript getJas() {
        return this.jas;
    }

    public LetterComperator getLetter(Letter letter) throws InterruptedException {
        if (this.jas.getDouble("quickScanValityLimit") <= 0.0) {
            this.logger.info("quickscan disabled");
            return this.getLetterExtended(letter);
        }
        this.logger.info("Work on Letter:" + letter);
        LetterComperator res = null;
        double lastPercent = 100.0;
        try {
            if (this.letterDB == null) {
                this.logger.severe("letterDB nicht vorhanden");
                return null;
            }
            ScrollPaneWindow w = null;
            if (this.isShowDebugGui()) {
                w = new ScrollPaneWindow();
                w.setTitle(" Letter " + letter.getId());
            }
            int bvX = this.jas.getInteger("borderVarianceX");
            int bvY = this.jas.getInteger("borderVarianceY");
            int line = 0;
            LetterComperator lc = new LetterComperator(letter, null);
            lc.setScanVariance(0, 0);
            lc.setOwner(this);
            res = lc;
            int tt = 0;
            this.logger.info("Do quickscan");
            Method preValueFilterMethod = null;
            Class[] preValueFilterParameterTypes = null;
            Object[] preValueFilterArguments = new Object[]{null, this};
            if (this.jas.getString("preValueFilter").length() > 0) {
                String[] ref = this.jas.getString("preValueFilter").split("\\.");
                if (ref.length != 2) {
                    this.logger.severe("preValueFilter should have the format Class.Method");
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    preValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    preValueFilterMethod = newClass.getMethod(methodname, preValueFilterParameterTypes);
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
            Method postValueFilterMethod = null;
            Class[] postValueFilterParameterTypes = null;
            Object[] postValueFilterArguments = new Object[]{null, this};
            if (this.jas.getString("postValueFilter").length() > 0) {
                String[] ref = this.jas.getString("postValueFilter").split("\\.");
                if (ref.length != 2) {
                    this.logger.severe("postValueFilter should have the format Class.Method");
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    postValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    postValueFilterMethod = newClass.getMethod(methodname, postValueFilterParameterTypes);
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
            for (Letter tmp : this.letterDB) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (Math.abs(tmp.getHeight() - letter.getHeight()) > bvY || Math.abs(tmp.getWidth() - letter.getWidth()) > bvX) continue;
                lc = new LetterComperator(letter, tmp);
                lc.setOwner(this);
                if (preValueFilterMethod != null) {
                    preValueFilterArguments[0] = tmp;
                    preValueFilterArguments[1] = lc;
                    if (!((Boolean)preValueFilterMethod.invoke(null, preValueFilterArguments)).booleanValue()) continue;
                }
                lc.run();
                ++tt;
                if (this.isShowDebugGui()) {
                    w.setText(0, line, "0\u00b0 Quick " + tt);
                    w.setImage(1, line, lc.getA().getImage(2));
                    w.setText(2, line, lc.getA().getDim());
                    w.setImage(3, line, lc.getB().getImage(2));
                    w.setText(4, line, lc.getB().getDim());
                    w.setImage(5, line, lc.getIntersectionLetter().getImage(2));
                    w.setText(6, line, lc.getIntersectionLetter().getDim());
                    w.setText(7, line, lc);
                    ++line;
                }
                postValueFilterArguments[0] = lc;
                if (postValueFilterMethod != null && !((Boolean)postValueFilterMethod.invoke(null, postValueFilterArguments)).booleanValue()) continue;
                if (res == null || lc.getValityPercent() < res.getValityPercent()) {
                    if (res != null && res.getValityPercent() < lastPercent) {
                        lastPercent = res.getValityPercent();
                    }
                    res = lc;
                    if (!(this.jas.getDouble("LetterSearchLimitPerfectPercent") >= lc.getValityPercent())) continue;
                    this.logger.finer(" Perfect Match: " + res.getB().getDecodedValue() + res.getValityPercent() + " good:" + tmp.getGoodDetections() + " bad: " + tmp.getBadDetections() + " - " + res);
                    res.setDetectionType(3);
                    res.setReliability(lastPercent - res.getValityPercent());
                    return res;
                }
                if (res == null || !(lc.getValityPercent() < lastPercent)) continue;
                lastPercent = lc.getValityPercent();
            }
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
        if (res != null && res.getB() != null) {
            this.logger.finer(" Normal Match: " + res.getB().getDecodedValue() + " " + res.getValityPercent() + " good:" + res.getB().getGoodDetections() + " bad: " + res.getB().getBadDetections());
            res.setReliability(lastPercent - res.getValityPercent());
            if (res.getReliability() >= this.jas.getDouble("quickScanReliabilityLimit") && res.getValityPercent() < this.jas.getDouble("quickScanValityLimit")) {
                res.setDetectionType(2);
                this.logger.info("Qickscan found " + res.getValityPercent() + "<" + this.jas.getDouble("quickScanValityLimit"));
                return res;
            }
            this.logger.warning("Letter nicht ausreichend erkannt. Try Extended " + res.getReliability() + " - " + this.jas.getDouble("quickScanReliabilityLimit") + " /" + res.getValityPercent() + "-" + this.jas.getDouble("quickScanValityLimit"));
            return this.getLetterExtended(letter);
        }
        this.logger.warning("Letter nicht erkannt. Try Extended");
        return this.getLetterExtended(letter);
    }

    private LetterComperator getLetterExtended(Letter letter) throws InterruptedException {
        LetterComperator res = null;
        this.logger.info("Extended SCAN");
        double lastPercent = 100.0;
        JComponent tf = null;
        try {
            int rightAngle;
            if (this.letterDB == null) {
                this.logger.severe("letterDB nicht vorhanden");
                return null;
            }
            int leftAngle = this.jas.getInteger("scanAngleLeft");
            if (leftAngle > (rightAngle = this.jas.getInteger("scanAngleRight"))) {
                int temp = leftAngle;
                leftAngle = rightAngle;
                rightAngle = temp;
                this.logger.warning("param.scanAngleLeft>paramscanAngleRight");
            }
            int steps = Math.max(1, this.jas.getInteger("scanAngleSteps"));
            boolean turnDB = this.jas.getBoolean("turnDB");
            Letter orgLetter = letter;
            ScrollPaneWindow w = null;
            if (this.isShowDebugGui()) {
                w = new ScrollPaneWindow();
                w.setTitle(" Letter " + letter.getId());
            }
            int line = 0;
            LetterComperator lc = new LetterComperator(letter, null);
            lc.setOwner(this);
            res = lc;
            Method preValueFilterMethod = null;
            Class[] preValueFilterParameterTypes = null;
            Object[] preValueFilterArguments = new Object[]{null, this};
            if (this.jas.getString("preValueFilter").length() > 0) {
                String[] ref = this.jas.getString("preValueFilter").split("\\.");
                if (ref.length != 2) {
                    this.logger.severe("preValueFilter should have the format Class.Method");
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    preValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    preValueFilterMethod = newClass.getMethod(methodname, preValueFilterParameterTypes);
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
            Method postValueFilterMethod = null;
            Class[] postValueFilterParameterTypes = null;
            Object[] postValueFilterArguments = new Object[]{null, this};
            if (this.jas.getString("postValueFilter").length() > 0) {
                String[] ref = this.jas.getString("postValueFilter").split("\\.");
                if (ref.length != 2) {
                    this.logger.severe("postValueFilter should have the format Class.Method");
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    postValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    postValueFilterMethod = newClass.getMethod(methodname, postValueFilterParameterTypes);
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            }
            int angle = Utilities.getJumperStart(leftAngle, rightAngle);
            while (Utilities.checkJumper(angle, leftAngle, rightAngle)) {
                letter = turnDB ? orgLetter : orgLetter.turn(angle);
                int tt = 0;
                for (Letter ltr : this.letterDB) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    Letter tmp = turnDB ? ltr.turn(angle) : ltr;
                    if (Math.abs(tmp.getHeight() - letter.getHeight()) > this.jas.getInteger("borderVarianceY") || Math.abs(tmp.getWidth() - letter.getWidth()) > this.jas.getInteger("borderVarianceX")) continue;
                    lc = new LetterComperator(letter, tmp);
                    lc.setOwner(this);
                    if (preValueFilterMethod != null) {
                        preValueFilterArguments[0] = lc;
                        preValueFilterArguments[1] = this;
                        if (!((Boolean)preValueFilterMethod.invoke(null, preValueFilterArguments)).booleanValue()) continue;
                    }
                    lc.run();
                    ++tt;
                    if (this.isShowDebugGui()) {
                        w.setText(0, line, angle + "\u00b0 " + tt);
                        w.setImage(1, line, lc.getA().getImage(2));
                        w.setText(2, line, lc.getA().getDim());
                        w.setImage(3, line, lc.getB().getImage(2));
                        w.setText(4, line, lc.getB().getDim());
                        w.setImage(5, line, lc.getIntersectionLetter().getImage(2));
                        w.setText(6, line, lc.getIntersectionLetter().getDim());
                        tf = new JTextArea();
                        w.setComponent(7, line, tf);
                        ((JTextComponent)tf).setText(lc.toString());
                        if (lc.getPreValityPercent() > (double)this.jas.getInteger("preScanFilter") && this.jas.getInteger("preScanFilter") > 0) {
                            tf.setBackground(Color.LIGHT_GRAY);
                        }
                        ++line;
                    }
                    postValueFilterArguments[0] = lc;
                    if (postValueFilterMethod != null && !((Boolean)postValueFilterMethod.invoke(null, postValueFilterArguments)).booleanValue()) continue;
                    if (res == null || lc.getValityPercent() < res.getValityPercent()) {
                        if (res != null && res.getValityPercent() < lastPercent) {
                            lastPercent = res.getValityPercent();
                        }
                        res = lc;
                        if (this.jas.getDouble("LetterSearchLimitPerfectPercent") >= lc.getValityPercent()) {
                            res.setDetectionType(1);
                            res.setReliability(lastPercent - res.getValityPercent());
                            this.logger.finer(" Perfect Match: " + res.getB().getDecodedValue() + " " + res.getValityPercent() + " good:" + tmp.getGoodDetections() + " bad: " + tmp.getBadDetections() + " - " + res);
                            if (this.isShowDebugGui()) {
                                tf.setBackground(Color.GREEN);
                            }
                            return res;
                        }
                        if (this.isShowDebugGui()) {
                            tf.setBackground(Color.BLUE);
                        }
                        this.logger.finer("Angle " + angle + "dim " + lc.getA().getDim() + "|" + lc.getB().getDim() + " New Best value: " + lc.getDecodedValue() + " " + lc.getValityPercent() + " good:" + tmp.getGoodDetections() + " bad: " + tmp.getBadDetections() + " - " + lc);
                        continue;
                    }
                    if (res == null || !(lc.getValityPercent() < lastPercent)) continue;
                    lastPercent = lc.getValityPercent();
                }
                angle = Utilities.nextJump(angle, leftAngle, rightAngle, steps);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
        if (res != null && res.getB() != null) {
            this.logger.finer(" Normal Match: " + res.getB().getDecodedValue() + " " + res.getValityPercent() + " good:" + res.getB().getGoodDetections() + " bad: " + res.getB().getBadDetections());
            res.setReliability(lastPercent - res.getValityPercent());
        } else {
            if (this.getJas().getInteger("preScanEmergencyFilter") > this.getJas().getInteger("preScanFilter")) {
                this.logger.warning("nicht erkannt. Verwende erweiterte Emergencydatenbank");
                int psf = this.getJas().getInteger("preScanFilter");
                this.getJas().set("preScanFilter", this.getJas().getInteger("preScanEmergencyFilter"));
                LetterComperator ret = this.getLetterExtended(letter);
                this.getJas().set("preScanFilter", psf);
                return ret;
            }
            this.logger.severe("Letter entg\u00fcltig nicht erkannt");
            if (this.isShowDebugGui() && tf != null) {
                tf.setBackground(Color.RED);
            }
        }
        return res;
    }

    private String getLetterMapString() {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        for (int x = 0; x < this.letterMap.length; ++x) {
            ret.append("|");
            ++i;
            for (int y = 0; y < this.letterMap[0].length; ++y) {
                ret.append(this.letterMap[x][y]);
                ++i;
                ret.append(",");
                ++i;
            }
            ret.deleteCharAt(ret.length() - 1);
            this.logger.fine("Db String: " + x * 100 / this.letterDB.size() + "%");
        }
        ret.deleteCharAt(0);
        return ret.toString();
    }

    public int getLetterNum() {
        return this.letterNum;
    }

    public String getMethodDirName() {
        return this.methodDirName;
    }

    public File getResourceFile(String arg) {
        return JDUtilities.getResourceFile((String)(JDUtilities.getJACMethodsDirectory() + this.methodDirName + "/" + arg));
    }

    public Captcha getWorkingCaptcha() {
        return this.workingCaptcha;
    }

    public void importDB(File path) throws InterruptedException {
        File[] images;
        String pattern = JOptionPane.showInputDialog("PATTERN", (Object)"\\d+_(.*?)\\.");
        if (JOptionPane.showConfirmDialog(null, "Delete old db?") == 0) {
            this.letterDB = new ArrayList<Letter>();
        }
        FileCreationManager.getInstance().delete(this.getResourceFile("letters.mth"), null);
        System.out.println("LETTERS BEFORE: " + this.letterDB.size());
        for (File element : images = this.getImages(path.getAbsolutePath())) {
            Image image = Utilities.loadImage(element);
            try {
                image = ImageProvider.read((File)element);
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
            }
            System.out.println(element.getAbsolutePath());
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width <= 0 || height <= 0) {
                this.logger.severe("ERROR: Image nicht korrekt.");
            }
            Captcha cap = this.createCaptcha(image);
            Letter letter = new Letter();
            letter.setOwner(this);
            letter.setGrid(cap.grid);
            letter.setSourcehash(JDHash.getMD5((File)element));
            String let = new Regex(element.getName(), pattern).getMatch(0);
            letter.setDecodedValue(let);
            letter.clean();
            letter.removeSmallObjects(0.3, 0.5, 10);
            letter.setDecodedValue(let);
            this.letterDB.add(letter);
        }
        System.out.println("LETTERS AFTER: " + this.letterDB.size());
        this.sortLetterDB();
        this.saveMTHFile();
    }

    private boolean isCaptchaInMTH(String captchaHash) {
        if (this.letterDB == null) {
            return false;
        }
        for (Letter letter : this.letterDB) {
            if (!letter.getSourcehash().equals(captchaHash)) continue;
            return true;
        }
        return false;
    }

    public boolean isShowDebugGui() {
        return this.showDebugGui;
    }

    public void loadMTHFile(File f) {
        String str = null;
        str = f.exists() ? JDIO.readFileToString((File)f) : "<jDownloader></jDownloader>";
        Document mth = JDUtilities.parseXmlString((String)str);
        this.logger.info("Get file: " + f);
        if (mth == null) {
            this.logger.severe("MTH FILE NOT AVAILABLE.");
        }
        this.createLetterDBFormMTH(mth);
    }

    public void loadMTHFile() {
        File f = this.getResourceFile("letters.mth");
        this.loadMTHFile(f);
    }

    public void removeBadLetters() {
        this.logger.info("aktuelle DB Size: " + this.letterDB.size());
        ListIterator<Letter> iter = this.letterDB.listIterator(this.letterDB.size());
        while (iter.hasPrevious()) {
            Letter tmp = iter.previous();
            if (tmp.getBadDetections() <= tmp.getGoodDetections() + 2) continue;
            this.logger.info("bad Letter entfernt: " + tmp.getDecodedValue() + " (" + tmp.getBadDetections() + "/" + tmp.getGoodDetections() + ")");
            iter.remove();
        }
        this.logger.info("neue DB Size: " + this.letterDB.size());
        this.sortLetterDB();
        this.saveMTHFile();
    }

    protected void removeLetterFromLibrary(Letter letter) {
        this.logger.info("Remove" + letter + " : " + this.letterDB.remove(letter));
    }

    public synchronized void saveMTHFile() {
        String xmlString = JDUtilities.createXmlString((Document)this.createXMLFromLetterDB());
        if (!JDIO.writeLocalFile((File)this.getResourceFile("letters.mth"), (String)xmlString)) {
            this.logger.severe("MTHO file Konnte nicht gespeichert werden");
        }
    }

    public void setImageType(String imageType) {
        this.logger.finer("SET PARAMETER: [imageType] = " + imageType);
        this.imageType = imageType;
    }

    public void setLetterNum(int letterNum) {
        this.logger.finer("SET PARAMETER: [letterNum] = " + letterNum);
        this.letterNum = letterNum;
    }

    public void setShowDebugGui(boolean showDebugGui) {
        this.showDebugGui = showDebugGui;
    }

    public void setWorkingCaptcha(Captcha workingCaptcha) {
        this.workingCaptcha = workingCaptcha;
    }

    public void showPreparedCaptcha(final File captchafile) throws InterruptedException {
        if (!captchafile.exists()) {
            this.logger.severe(captchafile.getAbsolutePath() + " existiert nicht");
            return;
        }
        Image captchaImage = Utilities.loadImage(captchafile);
        BasicWindow.showImage(captchaImage);
        Captcha captcha = this.createCaptcha(captchaImage);
        int skWidth = captcha.getWidth();
        int skHeight = captcha.getHeight();
        if (skHeight > 200 || skWidth > 200) {
            if (skHeight > skWidth) {
                skWidth = 200 * skWidth / skHeight;
                skHeight = 200;
            } else {
                skHeight = 200 * skHeight / skWidth;
                skWidth = 200;
            }
        }
        this.logger.info("CAPTCHA :_" + this.checkCaptcha(captchafile, captcha));
        if (this.bw3 != null) {
            this.bw3.dispose();
        }
        this.bw3 = BasicWindow.showImage(captchaImage.getScaledInstance(skWidth, skHeight, 1), "Captchas");
        this.bw3.add(new JLabel("ORIGINAL"), Utilities.getGBC(2, 0, 2, 2));
        this.bw3.setLocationByScreenPercent(50, 70);
        this.bw3.add(new ImageComponent(captcha.getImage(1).getScaledInstance(skWidth, skHeight, 1)), Utilities.getGBC(0, 2, 2, 2));
        this.bw3.add(new JLabel("Farbraum Anpassung"), Utilities.getGBC(2, 2, 2, 2));
        this.jas.executePrepareCommands(captchafile, captcha);
        this.bw3.add(new ImageComponent(captcha.getImage(1).getScaledInstance(skWidth, skHeight, 1)), Utilities.getGBC(0, 4, 2, 2));
        this.bw3.add(new JLabel("Prepare Code ausgef\u00fchrt"), Utilities.getGBC(2, 4, 2, 2));
        Letter[] letters = captcha.getLetters(this.letterNum);
        if (letters == null) {
            this.logger.severe("2. Lettererkennung ist fehlgeschlagen!");
            return;
        }
        this.bw3.add(new ImageComponent(captcha.getImageWithGaps(1).getScaledInstance(skWidth, skHeight, 1)), Utilities.getGBC(0, 6, 2, 2));
        this.bw3.add(new JLabel("Buchstaben freistellen"), Utilities.getGBC(2, 6, 2, 2));
        this.bw3.refreshUI();
        if (this.bw2 != null) {
            this.bw2.destroy();
        }
        this.bw2 = new BasicWindow();
        this.bw2.setTitle("Freigestellte Buchstaben");
        this.bw2.setLayout(new GridBagLayout());
        this.bw2.setSize(300, 300);
        this.logger.info("display freistellen");
        this.bw2.setAlwaysOnTop(true);
        this.bw2.setLocationByScreenPercent(50, 5);
        this.bw2.add(new JLabel("Aus Captcha:"), Utilities.getGBC(0, 0, 2, 2));
        for (int i = 0; i < letters.length; ++i) {
            this.bw2.add(new ImageComponent(letters[i].getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 2, 0, 2, 2));
        }
        WindowManager.getInstance().setVisible((Window)((Object)this.bw2), true, WindowManager.FrameState.OS_DEFAULT);
        this.bw2.pack();
        this.bw2.setSize(300, this.bw2.getSize().height);
        LetterComperator[] lcs = captcha.getLetterComperators();
        for (int i = 0; i < lcs.length; ++i) {
            if (lcs[i] == null) continue;
            this.bw2.add(new JLabel("Aus Datenbank:"), Utilities.getGBC(0, 6, 2, 2));
            Letter dif = lcs[i].getDifference();
            dif.removeSmallObjects(0.8, 0.8, 5);
            dif.clean();
            if (lcs[i].getB() != null) {
                this.bw2.add(new ImageComponent(lcs[i].getB().getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 2, 6, 2, 1));
                this.bw2.add(new ImageComponent(dif.getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 2, 7, 2, 1));
            } else {
                this.bw2.add(new JLabel("B unknown"), Utilities.getGBC(i * 2 + 2, 6, 2, 2));
            }
            this.bw2.add(new JLabel("Wert:"), Utilities.getGBC(0, 8, 2, 2));
            this.bw2.add(new JLabel("Proz.:"), Utilities.getGBC(0, 10, 2, 2));
            this.bw2.add(new JLabel(lcs[i].getValityPercent() + "%"), Utilities.getGBC(i * 2 + 2, 10, 2, 2));
        }
        JButton bt = new JButton("Train");
        this.bw2.add(bt, Utilities.getGBC(0, 12, 2, 2));
        this.bw2.pack();
        this.bw2.repack();
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAntiCaptcha.this.trainCaptcha(captchafile, 4);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public void sortLetterDB() {
        Collections.sort(this.letterDB, new Comparator<Letter>(){

            @Override
            public int compare(Letter a, Letter b) {
                try {
                    return a.getDecodedValue().compareToIgnoreCase(b.getDecodedValue()) * -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }

    public void trainAllCaptchas(String path) throws InterruptedException {
        int successFull = 0;
        int total = 0;
        this.logger.info("TRain " + path);
        File[] images = this.getImages(path);
        if (images == null) {
            return;
        }
        for (File element : images) {
            this.logger.fine(element.toString());
            int letternum = this.getLetterNum();
            int newLetters = this.trainCaptcha(element, letternum);
            this.logger.fine("Erkannt: " + newLetters + "/" + this.getLetterNum());
            if (newLetters > 0) {
                this.logger.info("Erkennungsrate: " + 100 * (successFull += newLetters) / (total += this.getLetterNum()));
                continue;
            }
            if (newLetters != -2) continue;
            if (this.f == null) break;
            this.f.dispose();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trainCaptcha(final File captchafile, int letterNum) throws InterruptedException {
        String captchaHash;
        if (!captchafile.exists()) {
            this.logger.severe(captchafile.getAbsolutePath() + " existiert nicht");
            return -1;
        }
        if (this.isShowDebugGui()) {
            this.destroyScrollPaneWindows();
        }
        if (this.isCaptchaInMTH(captchaHash = JDHash.getMD5((File)captchafile))) {
            this.logger.fine("Captcha schon aufgenommen" + captchafile);
            return -1;
        }
        Image captchaImage = Utilities.loadImage(captchafile);
        Captcha captcha = this.createCaptcha(captchaImage);
        BasicWindow.showImage(captcha.getImage(), "Captchas");
        int sk1Width = captcha.getWidth();
        int sk1Height = captcha.getHeight();
        if (sk1Height > 200 || sk1Width > 200) {
            if (sk1Height > sk1Width) {
                sk1Width = 200 * sk1Width / sk1Height;
                sk1Height = 200;
            } else {
                sk1Height = 200 * sk1Height / sk1Width;
                sk1Width = 200;
            }
        }
        int skWidth = sk1Width;
        int skHeight = sk1Height;
        String code = null;
        if (this.f != null) {
            this.f.dispose();
        }
        this.f = new JDialog(DummyFrame.getDialogParent());
        this.f.setLocation(500, 10);
        this.f.setLayout(new GridBagLayout());
        this.f.add((Component)new JLabel("original captcha: " + captchafile.getName()), Utilities.getGBC(0, 0, 10, 1));
        this.f.add((Component)new ImageComponent(captcha.getImage()), Utilities.getGBC(0, 1, 10, 1));
        this.f.setSize(1400, 800);
        this.f.pack();
        WindowManager.getInstance().setVisible((Window)this.f, true, WindowManager.FrameState.OS_DEFAULT);
        final String guess = this.checkCaptcha(captchafile, captcha);
        final Letter[] letters = captcha.getLetters(letterNum);
        if (letters == null) {
            File file = this.getResourceFile("detectionErrors5/" + System.currentTimeMillis() + "_" + captchafile.getName());
            FileCreationManager.getInstance().mkdir(file.getParentFile());
            captchafile.renameTo(file);
            this.logger.severe("Letter detection error");
            return -1;
        }
        class MyRunnable
        implements Runnable {
            private String code = null;
            private int ret = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (JAntiCaptcha.this.getCodeFromFileName(captchafile.getName()) == null) {
                    this.code = JOptionPane.showInputDialog("Bitte Captcha Code eingeben (Press enter to confirm " + guess, (Object)guess);
                    if (this.code != null && this.code.equals(guess)) {
                        this.code = "";
                    } else if (this.code == null && JOptionPane.showConfirmDialog(new JFrame(), "Ja (yes) = beenden (close) \t Nein (no) = n\u00e4chstes Captcha (next captcha)") == 0) {
                        this.ret = -2;
                    }
                } else {
                    this.code = JAntiCaptcha.this.getCodeFromFileName(captchafile.getName());
                    JAntiCaptcha.this.logger.warning("captcha code f\u00fcr " + captchaHash + " verwendet: " + this.code);
                }
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    this.notify();
                }
            }
        }
        MyRunnable run = new MyRunnable();
        Thread inpThread = new Thread(run);
        inpThread.start();
        this.f.add((Component)new JLabel("Letter Detection"), Utilities.getGBC(0, 3, 10, 1));
        this.f.add((Component)new ImageComponent(captcha.getImageWithGaps(1).getScaledInstance(skWidth, skHeight, 1)), Utilities.getGBC(0, 4, 10, 1));
        this.f.add((Component)new JLabel("Seperated"), Utilities.getGBC(0, 5, 10, 1));
        for (int i = 0; i < letters.length; ++i) {
            this.f.add((Component)new ImageComponent(letters[i].getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 1, 6, 1, 1));
            JLabel jl = new JLabel("|");
            jl.setForeground(Color.RED);
            this.f.add((Component)jl, Utilities.getGBC(i * 2 + 2, 6, 1, 1));
        }
        this.f.pack();
        LetterComperator[] lcs = captcha.getLetterComperators();
        if (lcs == null) {
            File file = this.getResourceFile("detectionErrors5/" + System.currentTimeMillis() + "_" + captchafile.getName());
            FileCreationManager.getInstance().mkdir(file.getParentFile());
            captchafile.renameTo(file);
            this.logger.severe("Letter detection error");
            return -1;
        }
        if (lcs.length != letters.length) {
            this.logger.severe("ACHTUNG. lcs: " + lcs.length + " - letters: " + letters.length);
        }
        if (guess != null) {
            JLabel jl;
            int i;
            this.f.add((Component)new JLabel("Letter Detection"), Utilities.getGBC(0, 3, 10, 1));
            this.f.add((Component)new ImageComponent(captcha.getImageWithGaps(1).getScaledInstance(skWidth, skHeight, 1)), Utilities.getGBC(0, 4, 10, 1));
            this.f.add((Component)new JLabel("Seperated"), Utilities.getGBC(0, 5, 10, 1));
            for (i = 0; i < letters.length; ++i) {
                this.f.add((Component)new ImageComponent(letters[i].getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 1, 6, 1, 1));
                jl = new JLabel("|");
                jl.setForeground(Color.RED);
                this.f.add((Component)jl, Utilities.getGBC(i * 2 + 2, 6, 1, 1));
            }
            this.f.pack();
            for (i = 0; i < lcs.length; ++i) {
                if (lcs[i] != null && lcs[i].getB() != null) {
                    this.f.add((Component)new ImageComponent(lcs[i].getB().getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 1, 8, 1, 1));
                } else {
                    this.f.add((Component)new JLabel(""), Utilities.getGBC(i * 2 + 1, 8, 1, 1));
                }
                jl = new JLabel("|");
                jl.setForeground(Color.RED);
                this.f.add((Component)jl, Utilities.getGBC(i * 2 + 2, 6, 1, 1));
                if (lcs[i] != null && lcs[i].getB() != null) {
                    this.f.add((Component)new JLabel("" + lcs[i].getDecodedValue()), Utilities.getGBC(i * 2 + 1, 9, 1, 1));
                } else {
                    this.f.add((Component)new JLabel(""), Utilities.getGBC(i * 2 + 1, 9, 1, 1));
                }
                if (lcs[i] != null && lcs[i].getB() != null) {
                    this.f.add((Component)new JLabel("" + (double)Math.round(10.0 * lcs[i].getValityPercent()) / 10.0), Utilities.getGBC(i * 2 + 1, 10, 1, 1));
                    continue;
                }
                this.f.add((Component)new JLabel(""), Utilities.getGBC(i * 2 + 1, 10, 1, 1));
            }
            this.f.pack();
        } else {
            this.logger.warning("Erkennung fehlgeschlagen");
        }
        this.f.add((Component)new JLabel("prepared captcha"), Utilities.getGBC(0, 11, 10, 1));
        this.f.add((Component)new ImageComponent(captcha.getImage().getScaledInstance(skWidth, skHeight, 1)), Utilities.getGBC(0, 12, 10, 1));
        this.f.pack();
        this.logger.info("Decoded Captcha: " + guess + " Vality: " + captcha.getValityPercent());
        if (inpThread.isAlive()) {
            MyRunnable i = run;
            synchronized (i) {
                try {
                    run.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (run.ret == -2) {
            return -2;
        }
        code = run.code;
        if (code == null) {
            File file = this.getResourceFile("detectionErrors3/" + System.currentTimeMillis() + "_" + captchafile.getName());
            FileCreationManager.getInstance().mkdir(file.getParentFile());
            captchafile.renameTo(file);
            this.logger.severe("Captcha Input error");
            return -1;
        }
        if (code.length() == 0) {
            code = guess;
        }
        if (code.length() != letters.length) {
            File file = this.getResourceFile("detectionErrors4/" + System.currentTimeMillis() + "_" + captchafile.getName());
            FileCreationManager.getInstance().mkdir(file.getParentFile());
            captchafile.renameTo(file);
            this.logger.severe("Captcha Input error3");
            return -1;
        }
        if (code.indexOf("-") < 0) {
            String[] oldName = captchafile.getName().split("\\.");
            String ext = oldName[oldName.length - 1];
            String newName = captchafile.getParentFile().getAbsolutePath() + "/captcha_" + this.getMethodDirName() + "_code" + code + "." + ext;
            captchafile.renameTo(new File(newName));
        }
        int ret = 0;
        for (int j = 0; j < letters.length; ++j) {
            final int i = j;
            if (!code.substring(i, i + 1).equals("-")) {
                if (guess != null && code.length() > i && guess.length() > i && code.substring(i, i + 1).equals(guess.substring(i, i + 1))) {
                    ++ret;
                    if (lcs[i] != null) {
                        lcs[i].getB().markGood();
                    }
                    if (lcs[i].getValityPercent() > 50.0) {
                        letters[i].setOwner(this);
                        letters[i].setSourcehash(captchaHash);
                        letters[i].setDecodedValue(code.substring(i, i + 1));
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                BasicWindow bws = BasicWindow.showImage(letters[i].getImage(2), "" + letters[i].getDecodedValue());
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                bws.dispose();
                            }
                        }).start();
                        this.letterDB.add(letters[i]);
                    }
                    if (!this.jas.getBoolean("TrainOnlyUnknown")) {
                        letters[i].setOwner(this);
                        letters[i].setSourcehash(captchaHash);
                        letters[i].setDecodedValue(code.substring(i, i + 1));
                        this.letterDB.add(letters[i]);
                        this.f.add((Component)new JLabel("OK+"), Utilities.getGBC(i + 1, 13, 1, 1));
                        continue;
                    }
                    this.f.add((Component)new JLabel("OK-"), Utilities.getGBC(i + 1, 13, 1, 1));
                    this.f.pack();
                    continue;
                }
                this.logger.info(this.letterDB + " - ");
                if (lcs != null && lcs[i] != null && this.letterDB.size() > 30 && lcs[i] != null && lcs[i].getB() != null) {
                    lcs[i].getB().markBad();
                }
                letters[i].setOwner(this);
                letters[i].setSourcehash(captchaHash);
                letters[i].setDecodedValue(code.substring(i, i + 1));
                this.letterDB.add(letters[i]);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BasicWindow bws = BasicWindow.showImage(letters[i].getImage(2), "" + letters[i].getDecodedValue());
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        bws.dispose();
                    }
                }).start();
                this.f.add((Component)new JLabel("NO +"), Utilities.getGBC(i + 1, 13, 1, 1));
                this.f.pack();
                continue;
            }
            this.f.add((Component)new JLabel("-"), Utilities.getGBC(i + 1, 13, 1, 1));
            this.f.pack();
        }
        this.sortLetterDB();
        new Thread(new Runnable(){

            @Override
            public void run() {
                JAntiCaptcha.this.saveMTHFile();
            }
        }).start();
        return ret;
    }

    public void cleanLibrary(double d) {
        ArrayList<Letter> newDB = new ArrayList<Letter>();
        block0: for (Letter let : this.letterDB) {
            for (Letter n : newDB) {
                if (!let.getDecodedValue().endsWith(n.getDecodedValue())) continue;
                LetterComperator lc = new LetterComperator(let, n);
                lc.setOwner(this);
                lc.run();
                n.getElementPixel();
                if (!(lc.getValityPercent() <= d)) continue;
                BasicWindow.showImage(let.getImage(), " OK ");
                if (n.getElementPixel() <= let.getElementPixel()) continue block0;
                newDB.remove(let);
                break;
            }
            newDB.add(let);
        }
        this.letterDB = newDB;
        this.saveMTHFile();
    }

    public static String getCaptcha(String path, String host) {
        if (JACMethod.hasMethod(host)) {
            File file;
            if (path.contains("http://")) {
                try {
                    file = JDUtilities.getResourceFile((String)"captchas/jac_captcha.img");
                    file.deleteOnExit();
                    Browser.download((File)file, (URLConnectionAdapter)new Browser().openGetConnection(path));
                }
                catch (IOException e) {
                    LogController.CL().log((Throwable)e);
                    return "Could not download captcha image";
                }
            } else {
                file = new File(path);
                if (!file.exists()) {
                    return "File does not exist";
                }
            }
            try {
                BufferedImage captchaImage = ImageProvider.read((File)file);
                JAntiCaptcha jac = new JAntiCaptcha(host);
                Captcha captcha = jac.createCaptcha(captchaImage);
                return jac.checkCaptcha(file, captcha);
            }
            catch (Exception e) {
                LogController.CL().log((Throwable)e);
                return Arrays.toString(e.getStackTrace());
            }
        }
        return "jDownloader has no method for " + host;
    }
}

