/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObjectColor;
import jd.captcha.utils.Utilities;
import jd.nutils.Colors;
import org.jdownloader.logging.LogController;

public class PixelObject
implements Comparable<PixelObject> {
    private int avg = 0;
    private int avgIsSaveNum = 10;
    private boolean bordered = true;
    private HashMap<Integer, HashMap<Integer, int[]>> grid;
    public List<PixelObjectColor> colors = new ArrayList<PixelObjectColor>();
    private double contrast;
    public LetterComperator detected = null;
    private int noAvgChanges = 0;
    private List<int[]> object;
    public PixelGrid owner;
    private int saveAvg = 0;
    private double whiteContrast = 1.0;
    private int xMax = Integer.MIN_VALUE;
    private int xMin = Integer.MAX_VALUE;
    private int yMax = Integer.MIN_VALUE;
    private int yMin = Integer.MAX_VALUE;

    public int getMostcolor() {
        Collections.sort(this.colors);
        if (this.colors.size() > 0) {
            return this.colors.get((int)0).color;
        }
        return this.getAverage();
    }

    public PixelObject(PixelGrid grid) {
        this.owner = grid;
        this.grid = new HashMap();
        this.object = new ArrayList<int[]>();
    }

    public boolean addColor(int color) {
        PixelObjectColor poc = new PixelObjectColor(color);
        int io = this.colors.indexOf(poc);
        if (io == -1) {
            this.colors.add(poc);
            return true;
        }
        ++this.colors.get((int)io).count;
        return false;
    }

    public void add(int x, int y, int color) {
        HashMap<Integer, Object> row;
        int[] tmp = new int[]{x, y, color};
        int tmpAvg = this.avg;
        if (color >= 0) {
            this.avg = Colors.mixColors((int)this.avg, (int)color, (int)this.getSize(), (int)1);
            this.addColor(color);
        }
        if ((row = this.grid.get(x)) == null) {
            row = new HashMap();
            this.grid.put(x, row);
        }
        row.put(y, new int[]{x, y, color});
        if ((double)Math.abs(this.avg - tmpAvg) < (double)this.owner.getMaxPixelValue() * this.contrast) {
            ++this.noAvgChanges;
            if (this.avgIsSaveNum <= this.noAvgChanges && this.saveAvg == 0) {
                this.saveAvg = this.avg;
            }
        } else {
            this.noAvgChanges = 0;
        }
        this.object.add(tmp);
        this.xMin = Math.min(x, this.xMin);
        this.xMax = Math.max(x, this.xMax);
        this.yMin = Math.min(y, this.yMin);
        this.yMax = Math.max(y, this.yMax);
    }

    public void add(PixelObject current) {
        this.avg = Colors.mixColors((int)this.avg, (int)current.getAverage(), (int)this.getSize(), (int)current.getSize());
        this.xMin = Math.min(current.xMin, this.xMin);
        this.xMax = Math.max(current.xMax, this.xMax);
        this.yMin = Math.min(current.yMin, this.yMin);
        this.yMax = Math.max(current.yMax, this.yMax);
        for (Map.Entry<Integer, HashMap<Integer, int[]>> set : current.grid.entrySet()) {
            HashMap<Integer, int[]> row = this.grid.get(set.getKey());
            if (row == null) {
                this.grid.put(set.getKey(), set.getValue());
                continue;
            }
            row.putAll((Map<Integer, int[]>)set.getValue());
        }
        for (int i = 0; i < current.object.size(); ++i) {
            int[] ob = current.object.get(i);
            this.object.add(new int[]{ob[0], ob[1], -1});
        }
    }

    public void del(PixelObject current) {
        block0: for (int i = 0; i < current.object.size(); ++i) {
            int x = current.object.get(i)[0];
            int y = current.object.get(i)[1];
            Iterator<int[]> iterator = this.object.iterator();
            while (iterator.hasNext()) {
                int[] o = iterator.next();
                if (o[0] != x || o[1] != y) continue;
                iterator.remove();
                continue block0;
            }
        }
        this.xMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        this.yMin = Integer.MAX_VALUE;
        this.yMax = Integer.MIN_VALUE;
        this.colors = new ArrayList<PixelObjectColor>();
        for (int[] o : this.object) {
            this.addColor(this.owner.getPixelValue(o[0], o[1]));
            this.xMin = Math.min(o[0], this.xMin);
            this.xMax = Math.max(o[0], this.xMax);
            this.yMin = Math.min(o[1], this.yMin);
            this.yMax = Math.max(o[1], this.yMax);
        }
    }

    public int getYMax() {
        return this.yMax;
    }

    public int getXMax() {
        return this.xMax;
    }

    public boolean isTouching(PixelObject b, boolean followX, int radiusX, int radiusY) {
        if (b.getXMin() > this.getXMax() + radiusX) {
            return false;
        }
        if (b.getXMax() < this.getXMin() - radiusY) {
            return false;
        }
        if (b.getYMin() > this.getYMax() + radiusX) {
            return false;
        }
        if (b.getYMax() < this.getYMin() - radiusY) {
            return false;
        }
        for (int[] px : b.object) {
            for (int sx = -radiusX; sx <= radiusX; ++sx) {
                HashMap<Integer, int[]> row = this.grid.get(px[0] + sx);
                if (row == null) continue;
                for (int sy = -radiusY; sy <= radiusY; ++sy) {
                    if (Math.abs(sx) == Math.abs(sy) && !followX || row.get(px[1] + sy) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public PixelObject align() {
        int accuracy = 1;
        PixelObject r = this.turn(-accuracy);
        PixelObject l = this.turn(accuracy);
        if (r.getWidthToHeight() >= this.getWidthToHeight() && l.getWidthToHeight() >= this.getWidthToHeight()) {
            return this;
        }
        int steps = r.getWidthToHeight() < l.getWidthToHeight() ? -accuracy : accuracy;
        int angle = steps * 2;
        PixelObject ret = r.getWidthToHeight() < l.getWidthToHeight() ? r : l;
        while (true) {
            PixelObject pixelObject;
            PixelObject next = this.turn(angle);
            if (!(pixelObject.getWidthToHeight() < ret.getWidthToHeight())) break;
            ret = next;
            angle += steps;
        }
        return ret;
    }

    public PixelObject align(int angleA, int angleB) {
        if (angleB < angleA) {
            int tmp = angleB;
            angleB = angleA;
            angleA = tmp;
        }
        int accuracy = this.owner.owner.getJas().getInteger("AlignAngleSteps");
        double bestValue = Double.MAX_VALUE;
        PixelObject res = null;
        for (int angle = angleA; angle < angleB; angle += accuracy) {
            PixelObject tmp = this.turn(angle < 0 ? (double)(360 + angle) : (double)angle);
            if (!(tmp.getWidthToHeight() < bestValue)) continue;
            bestValue = tmp.getWidthToHeight();
            res = tmp;
        }
        return res;
    }

    @Override
    public int compareTo(PixelObject po) {
        if (po.getLocation()[0] < this.getLocation()[0]) {
            return 1;
        }
        if (po.getLocation()[0] > this.getLocation()[0]) {
            return -1;
        }
        return 0;
    }

    public PixelObject[] cut(int x1, int x2, int overlap) {
        PixelObject pre = new PixelObject(this.owner);
        PixelObject post = new PixelObject(this.owner);
        PixelObject cutter = new PixelObject(this.owner);
        if (x1 < this.owner.owner.getJas().getInteger("minimumLetterWidth")) {
            pre = null;
        }
        if (this.xMax - this.xMin - x2 < this.owner.owner.getJas().getInteger("minimumLetterWidth")) {
            post = null;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            if (akt[0] >= this.xMin + x1 - overlap && akt[0] <= this.xMin + x2 + overlap) {
                cutter.add(akt[0], akt[1], this.saveAvg);
            }
            if (pre != null && akt[0] < this.xMin + x1) {
                pre.add(akt[0], akt[1], this.saveAvg);
            } else if (pre == null && akt[0] < this.xMin + x1) {
                cutter.add(akt[0], akt[1], this.saveAvg);
            }
            if (post != null && akt[0] > this.xMin + x2) {
                post.add(akt[0], akt[1], this.saveAvg);
                continue;
            }
            if (post != null || akt[0] <= this.xMin + x2) continue;
            cutter.add(akt[0], akt[1], this.saveAvg);
        }
        return new PixelObject[]{pre, cutter, post};
    }

    public boolean doesColorAverageFit(int color) {
        int tavg;
        if (this.getSize() > 50000) {
            LogController.CL().severe("Objekt scheint sehr gro\u00df zu werden. objectColorContrast zu hoch?");
            return false;
        }
        int n = tavg = this.saveAvg == 0 ? this.avg : this.saveAvg;
        if (color > (int)(this.whiteContrast * (double)this.owner.getMaxPixelValue())) {
            return false;
        }
        if (this.getSize() == 0) {
            return true;
        }
        return Math.abs(tavg - color) < (int)((double)this.owner.getMaxPixelValue() * this.contrast);
    }

    public int[] elementAt(int i) {
        return this.object.get(i);
    }

    public int getArea() {
        return this.getWidth() * this.getHeight();
    }

    public int getAverage() {
        return this.avg;
    }

    public Vector<int[]> getBorderVector(Letter letter) {
        Vector<int[]> ret = new Vector<int[]>();
        if (letter == null) {
            letter = this.toLetter();
        }
        int[][] grid = letter.getGrid();
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            int x = akt[0];
            int y = akt[1];
            int[][] map = letter.getLocalMap(grid, x, y);
            boolean c = false;
            block1: for (int xx = 0; xx < 3; ++xx) {
                for (int yy = 0; yy < 3; ++yy) {
                    if (map[xx][yy] == 0) continue;
                    c = true;
                    continue block1;
                }
            }
            if (!c) continue;
            ret.add(akt);
        }
        return ret;
    }

    public int getXDistanceTo(int x) {
        int mindist = Integer.MAX_VALUE;
        for (int[] akt : this.object) {
            int xd = Math.abs(x - akt[0]);
            mindist = Math.min(mindist, xd);
        }
        return mindist;
    }

    public int getDistanceTo(int x, int y) {
        int mindist = Integer.MAX_VALUE;
        for (int[] akt : this.object) {
            int xd = Math.abs(x - akt[0]);
            int yd = Math.abs(y - akt[1]);
            int dis = (int)Math.sqrt(xd * xd + yd * yd);
            mindist = Math.min(mindist, dis);
        }
        return mindist;
    }

    public int getHeight() {
        return this.yMax - this.yMin + 1;
    }

    public int[] getLocation() {
        int[] ret = new int[]{this.xMin, this.yMin};
        return ret;
    }

    public long getMassValue(int x, int y) {
        long ret = 0L;
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            if (x == akt[0] && y == akt[1]) {
                ret += (long)(this.owner.getMaxPixelValue() * 2);
                continue;
            }
            int col = this.owner.getMaxPixelValue() - akt[2];
            double dist = Math.sqrt(Math.abs(akt[0] - x) * Math.abs(akt[0] - x) + Math.abs(akt[1] - y) * Math.abs(akt[1] - y)) / 0.5;
            ret = (long)((double)ret + (double)col / (dist + 1.0));
        }
        return ret;
    }

    public int getSize() {
        return this.object.size();
    }

    public int getWidth() {
        return this.xMax - this.xMin + 1;
    }

    public double getWidthToHeight() {
        return (double)this.getWidth() / (double)this.getHeight();
    }

    public int getXMin() {
        return this.xMin;
    }

    public int getYMin() {
        return this.yMin;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean b) {
        this.bordered = b;
    }

    public void setContrast(double contrast) {
        this.contrast = contrast;
    }

    public void setWhiteContrast(double objectContrast) {
        this.whiteContrast = objectContrast;
    }

    public Vector<PixelObject> split(int splitNum) {
        return this.split(splitNum, 0);
    }

    public Vector<PixelObject> split(int splitNum, int overlap) {
        Vector<PixelObject> ret = new Vector<PixelObject>();
        for (int t = 0; t < splitNum; ++t) {
            ret.add(new PixelObject(this.owner));
        }
        int part = this.getWidth() / splitNum;
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            for (int x = 0; x < splitNum; ++x) {
                if (akt[0] < this.xMin + x * part - overlap || akt[0] > this.xMin + (x + 1) * part + overlap) continue;
                ret.elementAt(x).add(akt[0], akt[1], this.saveAvg);
            }
        }
        return ret;
    }

    public PixelObject[] horizintalSplitAt(int yposition) {
        int i;
        PixelObject[] ret = new PixelObject[2];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = new PixelObject(this.owner);
        }
        for (i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            boolean b = true;
            for (int y = 0; y < 2; ++y) {
                if (akt[1] < this.yMin + y * yposition || akt[1] > this.yMin + (y + 1) * yposition) continue;
                ret[y].add(akt[0], akt[1], this.saveAvg);
                b = false;
            }
            if (!b) continue;
            ret[1].add(akt[0], akt[1], this.saveAvg);
        }
        return ret;
    }

    public PixelObject[] splitAt(int position) {
        int i;
        PixelObject[] ret = new PixelObject[2];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = new PixelObject(this.owner);
        }
        for (i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            boolean b = true;
            for (int x = 0; x < 2; ++x) {
                if (akt[0] < this.xMin + x * position || akt[0] > this.xMin + (x + 1) * position) continue;
                ret[x].add(akt[0], akt[1], this.saveAvg);
                b = false;
            }
            if (!b) continue;
            ret[1].add(akt[0], akt[1], this.saveAvg);
        }
        return ret;
    }

    public Letter toColoredLetter() {
        return this.toColoredLetter(this.owner.getMaxPixelValue(), this.owner);
    }

    public Letter toColoredLetter(int backgroundcolor, PixelGrid owner) {
        Letter l = new Letter(this.getWidth(), this.getHeight());
        l.setOwner(owner.owner);
        l.setGrid(this.getGrid(backgroundcolor, owner));
        l.setElementPixel(this.getSize());
        l.setLocation(new int[]{this.getXMin(), this.getYMin()});
        l.detected = this.detected;
        return l;
    }

    public int[][] getGrid() {
        return this.getGrid(this.owner.getMaxPixelValue(), this.owner);
    }

    public int[][] getGrid(int backgroundcolor, PixelGrid owner) {
        int[][] ret = new int[this.getWidth()][this.getHeight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                ret[x][y] = backgroundcolor;
            }
        }
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            ret[akt[0] - this.getXMin()][akt[1] - this.getYMin()] = owner.getPixelValue(akt[0], akt[1]);
        }
        return ret;
    }

    public Letter toLetter() {
        int[][] ret = new int[this.getWidth()][this.getHeight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                ret[x][y] = this.owner.getMaxPixelValue();
            }
        }
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            ret[akt[0] - this.xMin][akt[1] - this.yMin] = this.getAverage();
        }
        Letter l = this.owner.createLetter();
        l.setElementPixel(this.getSize());
        l.setLocation(new int[]{this.getXMin(), this.getYMin()});
        l.setGrid(ret);
        l.detected = this.detected;
        return l;
    }

    public String toString() {
        return super.toString() + " " + this.getLocation()[0] + "-" + this.getLocation()[1];
    }

    public PixelObject turn(double angle) {
        PixelObject po = new PixelObject(this.owner);
        for (int i = 0; i < this.getSize(); ++i) {
            int[] akt = this.elementAt(i);
            int[] n = Utilities.turnCoordinates(akt[0], akt[1], this.xMin + this.getWidth() / 2, this.yMin + this.getHeight() / 2, angle);
            po.add(n[0], n[1], this.avg);
        }
        return po;
    }

    public boolean isTouching(int x, int y, boolean followX, int radiusX, int radiusY) {
        if (x > this.getXMax() + radiusX) {
            return false;
        }
        if (x < this.getXMin() - radiusY) {
            return false;
        }
        if (y > this.getYMax() + radiusX) {
            return false;
        }
        if (y < this.getYMin() - radiusY) {
            return false;
        }
        for (int sx = -radiusX; sx <= radiusX; ++sx) {
            HashMap<Integer, int[]> row = this.grid.get(x + sx);
            if (row == null) continue;
            for (int sy = -radiusY; sy <= radiusY; ++sy) {
                if (Math.abs(sx) == Math.abs(sy) && !followX || row.get(y + sy) == null) continue;
                return true;
            }
        }
        return false;
    }

    public int[] getNextPixel(int x, int y) {
        Double bestDist = Double.MAX_VALUE;
        int[] bestAKT = null;
        for (int i = 0; i < this.getSize(); ++i) {
            double dist;
            int[] akt = this.elementAt(i);
            int xd = x - akt[0];
            int yd = y - akt[1];
            if (!((double)Math.max(Math.abs(xd), Math.abs(yd)) < bestDist) || !((dist = Math.sqrt(xd * xd + yd * yd)) < bestDist)) continue;
            bestDist = dist;
            bestAKT = akt;
        }
        return bestAKT;
    }
}

