/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.Colors;

public class ColorObjects {
    public static List<PixelObject> getObjects(PixelGrid grid, int tollerance, int neighbourradius) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                if (grid.getGrid()[x][y] == 0xFFFFFF) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, grid.getGrid()[x][y]);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (!o.isTouching(x, y, true, neighbourradius, neighbourradius) || !(Colors.getColorDifference((int)grid.getGrid()[x][y], (int)o.getAverage()) < (double)tollerance)) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret;
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        List<PixelObject> os = ColorObjects.getObjects(captcha, 10, 10);
        Collections.sort(os, new Comparator<PixelObject>(){

            @Override
            public int compare(PixelObject a, PixelObject b) {
                if (a.getSize() > b.getSize()) {
                    return -1;
                }
                if (a.getSize() < b.getSize()) {
                    return 1;
                }
                return 0;
            }
        });
        List<PixelObject> ret = os.subList(0, captcha.owner.getLetterNum());
        Collections.sort(ret);
        Letter[] let = new Letter[ret.size()];
        int i = 0;
        for (PixelObject po : ret) {
            let[i++] = po.toLetter();
            let[i - 1].toBlackAndWhite(1.1);
            let[i - 1].removeSmallObjects(0.99, 0.99);
            let[i - 1].clean();
        }
        return let;
    }
}

