/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.List;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.gui.BasicWindow;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.Circle;
import jd.nutils.Colors;

public class CrpTm {
    static boolean equalElements(int c, int c2) {
        int[] hsvC2;
        if (CrpTm.isWhite(c) || CrpTm.isWhite(c2)) {
            return false;
        }
        if (c == 0 || c2 == 0) {
            return c == c2;
        }
        int[] hsvC = Colors.rgb2hsv((int)c);
        return hsvC[0] == (hsvC2 = Colors.rgb2hsv((int)c2))[0] && (hsvC[1] == hsvC2[1] || hsvC[2] == hsvC2[2] || hsvC[1] / hsvC2[2] == 1 || hsvC[1] / hsvC2[2] == 1) && Colors.getRGBColorDifference2((int)c, (int)c2) < 80.0;
    }

    static boolean isWhite(int c) {
        return c < 0 || c == 0xFFFFFF;
    }

    static List<PixelObject> getObjects(Captcha grid) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                int c = grid.getGrid()[x][y];
                if (CrpTm.isWhite(c)) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, c);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (!o.isTouching(x, y, true, 3, 3) || !CrpTm.equalElements(c, o.getMostcolor())) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        CrpTm.merge(ret);
        return ret;
    }

    static void merge(List<PixelObject> list) {
        for (PixelObject po : list) {
            if (po.getSize() >= 20 && (po.getWidth() == po.getHeight() || po.getSize() >= 180)) continue;
            ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
            int most = po.getMostcolor();
            int[] hsvC = Colors.rgb2hsv((int)most);
            for (PixelObject po2 : list) {
                int[] hsvC2;
                if (po2 == po || hsvC[0] != (hsvC2 = Colors.rgb2hsv((int)po2.getMostcolor()))[0] || po2.getWidth() == po2.getHeight() && po2.getSize() >= 180 && (po2.getLocation()[0] != po.getLocation()[0] || po2.getLocation()[1] != po.getLocation()[1]) || !po2.isTouching(po, true, 14, 14)) continue;
                merge.add(po2);
            }
            if (merge.size() == 1) {
                list.remove(po);
                ((PixelObject)merge.get(0)).add(po);
                CrpTm.merge(list);
                return;
            }
            if (merge.size() <= 0) continue;
            for (PixelObject po3 : merge) {
                list.remove(po3);
                po.add(po3);
            }
            CrpTm.merge(list);
            return;
        }
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        BackGroundImageManager bgit = new BackGroundImageManager(captcha);
        bgit.clearCaptchaAll();
        BasicWindow.showImage(captcha.getImage());
        List<PixelObject> ob = CrpTm.getObjects(captcha);
        Circle circle = new Circle(captcha, ob);
        Letter best = circle.getOpenCircle();
        if (best != null) {
            BasicWindow.showImage(best.getImage(), "best");
        }
        return null;
    }
}

