/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;

public class CryPtT {
    private static int[] getColorAndPoint(Captcha captcha) {
        int y2;
        int y1;
        int color = 0xFFFFFF;
        for (y1 = 0; y1 < captcha.getHeight(); ++y1) {
            if (captcha.grid[1][y1] == 0xFFFFFF || captcha.grid[captcha.getWidth() - 2][y1] == 0xFFFFFF) continue;
            color = captcha.grid[0][y1];
            break;
        }
        for (y2 = captcha.getHeight() - 1; y2 >= 0 && (captcha.grid[1][y2] == 0xFFFFFF || captcha.grid[captcha.getWidth() - 2][y2] == 0xFFFFFF); --y2) {
        }
        return new int[]{y1, y2, color};
    }

    private static void toBlack(Captcha captcha) {
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                captcha.grid[x][y] = captcha.grid[x][y] != 0xFFFFFF ? 0 : 0xFFFFFF;
            }
        }
    }

    private static void markColoredLayer(Captcha captcha, int[] point) {
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = point[0]; y < point[1] + 1; ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) {
                    captcha.grid[x][y - 1] = 0xFF0000;
                    captcha.grid[x][y] = 0xFF0000;
                    captcha.grid[x][y + 1] = 0xFF0000;
                    captcha.grid[x + 1][y + 1] = 0xFF0000;
                    captcha.grid[x + 1][y] = 0xFF0000;
                    captcha.grid[x + 1][y - 1] = 0xFF0000;
                    captcha.grid[x - 1][y] = 0xFF0000;
                    captcha.grid[x - 1][y - 1] = 0xFF0000;
                    captcha.grid[x - 1][y + 1] = 0xFF0000;
                    continue;
                }
                if (captcha.grid[x][y] != point[2]) continue;
                captcha.grid[x][y] = 0xFFFFFF;
            }
        }
        for (int y = point[0]; y < point[1] + 1; ++y) {
            captcha.grid[0][y] = 0xFFFFFF;
            captcha.grid[captcha.getWidth() - 1][y] = 0xFFFFFF;
        }
    }

    private static PixelObject[] getObjects(Captcha captcha) {
        int y;
        int x;
        PixelObject[] ret = new PixelObject[3];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new PixelObject(captcha);
        }
        for (x = 0; x < captcha.getWidth() / 3 + captcha.getWidth() / 10; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[0].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = captcha.getWidth() / 3 - captcha.getWidth() / 20; x < captcha.getWidth() * 2 / 3 + captcha.getWidth() / 20; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[1].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = captcha.getWidth() * 2 / 3 - captcha.getWidth() / 10; x < captcha.getWidth(); ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[2].add(x, y, captcha.grid[x][y]);
            }
        }
        return ret;
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        int[] cp = CryPtT.getColorAndPoint(captcha);
        CryPtT.markColoredLayer(captcha, cp);
        CryPtT.toBlack(captcha);
        PixelObject[] os = CryPtT.getObjects(captcha);
        Letter[] lets = new Letter[os.length];
        for (int i = 0; i < lets.length; ++i) {
            lets[i] = os[i].toLetter();
            lets[i].resizetoHeight(30);
        }
        return lets;
    }
}

