/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;

public class FlDRR {
    private static void clearlines(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (captcha.grid[x][y] != 32768) continue;
                int co = captcha.grid[x + 1][y];
                int w = co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x + 1][y + 1];
                w += co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x][y + 1];
                w += co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x - 1][y + 1];
                w += co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x - 1][y - 1];
                w += co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x + 1][y - 1];
                w += co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x - 1][y];
                w += co != 32768 && co != 0xFFFFFF ? 1 : 0;
                co = captcha.grid[x][y - 1];
                if ((w += co != 32768 && co != 0xFFFFFF ? 1 : 0) >= 1) continue;
                grid[x][y] = 0xFFFFFF;
            }
        }
        captcha.grid = grid;
    }

    private static void merge(Vector<PixelObject> objects) {
        for (PixelObject pixelObject : objects) {
            if (pixelObject.getArea() >= 100) continue;
            EasyCaptcha.mergeos(pixelObject, objects);
            FlDRR.merge(objects);
            break;
        }
    }

    private static void split(Vector<PixelObject> objects, Captcha captcha) {
        if (objects.size() < 4) {
            EasyCaptcha.getRightletters(objects, captcha, new int[]{70}, new int[]{10, 10}, 0);
        }
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        FlDRR.clearlines(captcha);
        captcha.crop(1, 2, 1, 2);
        Vector<PixelObject> objects = captcha.getObjects(0.3, 0.3);
        FlDRR.merge(objects);
        FlDRR.split(objects, captcha);
        Collections.sort(objects);
        ArrayList<Letter> ret = new ArrayList<Letter>();
        for (PixelObject pixelObject : objects) {
            Letter let = pixelObject.toLetter();
            let.toBlackAndWhite();
            ret.add(let);
        }
        return ret.toArray(new Letter[0]);
    }
}

