/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.Circle;
import jd.captcha.utils.Utilities;
import jd.nutils.Colors;

public class GmdMscCm {
    Comparator<Integer> isElementColor = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            int c = o1;
            int c2 = o2;
            if (c < 0 || c == 0xFFFFFF) {
                return 0;
            }
            int[] hsvC = Colors.rgb2hsv((int)c);
            int[] hsvC2 = Colors.rgb2hsv((int)c2);
            if (hsvC[0] == 0 && hsvC2[0] == 0 && hsvC[1] == 0 && hsvC2[1] == 0) {
                return 1;
            }
            if (hsvC[0] == hsvC2[0] && hsvC[2] == hsvC2[2]) {
                return 1;
            }
            return 0;
        }
    };
    private File captchafile = null;
    private JAntiCaptcha jac = new JAntiCaptcha("EasyCaptcha");

    public static void main(String[] args) throws InterruptedException {
        File[] list = new File("/home/dwd/.jd_home/captchas/lnkcrptwsCircles").listFiles();
        for (int i = 20; i < 30; ++i) {
            File file = list[i];
            new GmdMscCm(file).getResult();
        }
    }

    public List<PixelObject> getObjects(Captcha grid) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                int c = grid.getGrid()[x][y];
                if (c < 0 || c == 0xFFFFFF) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, c);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (!o.isTouching(x, y, true, 26, 26) || this.isElementColor.compare(o.getMostcolor(), c) != 1) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret;
    }

    public GmdMscCm(File file) {
        this.captchafile = file;
    }

    public int[] getResult() throws InterruptedException {
        Image captchaImage = Utilities.loadImage(this.captchafile);
        Captcha captcha = this.jac.createCaptcha(captchaImage);
        captcha.setCaptchaFile(this.captchafile);
        captcha.crop(2, 2, 2, 2);
        List<PixelObject> ob = this.getObjects(captcha);
        Iterator<PixelObject> iterator = ob.iterator();
        while (iterator.hasNext()) {
            PixelObject pixelObject = iterator.next();
            int ratio = pixelObject.getHeight() * 100 / pixelObject.getWidth();
            if (ratio <= 115 && ratio >= 85 && pixelObject.getSize() >= 35) continue;
            iterator.remove();
        }
        Circle circle = new Circle(captcha, ob);
        circle.inBorder = 3;
        circle.outBorder = 4;
        circle.isElementColor = this.isElementColor;
        Letter openCircle = circle.getOpenCircle();
        if (openCircle == null) {
            return null;
        }
        int x = openCircle.getLocation()[0] + openCircle.getWidth() / 2;
        int y = openCircle.getLocation()[1] + openCircle.getHeight() / 2;
        return new int[]{x, y};
    }
}

