/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import jd.captcha.JAntiCaptcha;
import jd.captcha.LevenShteinLetterComperator;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;

public class NrDr {
    public static boolean checkLine(int x0, int x1, int y0, int y1, PixelGrid grid, int color) {
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        if (dx > dy) {
            int length = dx - 1 >> 2;
            int extras = dx - 1 & 3;
            int incr2 = (dy << 2) - (dx << 1);
            if (incr2 < 0) {
                int c = dy << 1;
                int incr1 = c << 1;
                int d = incr1 - dx;
                for (int i = 0; i < length; ++i) {
                    x0 += stepx;
                    x1 -= stepx;
                    if (d < 0) {
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x0][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                        d += incr1;
                        continue;
                    }
                    if (d < c) {
                        if (grid.grid[x0][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                    }
                    d += incr2;
                }
                if (extras > 0) {
                    if (d < 0) {
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                    } else if (d < c) {
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    }
                }
            } else {
                int c = dy - dx << 1;
                int incr1 = c << 1;
                int d = incr1 + dx;
                for (int i = 0; i < length; ++i) {
                    x0 += stepx;
                    x1 -= stepx;
                    if (d > 0) {
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                        d += incr1;
                        continue;
                    }
                    if (d < c) {
                        if (grid.grid[x0][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                    }
                    d += incr2;
                }
                if (extras > 0) {
                    if (d > 0) {
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    } else if (d < c) {
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (extras > 2 && d > c) {
                            if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                                return false;
                            }
                            if (grid.grid[x1 -= stepx][y1] != color) {
                                return false;
                            }
                        }
                    }
                }
            }
        } else {
            int length = dy - 1 >> 2;
            int extras = dy - 1 & 3;
            int incr2 = (dx << 2) - (dy << 1);
            if (incr2 < 0) {
                int c = dx << 1;
                int incr1 = c << 1;
                int d = incr1 - dy;
                for (int i = 0; i < length; ++i) {
                    y0 += stepy;
                    y1 -= stepy;
                    if (d < 0) {
                        if (grid.grid[x0][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                        d += incr1;
                        continue;
                    }
                    if (d < c) {
                        if (grid.grid[x0][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                    }
                    d += incr2;
                }
                if (extras > 0) {
                    if (d < 0) {
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                    } else if (d < c) {
                        if (grid.grid[stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    }
                }
            } else {
                int c = dx - dy << 1;
                int incr1 = c << 1;
                int d = incr1 + dy;
                for (int i = 0; i < length; ++i) {
                    y0 += stepy;
                    y1 -= stepy;
                    if (d > 0) {
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepy][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                        d += incr1;
                        continue;
                    }
                    if (d < c) {
                        if (grid.grid[x0][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0 += stepx][y0] != color) {
                            return false;
                        }
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (grid.grid[x1 -= stepx][y1] != color) {
                            return false;
                        }
                        if (grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                    }
                    d += incr2;
                }
                if (extras > 0) {
                    if (d > 0) {
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                            return false;
                        }
                    } else if (d < c) {
                        if (grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && grid.grid[x1][y1 -= stepy] != color) {
                            return false;
                        }
                    } else {
                        if (grid.grid[x0 += stepx][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 1 && grid.grid[x0][y0 += stepy] != color) {
                            return false;
                        }
                        if (extras > 2 && d > c) {
                            if (grid.grid[x1 -= stepx][y1 -= stepy] != color) {
                                return false;
                            }
                            if (grid.grid[x1][y1 -= stepy] != color) {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    static void follow(int x0, int y0, PixelGrid px, PixelGrid captcha, double dmin, double dmax) {
        px.grid[x0][y0] = 0;
        int x = Math.max(0, x0 - 1);
        int y = Math.max(0, y0 - 1);
        for (x0 = x; x0 < Math.min(x + 2, captcha.getWidth()); ++x0) {
            for (y0 = y; y0 < Math.min(y + 2, captcha.getHeight()); ++y0) {
                if (px.grid[x0][y0] != 0xFFFFFF) continue;
                px.grid[x0][y0] = 0;
            }
        }
    }

    static void fill(PixelGrid captcha, double dmin, double dmax) {
        int y;
        int x;
        PixelGrid px = new PixelGrid(captcha.getWidth(), captcha.getHeight());
        px.grid = new int[captcha.getWidth()][captcha.getHeight()];
        for (x = 0; x < captcha.getWidth(); ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                px.grid[x][y] = 0xFFFFFF;
            }
        }
        for (x = 0; x < captcha.getWidth(); ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (px.grid[x][y] != 0xFFFFFF || captcha.grid[x][y] == 0xFFFFFF) continue;
                int x1 = x;
                while ((double)x1 < Math.min((double)x + dmax, (double)captcha.getWidth())) {
                    int y1 = y;
                    while ((double)y1 < Math.min((double)y + dmax, (double)captcha.getHeight())) {
                        double yd;
                        double xd;
                        double diff;
                        if (px.grid[x1][y1] == 0xFFFFFF && captcha.grid[x1][y1] != 0xFFFFFF && (diff = Math.sqrt((xd = (double)(x1 - x)) * xd + (yd = (double)(y1 - y)) * yd)) > dmin && diff < dmax && NrDr.checkLine(x, x1, y, y1, captcha, 0xFFFFFF)) {
                            int y1add;
                            int x1add;
                            int yadd;
                            int xadd;
                            int di = 3;
                            if (xd == 0.0) {
                                xadd = 0;
                                yadd = di;
                                x1add = 0;
                                y1add = di - 1;
                            } else if (yd == 0.0) {
                                xadd = di;
                                x1add = di - 1;
                                y1add = 0;
                                yadd = 0;
                            } else {
                                double m = yd / xd;
                                xadd = (int)Math.floor((1.0 - m) * (double)di);
                                yadd = (int)Math.floor(m * (double)di);
                                x1add = (int)Math.ceil((1.0 - m) * (double)(di - 1));
                                y1add = (int)Math.floor(m * (double)(di - 1));
                            }
                            int f = y - yadd;
                            int fx = x - xadd;
                            if (f > 0 && fx > 0 && f < captcha.getHeight() && fx < captcha.getWidth() && captcha.grid[fx][f] != 0xFFFFFF) {
                                try {
                                    if (NrDr.checkLine(x, x - x1add, y, y - y1add, captcha, 0)) {
                                        f = y1 + yadd;
                                        fx = x1 + xadd;
                                        if (f > 0 && fx > 0 && f < captcha.getHeight() && fx < captcha.getWidth() && captcha.grid[fx][f] != 0xFFFFFF && NrDr.checkLine(x1, x1 + x1add, y1, y1 + y1add, captcha, 0)) {
                                            NrDr.follow(x, y, px, captcha, dmin, dmax);
                                            NrDr.follow(x1, y1, px, captcha, dmin, dmax);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    px.grid[x][y] = captcha.grid[x][y];
                                }
                            }
                        }
                        ++y1;
                    }
                    ++x1;
                }
            }
        }
        for (x = 0; x < captcha.getWidth(); ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] != 0xFFFFFF) continue;
                px.grid[x][y] = 0xFFFFFF;
            }
        }
        captcha.grid = px.grid;
    }

    static void toBlack(PixelGrid captcha) {
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                captcha.grid[x][y] = captcha.grid[x][y] != 0xFFFFFF && captcha.grid[x][y] != 0xFF0000 ? 0 : 0xFFFFFF;
            }
        }
    }

    private static PixelObject[] getObjects(Captcha captcha) {
        int y;
        int x;
        int xEnd;
        int startX;
        block0: for (startX = 1; startX < captcha.getWidth(); ++startX) {
            for (int y2 = 1; y2 < captcha.getHeight() - 1; ++y2) {
                if (captcha.grid[startX][y2] != 0xFFFFFF) break block0;
            }
        }
        block2: for (xEnd = captcha.getWidth() - 2; xEnd > 0; --xEnd) {
            for (int y3 = 1; y3 < captcha.getHeight() - 1; ++y3) {
                if (captcha.grid[xEnd][y3] != 0xFFFFFF) break block2;
            }
        }
        int wi = (xEnd - startX) / 6;
        PixelObject[] ret = new PixelObject[6];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new PixelObject(captcha);
        }
        int add = 3;
        for (x = startX; x < startX + wi + add; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[0].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = startX + wi; x < startX + wi * 2 + add; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[1].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = startX + wi * 2; x < startX + wi * 3 + add; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[2].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = startX + wi * 3; x < startX + wi * 4 + add; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[3].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = startX + wi * 4; x < startX + wi * 5 + add; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[4].add(x, y, captcha.grid[x][y]);
            }
        }
        for (x = startX + wi * 5; x < startX + wi * 6 + add; ++x) {
            for (y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                ret[5].add(x, y, captcha.grid[x][y]);
            }
        }
        return ret;
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        BackGroundImageManager bgit = new BackGroundImageManager(captcha);
        bgit.clearCaptchaAll();
        NrDr.toBlack(captcha);
        NrDr.fill(captcha, 1.0, 9.0);
        PixelObject[] os = NrDr.getObjects(captcha);
        captcha.reset();
        Letter[] lets = new Letter[os.length];
        for (int i = 0; i < lets.length; ++i) {
            lets[i] = os[i].toLetter();
            int[] l = lets[i].getLocation();
            for (int x = 0; x < lets[i].getWidth(); ++x) {
                for (int y = 0; y < lets[i].getHeight(); ++y) {
                    lets[i].grid[x][y] = captcha.getPixelValue(x + l[0] - 1, y + l[1] - 1);
                }
            }
            NrDr.toBlack(lets[i]);
            lets[i].resizetoHeight(30);
        }
        return lets;
    }

    public static Letter[] letterFilter(Letter[] org, JAntiCaptcha jac) {
        LevenShteinLetterComperator lvs = new LevenShteinLetterComperator(jac);
        lvs.run(org);
        return org;
    }
}

