/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;

public class ThreeDlTv {
    private static boolean checkAt(Captcha captcha, int x, int y) {
        int yMin;
        int yMax = Math.min(captcha.getHeight(), y + 7);
        for (int i = yMin = Math.max(0, y - 7); i < yMax; ++i) {
            if (captcha.getPixelValue(x, i) != 0xFFFFFF) continue;
            return true;
        }
        return false;
    }

    private static void clear(Captcha captcha) {
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.getPixelValue(x, y) == 0xFFFFFF || ThreeDlTv.checkAt(captcha, x, y)) continue;
                ThreeDlTv.clearAt(captcha, x, y);
            }
        }
    }

    private static void clearAt(Captcha captcha, int x, int y) {
        if (captcha.getHeight() >= y && captcha.getWidth() >= x && x > 0 && y > 0 && captcha.getPixelValue(x, y) != 0xFFFFFF) {
            captcha.grid[x][y] = 0xFFFFFF;
            ThreeDlTv.clearAt(captcha, x + 1, y + 1);
            ThreeDlTv.clearAt(captcha, x, y + 1);
            ThreeDlTv.clearAt(captcha, x + 1, y);
            ThreeDlTv.clearAt(captcha, x - 1, y - 1);
            ThreeDlTv.clearAt(captcha, x - 1, y);
            ThreeDlTv.clearAt(captcha, x, y - 1);
            ThreeDlTv.clearAt(captcha, x + 1, y - 1);
            ThreeDlTv.clearAt(captcha, x - 1, y + 1);
        }
    }

    private static Letter createLetter(Captcha captcha, int[] header1) {
        captcha.crop(Math.max(0, header1[0] - 15), header1[1], Math.max(0, captcha.getWidth() - header1[0] - 15), Math.max(0, captcha.getHeight() - header1[1] - 25));
        Letter l = captcha.createLetter();
        captcha.toBlackAndWhite();
        l.setLocation(header1);
        l.setGrid(captcha.getGrid());
        captcha.reset();
        return l;
    }

    private static int[] getHeader(Captcha captcha, int xMin, int xMax) {
        for (int y = 0; y < captcha.getHeight() / 8; ++y) {
            for (int x = xMin; x < xMax; ++x) {
                if (captcha.getPixelValue(x, y) == 0xFFFFFF) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public static Letter[] getLetters(Captcha captcha) throws Exception {
        LetterComperator rc1;
        LetterComperator r;
        captcha.owner.loadMTHFile(captcha.owner.getResourceFile("lettersheads.mth"));
        captcha.crop(206, 150, 236, 0);
        Vector<PixelObject> obj = captcha.getObjects(0.7, 0.7);
        Letter let = obj.get(0).toLetter();
        let.invert();
        let.normalize();
        let = let.toPixelObject(0.7).toLetter();
        let.detected = r = captcha.owner.getLetter(let);
        let.setDecodedValue(r.getDecodedValue());
        captcha.reset();
        int xMax = captcha.getWidth() / 3;
        Letter head1 = ThreeDlTv.createLetter(captcha, ThreeDlTv.getHeader(captcha, 0, xMax));
        Letter head2 = ThreeDlTv.createLetter(captcha, ThreeDlTv.getHeader(captcha, xMax, xMax * 2));
        Letter head3 = ThreeDlTv.createLetter(captcha, ThreeDlTv.getHeader(captcha, xMax * 2, xMax * 3));
        int pos = 0;
        head1.detected = rc1 = captcha.owner.getLetter(head1);
        head1.setDecodedValue(rc1.getDecodedValue());
        if (head1.getDecodedValue().equals(let.getDecodedValue())) {
            pos = 0;
        } else {
            LetterComperator rc2;
            head2.detected = rc2 = captcha.owner.getLetter(head2);
            head2.setDecodedValue(rc2.getDecodedValue());
            if (head2.getDecodedValue().equals(let.getDecodedValue())) {
                pos = 1;
            } else {
                LetterComperator rc3;
                head3.detected = rc3 = captcha.owner.getLetter(head3);
                head3.setDecodedValue(rc3.getDecodedValue());
                pos = head3.getDecodedValue().equals(let.getDecodedValue()) ? 2 : (head1.detected.getValityPercent() > head2.detected.getValityPercent() ? (head1.detected.getValityPercent() > head3.detected.getValityPercent() ? 0 : 2) : (head2.detected.getValityPercent() > head3.detected.getValityPercent() ? 1 : 2));
            }
        }
        captcha.crop(0, 0, 0, 20);
        ThreeDlTv.clear(captcha);
        captcha.toBlackAndWhite(0.8);
        obj = ThreeDlTv.getObjects(captcha, 3);
        Collections.sort(obj);
        if (obj.size() > 3) {
            Iterator<PixelObject> iterator = obj.iterator();
            while (iterator.hasNext()) {
                PixelObject pixelObject = iterator.next();
                if (pixelObject.getArea() >= 80) continue;
                iterator.remove();
            }
        }
        captcha.owner.loadMTHFile();
        captcha.owner.getJas().set("minimumObjectArea", 1);
        captcha.owner.getJas().set("minimumLetterWidth", 1);
        captcha.grid = obj.get((int)pos).toLetter().grid;
        obj = captcha.getObjects(0.7, 0.7);
        int merge = 0;
        for (PixelObject pixelObject : obj) {
            if (pixelObject.getArea() >= 3) continue;
            ++merge;
        }
        captcha.owner.setLetterNum(obj.size() - merge);
        EasyCaptcha.mergeObjectsBasic(obj, captcha, 2);
        Collections.sort(obj);
        ArrayList<Letter> ret = new ArrayList<Letter>();
        ListIterator<PixelObject> iterator = obj.listIterator();
        while (iterator.hasNext()) {
            PixelObject pixelObject = iterator.next();
            ret.addAll(ThreeDlTv.getSplitted(pixelObject, captcha, 0));
        }
        ThreeDlTv.replaceLetters(ret);
        return ret.toArray(new Letter[0]);
    }

    static Vector<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        Vector<PixelObject> ret = new Vector<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                if (grid.getGrid()[x][y] < 0 || grid.getGrid()[x][y] != 0) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, grid.getGrid()[x][y]);
                Vector<PixelObject> merge = new Vector<PixelObject>();
                for (PixelObject o : ret) {
                    if (!o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret;
    }

    private static List<Letter> getSplitted(PixelObject pixelObject, Captcha captcha, int index) throws InterruptedException {
        LetterComperator r2;
        Letter splittedLetter;
        int CharAnzahl;
        LetterComperator r1;
        ArrayList<Letter> ret = new ArrayList<Letter>();
        if (pixelObject.getArea() < 4) {
            return ret;
        }
        int lWith = 5;
        Letter let1 = pixelObject.toLetter();
        let1.toBlackAndWhite();
        let1.detected = r1 = captcha.owner.getLetter(let1);
        if (r1.getValityPercent() < 3.0 || pixelObject.getArea() < 15) {
            ret.add(let1);
            return ret;
        }
        ArrayList<Integer> splitMap = new ArrayList<Integer>();
        Hashtable testMap = new Hashtable();
        Vector<Integer> one = new Vector<Integer>();
        Vector<Integer> two = new Vector<Integer>();
        Vector<Integer> three = new Vector<Integer>();
        int eins = 0;
        int zwei = 0;
        int drei = 0;
        for (int x = pixelObject.getWidth() - 1; x > 0; --x) {
            int black = 0;
            for (int y = 0; y < pixelObject.getHeight(); ++y) {
                if (pixelObject.getGrid()[x][y] < 0 || pixelObject.getGrid()[x][y] != 0) continue;
                ++black;
            }
            if (black == index) {
                int p;
                if (splitMap != null && splitMap.size() > 0 && ((p = ((Integer)splitMap.get(splitMap.size() - 1)).intValue()) == x + 1 || p == x + 2 || x == 0)) continue;
                splitMap.add(x);
            }
            if (black == 1) {
                ++eins;
                one.add(x);
            } else if (black == 2) {
                ++zwei;
                two.add(x);
            } else if (black == 3) {
                ++drei;
                three.add(x);
            }
            Collections.sort(one);
            Collections.sort(two);
            Collections.sort(three);
            testMap.put("eins", one);
            testMap.put("zwei", two);
            testMap.put("drei", three);
        }
        Collections.reverse(splitMap);
        if (splitMap != null && splitMap.size() > 0 && (Integer)splitMap.get(0) >= 10) {
            splitMap.add(((Integer)splitMap.get(0) - (Integer)splitMap.get(0) % 2) / 2);
            Collections.sort(splitMap);
        }
        if ((CharAnzahl = (pixelObject.getWidth() - pixelObject.getWidth() % 5) / 5 - 1) > splitMap.size()) {
            int sPos = 0;
            int xPos = 0;
            int maxPos = 0;
            Iterator i = splitMap.listIterator();
            while (i.hasNext()) {
                if (i.hasPrevious()) {
                    xPos = (Integer)i.previous();
                    i.next();
                    sPos = (Integer)i.next() - xPos;
                } else {
                    i.next();
                }
                maxPos = sPos > maxPos ? sPos : maxPos;
            }
            if (maxPos > 0) {
                for (int i2 = 1; i2 <= (maxPos - maxPos % 5) / 5; ++i2) {
                    long min = 56847819L;
                    long b = Math.min(56847819L, pixelObject.getMassValue(6, 0));
                    if (b == 56847819L) continue;
                    splitMap.add(xPos + i2 * 5);
                }
                Collections.sort(splitMap);
            }
            if (CharAnzahl > splitMap.size()) {
                i = ((Vector)testMap.get("eins")).iterator();
                while (i.hasNext()) {
                    int c = (Integer)i.next();
                    Iterator iterator = new ArrayList(splitMap).iterator();
                    while (iterator.hasNext()) {
                        int let = (Integer)iterator.next();
                        if (c - 5 < let || splitMap.contains(c - 3) || splitMap.contains(c - 2) || splitMap.contains(c - 1) || splitMap.contains(c) || splitMap.contains(c + 1) || splitMap.contains(c + 2) || splitMap.contains(c + 3)) continue;
                        splitMap.add(c);
                        Collections.sort(splitMap);
                    }
                }
            }
        }
        int xm = 0;
        PixelObject[] bArray = null;
        if (splitMap == null || splitMap.size() == 0) {
            if (eins == 0 && zwei == 0 && drei == 0) {
                return ret;
            }
            int newIndex = eins == 0 && zwei >= drei ? 3 : 2;
            int n = newIndex = eins > 0 ? 1 : index;
            if (newIndex == index) {
                return ret;
            }
            return ThreeDlTv.getSplitted(pixelObject, captcha, newIndex);
        }
        Iterator iterator = splitMap.iterator();
        while (iterator.hasNext()) {
            LetterComperator r22;
            int let = (Integer)iterator.next();
            bArray = pixelObject.splitAt(let - xm);
            pixelObject = bArray[1];
            splittedLetter = bArray[0].toLetter();
            splittedLetter.toBlackAndWhite();
            splittedLetter.detected = r22 = captcha.owner.getLetter(splittedLetter);
            ret.add(splittedLetter);
            xm = let + 1;
        }
        splittedLetter = bArray[1].toLetter();
        splittedLetter.toBlackAndWhite();
        splittedLetter.detected = r2 = captcha.owner.getLetter(splittedLetter);
        ret.add(splittedLetter);
        return ret;
    }

    public static Letter[] letterFilter(Letter[] org, JAntiCaptcha jac) {
        return org;
    }

    private static void replaceLetters(List<Letter> lets) {
        int i = 0;
        String add = null;
        for (Letter letter : lets) {
            if (letter.detected.getDecodedValue().equals("1")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "i";
                break;
            }
            if (letter.detected.getDecodedValue().equals("2")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "l";
                break;
            }
            if (letter.detected.getDecodedValue().equals("3")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "t";
                break;
            }
            if (letter.detected.getDecodedValue().equals("4")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "n";
                break;
            }
            ++i;
        }
        if (add != null) {
            Letter re = new Letter();
            re.setDecodedValue(add);
            LetterComperator let1 = new LetterComperator(re, re);
            let1.setValityPercent(0.0);
            re.detected = let1;
            lets.add(i + 1, re);
            ThreeDlTv.replaceLetters(lets);
        }
    }
}

