/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.unixsplit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class UnixSplitInputStream
extends InputStream {
    private static final String SUFFIX_PATTERN = "^(.+)\\.([a-z]{2,})$";
    protected final File baseFile;
    protected final int suffixLength;
    protected int segmentIndex = 0;
    protected InputStream segment = null;
    protected boolean eof = false;

    public UnixSplitInputStream(File file) throws IOException {
        String fileName = file.getName();
        if (!fileName.matches(SUFFIX_PATTERN)) {
            throw new IOException("could not auto detect suffix:" + fileName);
        }
        String suffix = fileName.replaceFirst(SUFFIX_PATTERN, "$2");
        this.segmentIndex = UnixSplitInputStream.parseSegment(suffix);
        this.suffixLength = suffix.length();
        String filePath = file.getAbsolutePath();
        this.baseFile = new File(filePath.substring(0, filePath.length() - this.suffixLength));
        this.openNextSegment();
    }

    public UnixSplitInputStream(File baseFile, int segmentIndex, int suffixLength) throws IOException {
        this.baseFile = baseFile;
        this.suffixLength = suffixLength;
        this.segmentIndex = segmentIndex;
        this.openNextSegment();
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        return this.segment.available();
    }

    @Override
    public int read() throws IOException {
        int ret;
        block2: {
            do {
                if (this.eof) {
                    return -1;
                }
                ret = this.segment.read();
                if (ret != -1) break block2;
            } while (this.openNextSegment());
            return -1;
        }
        return ret;
    }

    protected boolean openNextSegment() throws IOException {
        if (!this.eof) {
            String suffix;
            if (this.segment != null) {
                this.segment.close();
            }
            try {
                suffix = UnixSplitInputStream.buildSegment(this.segmentIndex, this.suffixLength);
            }
            catch (IllegalArgumentException e) {
                this.eof = true;
                if (this.throwNextSegmentException(e, this.segmentIndex)) {
                    throw e;
                }
                return false;
            }
            try {
                this.segment = this.openInputStream(new File(this.baseFile + suffix));
                ++this.segmentIndex;
                return true;
            }
            catch (FileNotFoundException e) {
                this.eof = true;
                if (this.throwNextSegmentException(e, this.segmentIndex)) {
                    throw e;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean throwNextSegmentException(Exception e, int segmentIndex) {
        return this.segment == null;
    }

    protected InputStream openInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.segment != null) {
                this.segment.close();
            }
        }
        finally {
            this.eof = true;
            this.segment = null;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        block2: {
            do {
                if (this.eof) {
                    return -1;
                }
                ret = this.segment.read(b, off, len);
                if (ret != -1) break block2;
            } while (this.openNextSegment());
            return -1;
        }
        return ret;
    }

    public static int parseSegment(String segment) {
        int length = segment.length();
        int ret = 0;
        for (int i = 0; i < length; ++i) {
            int x = segment.charAt(i) - 97;
            ret = (int)((double)ret + (double)x * Math.pow(26.0, length - 1 - i));
        }
        return ret;
    }

    public static String buildSegment(int value, int suffixLength) throws IllegalArgumentException {
        int max = (int)Math.pow(26.0, suffixLength);
        if (value > max) {
            throw new IllegalArgumentException("value:" + value + " is too large for suffixLength:" + suffixLength + "(max:" + max + ")");
        }
        char[] ret = new char[suffixLength];
        for (int index = 0; index < suffixLength; ++index) {
            int pos = (int)Math.pow(26.0, suffixLength - 1 - index);
            int remaining = value / pos;
            value %= pos;
            ret[index] = (char)(97 + remaining);
        }
        return new String(ret);
    }
}

