/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.unixsplit.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.appwork.io.unixsplit.StreamProvider;
import org.appwork.io.unixsplit.UnixSplitOutputStream;
import org.appwork.utils.CompareUtils;

public class UnixSplitTest {
    public static void main(String[] args) throws IOException {
        UnixSplitOutputStream stream = new UnixSplitOutputStream(new StreamProvider(){

            @Override
            public StreamProvider.PartInfo getNextStream(int i) throws IOException {
                final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                return new StreamProvider.PartInfo(baos, 10L){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        if (!CompareUtils.equals(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, baos.toByteArray())) {
                            throw new IOException("Test Failed");
                        }
                    }
                };
            }
        });
        stream.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        stream.write(new byte[]{1, 2});
        stream.write(new byte[]{3, 4, 5, 6, 7, 8, 9, 10});
        stream.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        stream.close();
        if (stream.getPartCount() != 8) {
            throw new IOException("Expected 8 parts");
        }
        System.out.println("SUCCESS Parts:" + stream.getPartCount());
    }
}

