/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.jna.tests;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class EthernetTest {
    public static void main(String[] args) throws SocketException {
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface netint : Collections.list(nets)) {
            EthernetTest.displayInterfaceInformation(netint);
        }
    }

    static void displayInterfaceInformation(NetworkInterface netint) {
        try {
            NetworkInterface nif = netint;
            if (nif == null) {
                System.err.println("Error getting the Network Interface");
                return;
            }
            Enumeration<InetAddress> nifAddresses = nif.getInetAddresses();
            InetSocketAddress inetAddr = new InetSocketAddress(nifAddresses.nextElement(), 0);
            System.out.println("Interface: " + nif.getName() + " - " + nif.getDisplayName());
            DatagramSocket socket = new DatagramSocket(inetAddr);
            System.out.println(socket.getLocalAddress());
            System.out.println("");
        }
        catch (SocketException ex) {
            System.out.println(ex.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

