/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.jna.windows.wmi;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OaIdlUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.jna.windows.wmi.ExtIWbemClassObject;
import org.appwork.jna.windows.wmi.JNAWMIUtils;
import org.appwork.jna.windows.wmi.WMIException;
import org.appwork.jna.windows.wmi.WMIQueryFailedException;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.SimpleLoggerFactory;
import org.appwork.loggingv3.simple.sink.LogToStdOutSink;
import org.appwork.serializer.Deser;
import org.appwork.serializer.SC;
import org.appwork.utils.DebugMode;
import org.appwork.utils.NameInterface;
import org.appwork.utils.NonInterruptibleThread;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.os.CrossSystem;

@Deprecated
public class WMIConnector
implements Closeable {
    public static final String LNG_EN = "MS_409";
    private static String OS_LANGUAGE_CODE = null;
    private Wbemcli.IWbemServices svc;
    private static final int WMITIMEOUT = 60000;
    private int comThreading = 0;
    private boolean securityInitialized;

    public static void main(String[] args) {
        String namespace;
        SimpleLoggerFactory f = new SimpleLoggerFactory();
        f.setSinkToConsole(new LogToStdOutSink());
        LogV3.setFactory(f);
        final HashSet<String> expected = new HashSet<String>();
        expected.add("[{\"__CLASS\":\"AntiVirusProduct\",\"__DERIVATION\":[],\"__DYNASTY\":\"AntiVirusProduct\",\"__GENUS\":2,\"__NAMESPACE\":\"ROOT\\\\SecurityCenter2\",\"__PATH\":\"\\\\\\\\DESKTOP-7KP0VLD\\\\ROOT\\\\SecurityCenter2:AntiVirusProduct.instanceGuid=\\\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\\\"\",\"__PROPERTY_COUNT\":6,\"__RELPATH\":\"AntiVirusProduct.instanceGuid=\\\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\\\"\",\"__SERVER\":\"DESKTOP-7KP0VLD\",\"__SUPERCLASS\":null,\"displayName\":\"Windows Defender\",\"instanceGuid\":\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\",\"pathToSignedProductExe\":\"windowsdefender://\",\"pathToSignedReportingExe\":\"%ProgramFiles%\\\\Windows Defender\\\\MsMpeng.exe\",\"productState\":397568,\"timestamp\":\"Thu, 14 Nov 2024 07:28:55 GMT\"}]");
        final AtomicLong lastGC = new AtomicLong();
        switch (CrossSystem.getOS()) {
            case WINDOWS_XP: {
                namespace = "ROOT\\SecurityCenter";
                break;
            }
            default: {
                namespace = "ROOT\\SecurityCenter2";
            }
        }
        for (int i = 0; i < 10; ++i) {
            new Thread(){
                private int counter = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        WMIConnector con = new WMIConnector(namespace);
                        try {
                            this.setName(new Date().toString() + " - " + this.counter);
                            String query = "SELECT * from AntiVirusProduct";
                            ArrayList<HashMap<String, Object>> list = con.executeQuery(null, "SELECT * from AntiVirusProduct");
                            AtomicLong atomicLong = lastGC;
                            synchronized (atomicLong) {
                                if (Time.now() - lastGC.get() > 1000L) {
                                    lastGC.set(Time.now());
                                    LogV3.info("GC " + this.counter);
                                    System.gc();
                                    Thread.sleep(200L);
                                }
                            }
                            boolean ok = true;
                            String co = Deser.get().toString(list, new Object[]{SC.HASH_CONTENT});
                            if (!expected.contains(co)) {
                                System.out.println("UNEXPECTED:");
                                System.out.println(Deser.get().toString(co, new Object[0]));
                            }
                            ++this.counter;
                            continue;
                        }
                        catch (Throwable e) {
                            LogV3.log(e);
                            continue;
                        }
                        finally {
                            try {
                                con.close();
                            }
                            catch (IOException e) {
                                LogV3.log(e);
                            }
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    public WMIConnector() {
        this(null, LNG_EN);
    }

    public WMIConnector(String namespace) {
        this(namespace, LNG_EN);
    }

    public WMIConnector(String namespace, String lng) {
        if (namespace == null) {
            namespace = "ROOT\\CIMV2";
        }
        this.initCOM();
        if (lng == null) {
            if (OS_LANGUAGE_CODE == null) {
                NonInterruptibleThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int osCode = ((Number)JNAWMIUtils.query(null, "SELECT OSLanguage from Win32_OperatingSystem", "OSLanguage").get(0).get("OSLanguage")).intValue();
                            OS_LANGUAGE_CODE = "ms_" + StringUtils.fillPre(Integer.toHexString(osCode), "0", 3);
                        }
                        catch (WMIException e) {
                            LogV3.log(e);
                        }
                        catch (InterruptedException e) {
                            LogV3.log(e);
                        }
                    }
                });
            }
            lng = OS_LANGUAGE_CODE;
        }
        this.svc = WMIConnector.connectServer(namespace, lng);
    }

    public static Wbemcli.IWbemServices connectServer(String namespace, String lng) {
        Wbemcli.IWbemLocator loc = Wbemcli.IWbemLocator.create();
        if (loc == null) {
            throw new COMException("Failed to create WbemLocator object.");
        }
        Wbemcli.IWbemServices services = loc.ConnectServer(namespace, null, null, lng, 0, null, null);
        loc.Release();
        WinNT.HRESULT hres = Ole32.INSTANCE.CoSetProxyBlanket((Unknown)services, 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            services.Release();
            throw new COMException("Could not set proxy blanket.", hres);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ArrayList<HashMap<String, Object>> readValues(NameInterface[] fields, Wbemcli.IEnumWbemClassObject enumerator) throws TimeoutException {
        ret = new ArrayList<HashMap<String, Object>>();
        all = null;
        if (fields != null) {
            all = new HashMap<String, NameInterface>();
            for (NameInterface a : fields) {
                all.put(a.name().toLowerCase(Locale.ENGLISH), a);
            }
        }
        while (enumerator.getPointer() != Pointer.NULL && (hres = enumerator.Next(60000, (pclsObj = new Pointer[1]).length, pclsObj, new IntByReference(0))).intValue() != 1 && hres.intValue() != 262149) {
            if (hres.intValue() == 262148) {
                DebugMode.debugger();
                throw new TimeoutException("No results after 60000 ms.");
            }
            if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
                throw new COMException("Failed to enumerate results.", hres);
            }
            map = new HashMap<String, Object>();
            ret.add(map);
            clsObj = new ExtIWbemClassObject(pclsObj[0]);
            try {
                vtType = -1;
                block26: for (String property : clsObj.GetNames(null, 0, null)) {
                    clear = true;
                    pVal = new Variant.VARIANT.ByReference();
                    vtType = -1;
                    pType = new IntByReference();
                    try {
                        if (all != null) {
                            NameInterface = (NameInterface)all.get(property.toLowerCase(Locale.ENGLISH));
                            if (NameInterface == null) continue;
                            property = NameInterface.name();
                        }
                        if (!W32Errors.SUCCEEDED((int)(result = clsObj.Get(property, 0, pVal, pType, null)).intValue())) {
                            throw new Win32Exception(result);
                        }
                        vtType = pVal.getValue() == null ? Integer.valueOf(1) : pVal.getVarType();
                        switch (vtType) {
                            case 16: 
                            case 17: {
                                map.put(property, pVal.byteValue());
                                ** break;
lbl39:
                                // 1 sources

                                continue block26;
                            }
                            case 2: 
                            case 18: {
                                map.put(property, pVal.shortValue());
                                ** break;
lbl44:
                                // 1 sources

                                continue block26;
                            }
                            case 3: 
                            case 19: {
                                map.put(property, pVal.intValue());
                                ** break;
lbl49:
                                // 1 sources

                                continue block26;
                            }
                            case 22: 
                            case 23: {
                                map.put(property, pVal.intValue());
                                ** break;
lbl54:
                                // 1 sources

                                continue block26;
                            }
                            case 20: 
                            case 21: {
                                map.put(property, pVal.longValue());
                                ** break;
lbl59:
                                // 1 sources

                                continue block26;
                            }
                            case 8: {
                                map.put(property, pVal.stringValue());
                                ** break;
lbl64:
                                // 1 sources

                                continue block26;
                            }
                            case 7: {
                                map.put(property, pVal.dateValue());
                                ** break;
lbl69:
                                // 1 sources

                                continue block26;
                            }
                            case 11: {
                                map.put(property, pVal.booleanValue());
                                ** break;
lbl74:
                                // 1 sources

                                continue block26;
                            }
                            case 4: {
                                map.put(property, Float.valueOf(pVal.floatValue()));
                                ** break;
lbl79:
                                // 1 sources

                                continue block26;
                            }
                            case 5: {
                                map.put(property, pVal.doubleValue());
                                ** break;
lbl84:
                                // 1 sources

                                continue block26;
                            }
                            case 0: 
                            case 1: {
                                map.put(property, null);
                                ** break;
lbl89:
                                // 1 sources

                                continue block26;
                            }
                            default: {
                                value = pVal.getValue();
                                if (value instanceof OaIdl.SAFEARRAY) {
                                    array = OaIdlUtil.toPrimitiveArray((OaIdl.SAFEARRAY)((OaIdl.SAFEARRAY)value), (boolean)false);
                                    ((OaIdl.SAFEARRAY)value).destroy();
                                    clear = false;
                                    map.put(property, array);
                                    ** break;
lbl99:
                                    // 1 sources

                                    continue block26;
                                }
                                map.put(property, null);
                                continue block26;
                            }
                        }
                    }
                    catch (Throwable e) {
                        for (Field f : Variant.class.getFields()) {
                            try {
                                if (!f.getName().startsWith("VT_") || vtType != f.getInt(null)) continue;
                                LogV3.info("Error Type: " + f.getName());
                                break;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        LogV3.info("Error Prop: " + property);
                        LogV3.log(e);
                    }
                    finally {
                        if (clear) {
                            if (pVal.getValue() instanceof OaIdl.SAFEARRAY) {
                                DebugMode.debugger();
                            }
                            OleAuto.INSTANCE.VariantClear((Variant.VARIANT)pVal);
                        }
                    }
                }
            }
            finally {
                clsObj.Release();
            }
        }
        return ret;
    }

    protected boolean initCOM(int coInitThreading) {
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, coInitThreading);
        switch (hres.intValue()) {
            case 0: 
            case 1: {
                return true;
            }
            case -2147417850: {
                return false;
            }
        }
        throw new COMException("Failed to initialize COM library.", hres);
    }

    public boolean initCOM() {
        boolean comInit = false;
        comInit = this.initCOM(this.getComThreading());
        if (!comInit) {
            comInit = this.initCOM(this.switchComThreading());
        }
        if (comInit && !this.securityInitialized) {
            WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
            if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
                Ole32.INSTANCE.CoUninitialize();
                throw new COMException("Failed to initialize security.", hres);
            }
            this.securityInitialized = true;
        }
        return comInit;
    }

    public int switchComThreading() {
        this.comThreading = this.comThreading == 2 ? 0 : 2;
        return this.comThreading;
    }

    public int getComThreading() {
        return this.comThreading;
    }

    public void dispose() {
        try {
            this.svc.Release();
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        Ole32.INSTANCE.CoUninitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HashMap<String, Object>> executeQuery(NameInterface[] fields, String query) throws TimeoutException, WMIQueryFailedException {
        ArrayList<HashMap<String, Object>> arrayList;
        Wbemcli.IEnumWbemClassObject cursor = this.svc.ExecQuery("WQL", query, 131120, null);
        try {
            arrayList = this.readValues(fields, cursor);
        }
        catch (Throwable throwable) {
            try {
                cursor.Release();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw new WMIQueryFailedException(e);
            }
        }
        cursor.Release();
        return arrayList;
    }

    @Override
    public void close() throws IOException {
        this.svc.Release();
        Ole32.INSTANCE.CoUninitialize();
    }
}

