/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.appwork.testframework.AWTest;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;

public class ZLibBug2022Test
extends AWTest {
    private static final String REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT = "repro_7_15_1_DEFAULTSTRATEGY_txt.txt";

    public static void main(String[] args) throws IOException {
        ZLibBug2022Test.run();
    }

    @Override
    public void runTest() throws Exception {
        this.testZipOutputStream();
        this.testDeflater();
    }

    protected void testDeflater() throws IOException, Error, Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream zipout = new DeflaterOutputStream((OutputStream)baos, new Deflater(7, true));
        try {
            IO.readStreamToOutputStream(-1, ZLibBug2022Test.class.getResource(REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT).openStream(), zipout, true);
        }
        finally {
            zipout.close();
        }
        byte[] compressedBytes = baos.toByteArray();
        System.out.println("Compressed Bytes: " + compressedBytes.length);
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(compressedBytes), new Inflater(true));
        byte[] bytes = IO.readStream(-1, in);
        in.close();
        System.out.println("Input: " + Hash.getSHA256(IO.readStream(-1, ZLibBug2022Test.class.getResource(REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT).openStream())));
        System.out.println("Test: " + Hash.getSHA256(bytes));
        ZLibBug2022Test.assertEquals(Hash.getSHA256(IO.readStream(-1, ZLibBug2022Test.class.getResource(REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT).openStream())), Hash.getSHA256(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testZipOutputStream() throws IOException, Error, Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipout = new ZipOutputStream(baos);
        try {
            zipout.setLevel(7);
            zipout.putNextEntry(new ZipEntry("Test.file"));
            try {
                IO.readStreamToOutputStream(-1, ZLibBug2022Test.class.getResource(REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT).openStream(), zipout, true);
            }
            finally {
                zipout.closeEntry();
                zipout.flush();
            }
        }
        finally {
            zipout.close();
        }
        byte[] compressedBytes = baos.toByteArray();
        System.out.println("Compressed Bytes: " + compressedBytes.length);
        ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(compressedBytes));
        ZipEntry e = in.getNextEntry();
        byte[] bytes = IO.readStream(-1, in);
        in.close();
        System.out.println("Input: " + Hash.getSHA256(IO.readStream(-1, ZLibBug2022Test.class.getResource(REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT).openStream())));
        System.out.println("Test: " + Hash.getSHA256(bytes));
        ZLibBug2022Test.assertEquals(Hash.getSHA256(IO.readStream(-1, ZLibBug2022Test.class.getResource(REPRO_7_15_1_DEFAULTSTRATEGY_TXT_TXT).openStream())), Hash.getSHA256(bytes));
    }
}

