/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.propertystate;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.WeakHashMap;
import org.appwork.propertystate.Manager;
import org.appwork.propertystate.PropertyState;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;

public class PropertyBuilder<T> {
    private Class<?> targetInterface;
    private static final WeakHashMap<Class<?>, Manager> CONTROLLER = new WeakHashMap();

    public PropertyBuilder(Class<T> interf) {
        this.targetInterface = interf;
    }

    public T build() {
        Manager manager = this.createManager(this.targetInterface);
        return this.build(manager);
    }

    public T build(Manager manager) {
        return (T)Proxy.newProxyInstance(this.targetInterface.getClassLoader(), new Class[]{this.targetInterface}, (InvocationHandler)new Handler(manager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manager createManager(Class<?> targetInterface2) {
        Manager manager;
        WeakHashMap<Class<?>, Manager> weakHashMap = CONTROLLER;
        synchronized (weakHashMap) {
            manager = CONTROLLER.get(this.targetInterface);
            if (manager == null) {
                manager = this.createManager();
            }
            CONTROLLER.put(this.targetInterface, manager);
        }
        return manager;
    }

    private Manager createManager() {
        return new Manager(null);
    }

    public static <T> Handler getHandler(T propertyState) {
        return (Handler)Proxy.getInvocationHandler(propertyState);
    }

    public static class Handler
    implements InvocationHandler {
        private Manager manager;
        private PropertyState state;

        public Manager getManager() {
            return this.manager;
        }

        public Handler(Manager manager) {
            this.manager = manager;
            this.state = manager.getEmptyState();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return "MemProp " + this.state.toString();
            }
            String key = ClassCache.createKey(method);
            if (key == null) {
                throw new IllegalArgumentException("No Setter or Getter " + method);
            }
            Handler handler = this;
            synchronized (handler) {
                if (args != null && args.length == 1) {
                    Object old = this.state.get(key);
                    this.state = this.manager.put(this.state, key, args[0]);
                    if (method.getReturnType() != Void.TYPE) {
                        return !CompareUtils.equalsDeep(old, this.state.get(key));
                    }
                    return null;
                }
                if (args == null || args.length == 0) {
                    if (method.getReturnType() != Void.TYPE) {
                        Object ret = this.state.get(key);
                        return ReflectionUtils.cast(ret, method.getReturnType());
                    }
                    throw new IllegalArgumentException("Invalid method " + method);
                }
                throw new IllegalArgumentException("Invalid method " + method);
            }
        }

        public void setState(Map<String, Object> map) {
            this.state = this.manager.createState(map);
        }

        public PropertyState getState() {
            return this.state;
        }
    }
}

