/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.remoteapi.ContentSecurityHeader;
import org.appwork.remoteapi.HelpMethod;
import org.appwork.remoteapi.InterfaceHandler;
import org.appwork.remoteapi.ParseException;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIInterface;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.Template;
import org.appwork.remoteapi.annotations.APIParameterNames;
import org.appwork.remoteapi.annotations.ApiDoc;
import org.appwork.remoteapi.annotations.ApiMethodName;
import org.appwork.remoteapi.annotations.ApiSessionRequired;
import org.appwork.remoteapi.annotations.HiddenForHelpDocs;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.storage.Storable;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;

public class DefaultDocsPageFactory
extends InterfaceHandler<Object> {
    public static final String AUTHENTICATION = "Authentication";
    protected final RemoteAPI api;
    private Method help;
    private SoftReference<byte[]> cachedBytes;
    private HashMap<Object, Integer> reservedAnchorIds;
    private HashSet<Object> dupeCheck;
    private AtomicInteger count = new AtomicInteger(0);

    public DefaultDocsPageFactory(RemoteAPI api) throws SecurityException, NoSuchMethodException {
        this.api = api;
    }

    protected boolean isAddObjectToHelp(Type returnType) {
        return Storable.class.isAssignableFrom((Class)returnType);
    }

    @Override
    public Object invoke(Method method, Object[] parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.help.invoke((Object)this, parameters);
    }

    @Override
    public Method getMethod(String methodName, int length) {
        return this.help;
    }

    @Override
    public void parse() throws ParseException {
    }

    public void link(HelpMethod helpMethod) throws NoSuchMethodException, SecurityException {
        this.help = this.getClass().getMethod("help", RemoteAPIRequest.class, RemoteAPIResponse.class);
        this.registerExtraMethod("help", this.help);
    }

    public void help(RemoteAPIRequest request, RemoteAPIResponse response) {
        try {
            byte[] bytes = null;
            byte[] byArray = bytes = this.cachedBytes != null ? this.cachedBytes.get() : null;
            if (bytes != null) {
                // empty if block
            }
            String txt = this.build();
            bytes = txt.getBytes("UTF-8");
            this.cachedBytes = new SoftReference<byte[]>(bytes);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html"));
            ContentSecurityHeader ret = new ContentSecurityHeader();
            ret.addDefaultSrc("'self'");
            ret.addScriptSrc("'unsafe-inline'");
            ret.addStyleSrc("'unsafe-inline'");
            ret.addImgSrc("data:");
            response.getResponseHeaders().add(new HTTPHeader("Content-Security-Policy", ret.toHeaderString()));
            response.setResponseCode(HTTPConstants.ResponseCode.SUCCESS_OK);
            response.sendBytes(request, bytes);
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
    }

    private String typeToString(HashSet<Type> requiredTypes, Type returnType, boolean html, boolean addExtends) {
        Class<?> currentType = returnType;
        if (currentType instanceof Class && ((Class)currentType).isArray()) {
            currentType = ((Class)currentType).getComponentType();
        }
        if (currentType instanceof Class) {
            Type genSuper;
            Class cls = currentType;
            if (BasicRemoteAPIException.class.isAssignableFrom(currentType)) {
                try {
                    BasicRemoteAPIException inst = null;
                    try {
                        Constructor c = cls.getDeclaredConstructor(new Class[0]);
                        c.setAccessible(true);
                        inst = (BasicRemoteAPIException)c.newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor c = cls.getDeclaredConstructor(String.class);
                        c.setAccessible(true);
                        inst = (BasicRemoteAPIException)c.newInstance("");
                    }
                    if (inst.getData() != null) {
                        return "ResponseCode " + inst.getCode().getCode() + " (" + inst.getCode().getDescription() + "); Type:" + inst.getType() + "; Description: " + inst.getData();
                    }
                    return "ResponseCode " + inst.getCode().getCode() + " (" + inst.getCode().getDescription() + "); Type:" + inst.getType() + "";
                }
                catch (Throwable e) {
                    System.out.println("Unsupported Exception type: " + returnType + "|" + currentType);
                }
            }
            String ret = this.modifyName(returnType.getSimpleName());
            if (addExtends && (genSuper = returnType.getGenericSuperclass()) instanceof ParameterizedType && genSuper.toString().startsWith("org.appwork.")) {
                ret = ret + " extends " + this.typeToString(requiredTypes, genSuper, html, addExtends);
            }
            if (requiredTypes != null && requiredTypes.contains(currentType)) {
                Integer aid = this.getReservedID(currentType);
                if (html) {
                    if (aid == null) {
                        if (currentType.isEnum()) {
                            return DefaultDocsPageFactory.htmlEncode("Enum:" + ret);
                        }
                        return DefaultDocsPageFactory.htmlEncode("Object:" + ret);
                    }
                    return "<a href='#tag_" + aid + "'>" + DefaultDocsPageFactory.htmlEncode(ret) + "</a>";
                }
                if (currentType.isEnum()) {
                    return "Enum:" + ret;
                }
                return "Object:" + ret;
            }
            return ret;
        }
        if (returnType instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)((Object)returnType)).getRawType();
            String ret = this.typeToString(requiredTypes, raw, html, addExtends);
            ret = ret + (html ? DefaultDocsPageFactory.htmlEncode("<") : "<");
            boolean first = true;
            for (Type subtype : ((ParameterizedType)((Object)returnType)).getActualTypeArguments()) {
                if (!first) {
                    ret = ret + ", ";
                }
                first = false;
                ret = ret + this.typeToString(requiredTypes, subtype, html, addExtends);
            }
            ret = ret + (html ? DefaultDocsPageFactory.htmlEncode(">") : ">");
            return ret;
        }
        if (returnType instanceof TypeVariable) {
            return ((TypeVariable)((Object)returnType)).getName();
        }
        return String.valueOf(returnType);
    }

    private String modifyName(String simpleName) {
        simpleName = simpleName.replaceAll("StorableV?\\d*$", "");
        if ("HashMap".equals(simpleName = simpleName.replaceAll("API$", ""))) {
            return "Map";
        }
        if ("HashSet".equals(simpleName)) {
            return "UnorderedList";
        }
        if ("LinkedHashSet".equals(simpleName)) {
            return "List";
        }
        if ("LinkedHashMap".equals(simpleName)) {
            return "Map";
        }
        if ("ArrayList".equals(simpleName)) {
            return "List";
        }
        if ("LinkedList".equals(simpleName)) {
            return "List";
        }
        if ("boolean".equals(simpleName)) {
            return "boolean";
        }
        if ("Boolean".equals(simpleName)) {
            return "boolean|null";
        }
        return simpleName;
    }

    public static String htmlEncode(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                out.append("&nbsp;");
                continue;
            }
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>') {
                out.append("&#" + c + ";");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String build() {
        HTMLStringBuilder content = new HTMLStringBuilder();
        HTMLStringBuilder nav = new HTMLStringBuilder();
        Template template = this.readHTMLTemplate();
        this.addTitle(template);
        ArrayList<InterfaceHandler<RemoteAPIInterface>> handlerList = this.createInterfaceHandlerList();
        Collections.sort(handlerList, new Comparator<InterfaceHandler<RemoteAPIInterface>>(){

            @Override
            public int compare(InterfaceHandler<RemoteAPIInterface> o1, InterfaceHandler<RemoteAPIInterface> o2) {
                return o1.getNamespace().toLowerCase(Locale.ENGLISH).compareTo(o2.getNamespace().toLowerCase(Locale.ENGLISH));
            }
        });
        nav.append("<h1 class='sidebarheader'>");
        nav.append("<a style='padding: 0;' href='#methods'>Methods</a>");
        nav.append("</h1>");
        nav.append("<ul>");
        this.reservedAnchorIds = new HashMap();
        this.dupeCheck = new HashSet();
        HashSet<Type> requiredTypes = new HashSet<Type>();
        for (InterfaceHandler<RemoteAPIInterface> handler : handlerList) {
            HashSet<Method> methodSet = new HashSet<Method>(handler.getMethodsMap().values());
            if (methodSet.size() == 0) continue;
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method m : methodSet) {
                if (m.getAnnotation(HiddenForHelpDocs.class) != null) continue;
                methods.add(m);
            }
            if (methods.size() == 0 || ((Method)methods.get(0)).getDeclaringClass().getAnnotation(HiddenForHelpDocs.class) != null || !this.isInterfaceVisible(((Method)methods.get(0)).getDeclaringClass())) continue;
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.getName().toLowerCase(Locale.ENGLISH).compareTo(o2.getName().toLowerCase(Locale.ENGLISH));
                }
            });
            nav.append("<li class='namespace'>");
            this.addMenuEntry(content, nav, 1, "Namespace /" + handler.getNamespace(), null, DefaultDocsPageFactory.htmlEncode(((Method)methods.get(0)).getDeclaringClass().getName()));
            nav.append("<ul  class='typelist'>");
            this.collectRequiredTypes(requiredTypes);
            for (Method m : methods) {
                void var12_16;
                String string = m.getName();
                ApiMethodName methodname = m.getAnnotation(ApiMethodName.class);
                if (methodname != null) {
                    String string2 = methodname.value();
                }
                String call = StringUtils.isEmpty(handler.getNamespace()) ? "/" + (String)var12_16 : "/" + handler.getNamespace() + "/" + (String)var12_16;
                String header = "";
                int count = 0;
                Type returnType = m.getGenericReturnType();
                requiredTypes.addAll(this.getTypes(returnType));
                for (Type rt : requiredTypes) {
                    this.putReservedID(rt);
                }
                APIParameterNames anno = m.getAnnotation(APIParameterNames.class);
                String[] parameterNames = anno == null ? null : anno.value();
                for (int i = 0; i < m.getGenericParameterTypes().length; ++i) {
                    if (m.getParameterTypes()[i] == RemoteAPIRequest.class || m.getParameterTypes()[i] == RemoteAPIResponse.class) continue;
                    if (count > 0) {
                        call = call + "&";
                        header = header + ", ";
                    } else {
                        call = call + "?";
                        header = header + "[";
                    }
                    ++count;
                    Class<?> paramClass = m.getParameterTypes()[i];
                    requiredTypes.addAll(this.getTypes(paramClass));
                    for (Type type : requiredTypes) {
                        this.putReservedID(type);
                    }
                    String paramName = this.typeToString(requiredTypes, paramClass, false, false);
                    if (parameterNames != null) {
                        if (i < parameterNames.length) {
                            call = call + new Regex(parameterNames[i], "^(\\S+)").getMatch(0);
                            header = header + parameterNames[i];
                            continue;
                        }
                        System.out.println("FIXME: Invalid APIParameterNames Annotation for Method:" + m.getName() + "|Class:" + m.getDeclaringClass().getName());
                        call = call + paramName;
                        header = header + paramName;
                        continue;
                    }
                    call = call + paramName;
                    header = header + paramName;
                }
                if (header.contains("[")) {
                    header = header + "]";
                }
                nav.append("<li class='type-method'>");
                for (Type rt : requiredTypes) {
                    this.putReservedID(rt);
                }
                int id = this.count.incrementAndGet();
                int i = 3;
                content.append("<a class='anchor' id='tag_" + id + "'></a><h3 class='main-type-method'><span  style=''>" + DefaultDocsPageFactory.htmlEncode((String)var12_16) + "</span><span  style='position: absolute;right: 20px;'>Parameter: " + count + "</span></h" + i + ">");
                nav.append("<div class='menu-h" + i + "'><a href=\"#tag_" + id + "\"><span class='menu-content-h" + i + " tooltip' ><span  style=''>" + DefaultDocsPageFactory.htmlEncode((String)var12_16) + "</span><span class='tooltiptext'>" + DefaultDocsPageFactory.htmlEncode("Parameter: " + count + " " + DefaultDocsPageFactory.htmlEncode(header)) + "</span></span></a></div>");
                nav.append("</li>");
                content.append("<ul class='keyvalue'>");
                if (m.getAnnotation(Deprecated.class) != null) {
                    content.append("<li><p class='deprecated'>DEPRECATED Method. This method will be removed soon. DO NOT USE IT!</p></li>");
                }
                if (m.getAnnotation(ApiSessionRequired.class) != null || m.getDeclaringClass().getAnnotation(ApiSessionRequired.class) != null) {
                    this.addKeyValueEntry(content, AUTHENTICATION, "required");
                }
                HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
                for (Annotation a : m.getAnnotations()) {
                    try {
                        HashSet<String> lst;
                        String docKeyValue;
                        Method docKey = a.getClass().getDeclaredMethod("docKey", new Class[0]);
                        if (docKey == null || !StringUtils.isNotEmpty(docKeyValue = String.valueOf(docKey.invoke((Object)a, new Object[0])))) continue;
                        String docValueValue = "";
                        Method docValue = a.getClass().getDeclaredMethod("docValue", new Class[0]);
                        if (docKey != null) {
                            docValueValue = String.valueOf(docValue.invoke((Object)a, new Object[0]));
                        }
                        if (StringUtils.isEmpty(docValueValue)) {
                            docValueValue = "";
                        }
                        if ((lst = (HashSet<String>)map.get(docKeyValue)) == null) {
                            lst = new HashSet<String>();
                            map.put(docKeyValue, lst);
                        }
                        lst.add(docValueValue);
                    }
                    catch (Throwable docKey) {
                        // empty catch block
                    }
                }
                ArrayList arrayList = new ArrayList(map.keySet());
                Collections.sort(arrayList);
                for (String key : arrayList) {
                    ArrayList lst = new ArrayList((Collection)map.get(key));
                    for (int ii = 0; ii < lst.size(); ++ii) {
                        if (lst.size() > 0 && StringUtils.isEmpty((String)lst.get(ii))) continue;
                        if (ii == 0) {
                            this.addKeyValueEntry(content, key, (String)lst.get(ii));
                            continue;
                        }
                        this.addKeyValueEntry(content, "", (String)lst.get(ii));
                    }
                }
                count = 0;
                for (i = 0; i < m.getGenericParameterTypes().length; ++i) {
                    if (m.getParameterTypes()[i] == RemoteAPIRequest.class || m.getParameterTypes()[i] == RemoteAPIResponse.class) continue;
                    Class<?> paramClass = m.getParameterTypes()[i];
                    String paramNameHTML = this.typeToString(requiredTypes, paramClass, true, false);
                    this.addParameter(content, ++count, i, parameterNames, paramNameHTML);
                }
                String doc = this.getDocByMethod(m);
                if (StringUtils.isNotEmpty(doc)) {
                    this.addKeyValueEntry(content, "Description", doc);
                }
                this.addKeyValueEntry(content, "Call", call);
                String returnStr = this.typeToString(requiredTypes, returnType, true, false);
                if (!"void".equalsIgnoreCase(returnStr)) {
                    content.append("<li class='keyvalueentry'>");
                    content.append("<span class='key'>" + DefaultDocsPageFactory.htmlEncode("Return type") + "</span>").append("<span class='value'>" + returnStr + "</span>");
                    content.append("</li>");
                }
                this.appendPossibleErrors(requiredTypes, content, m);
                content.append("</ul>");
            }
            nav.comment("End of Methods");
            nav.append("</ul>");
            nav.append("</li>");
        }
        nav.append("</ul>");
        if (requiredTypes.size() > 0) {
            nav.append("<h1 class='sidebarheader'>");
            nav.append("<a style='padding: 0;' href='#objects'>Structures, Objects &amp; Enums</a>");
            nav.append("</h1>");
            nav.append("<ul>");
            ArrayList lst = new ArrayList(requiredTypes);
            Collections.sort(lst, new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    int ret = CompareUtils.compare(o2 instanceof Class && ((Class)o2).isEnum(), o1 instanceof Class && ((Class)o1).isEnum());
                    if (ret != 0) {
                        return ret;
                    }
                    return DefaultDocsPageFactory.this.typeToString(null, o1, false, false).compareTo(DefaultDocsPageFactory.this.typeToString(null, o2, false, false));
                }
            });
            boolean header = false;
            for (Type enumClass : lst) {
                if (!(enumClass instanceof Class) || !((Class)enumClass).isEnum() || !this.dupeCheck.add(enumClass)) continue;
                if (!header) {
                    nav.comment("Start of enums");
                    nav.append("<li class='namespace'>");
                    this.addMenuEntry(content, nav, 1, "Enums &amp; Constants", null, null);
                    nav.append("<ul  class='typelist'>");
                    header = true;
                }
                nav.append("<li class='type-enum'>");
                this.addMenuEntry(content, nav, 3, this.typeToString(null, enumClass, false, false), this.getReservedID(enumClass), DefaultDocsPageFactory.htmlEncode(enumClass.toString()));
                nav.append("</li>");
                Class num = (Class)enumClass;
                boolean i = false;
                content.append("<ul class='enums'>");
                for (Enum c : (Enum[])num.getEnumConstants()) {
                    String docs = "";
                    boolean deprecated = false;
                    try {
                        String doc;
                        Field fi = num.getField(c.name());
                        if (fi.getAnnotation(HiddenForHelpDocs.class) != null) continue;
                        if (fi.getAnnotation(Deprecated.class) != null) {
                            deprecated = true;
                        }
                        if (StringUtils.isNotEmpty(doc = this.getDocByField(fi))) {
                            docs = doc;
                            this.appendDocs(content, doc);
                        }
                    }
                    catch (NoSuchFieldException doc) {
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (LabelInterface.class.isAssignableFrom(num)) {
                        if (docs.length() > 0) {
                            docs = docs + "\r\n";
                        }
                        docs = docs + ((LabelInterface)((Object)c)).getLabel();
                        this.appendDocs(content, ((LabelInterface)((Object)c)).getLabel());
                    }
                    content.append("<li>");
                    if (StringUtils.isNotEmpty(docs)) {
                        content.append("<span class='tooltip'>" + c.name() + "<span class='tooltiptext'>" + DefaultDocsPageFactory.htmlEncode(docs) + "</span></span>");
                    } else if (deprecated) {
                        content.append(c.name() + " <span class='deprecated'>DEPRECATED! This field will be removed soon. DO NOT USE IT!</span>");
                    } else {
                        content.append(c.name());
                    }
                    content.append("</li>");
                }
                content.append("</ul>");
            }
            if (header) {
                nav.comment("End of enums");
                nav.append("</ul>");
            }
            header = false;
            for (Type enumClass : lst) {
                if (!(enumClass instanceof Class) || ((Class)enumClass).isEnum() || !this.dupeCheck.add(enumClass)) continue;
                if (!header) {
                    nav.comment("Start of objects");
                    nav.append("<li class='namespace'>");
                    this.addMenuEntry(content, nav, 1, "Structures &amp; Objects", null, null);
                    nav.append("<ul  class='typelist'>");
                    header = true;
                }
                nav.append("<li class='type-object'>");
                Integer aid = this.getReservedID(enumClass);
                int i = 3;
                int n = aid != null ? aid.intValue() : this.count.incrementAndGet();
                content.append("<div class='header" + i + "'><a class='anchor' id='tag_" + n + "'></a><h" + i + " class='tooltip'>" + DefaultDocsPageFactory.htmlEncode(this.typeToString(null, enumClass, false, true)) + "<span class='tooltiptext'>" + DefaultDocsPageFactory.htmlEncode(enumClass.toString()) + "</span></h" + i + "></div>");
                nav.append("<div class='menu-h" + i + "'><a href=\"#tag_" + n + "\">" + DefaultDocsPageFactory.htmlEncode(this.typeToString(null, enumClass, false, false)) + "</a></div>");
                nav.append("</li>");
                try {
                    ClassCache cc = ClassCache.getClassCache(enumClass);
                    content.append("<pre><code class=\"javascript\">");
                    try {
                        Method exampleMethod = ((Class)enumClass).getMethod("createHelpText", new Class[0]);
                        exampleMethod.setAccessible(true);
                        String ex = (String)exampleMethod.invoke(null, new Object[0]);
                        this.appendCodeComments(content, ex);
                    }
                    catch (NoSuchMethodException exampleMethod) {
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                    content.appendRaw("          my" + this.typeToString(null, enumClass, false, false) + " = ");
                    content.appendRaw("\r\n                  {");
                    HashSet<String> keySet = new HashSet<String>();
                    int widestKey = 0;
                    for (String sg : cc.getKeys()) {
                        keySet.add(sg);
                        widestKey = Math.max(sg.length(), widestKey);
                    }
                    ArrayList keyList = new ArrayList(keySet);
                    Collections.sort(keyList);
                    boolean first = true;
                    for (String key : keyList) {
                        String d;
                        if (!first) {
                            content.appendRaw(",");
                        }
                        first = false;
                        Type type = null;
                        String desc = "";
                        Getter g = cc.getGetter(key);
                        Setter setter = cc.getSetter(key);
                        if (g != null) {
                            type = g.getMethod().getGenericReturnType();
                            d = this.getDocByMethod(g.getMethod());
                            if (d != null) {
                                desc = d;
                            }
                        }
                        if (setter != null) {
                            type = setter.getMethod().getGenericParameterTypes()[0];
                            d = this.getDocByMethod(setter.getMethod());
                            if (d != null) {
                                if (desc.length() > 0) {
                                    desc = desc + "\r\n";
                                }
                                desc = desc + d;
                            }
                        }
                        this.appendCodeComments(content, desc);
                        if (StringUtils.isNotEmpty(desc)) {
                            content.appendRaw("\r\n                    <span class='tooltip'>" + StringUtils.fillPost("\"" + key + "\"", " ", widestKey + 2) + " = (" + this.typeToString(requiredTypes, type, true, false) + ")<span class='tooltiptext'>" + desc + "</span></span>");
                            continue;
                        }
                        content.appendRaw("\r\n                    " + StringUtils.fillPost("\"" + key + "\"", " ", widestKey + 2) + " = (" + this.typeToString(requiredTypes, type, true, false) + ")");
                    }
                    content.appendRaw("\r\n                  }");
                    content.append("</code></pre>");
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
            if (header) {
                nav.comment("End of enums");
                nav.append("</ul>");
            }
            nav.append("</ul>");
        }
        this.addNavigation(nav, template);
        this.addContent(content, template);
        return template.build();
    }

    protected ArrayList<InterfaceHandler<RemoteAPIInterface>> createInterfaceHandlerList() {
        return new ArrayList<InterfaceHandler<RemoteAPIInterface>>(this.api.getHandlerMap().values());
    }

    private Type resolveActualType(TypeVariable type, Method method, Type enumClass) {
        String name = type.getName();
        Type genSuper = ((Class)enumClass).getGenericSuperclass();
        Type sClass = ((Class)enumClass).getSuperclass().getGenericSuperclass();
        return null;
    }

    protected String getDocByField(Field fi) {
        ApiDoc docAnno = fi.getAnnotation(ApiDoc.class);
        if (docAnno != null) {
            return docAnno.value();
        }
        return null;
    }

    protected String getDocByMethod(Method m) {
        ApiDoc an = m.getAnnotation(ApiDoc.class);
        if (an != null) {
            return an.value();
        }
        return null;
    }

    protected boolean isInterfaceVisible(Class<?> iClass) {
        return true;
    }

    protected void appendCodeComments(HTMLStringBuilder content, String desc) {
        if (StringUtils.isNotEmpty(desc)) {
            content.appendRaw("\r\n    /**");
            for (String ss : desc.split("[\r\n]+")) {
                content.appendRaw("\r\n     * " + ss);
            }
            content.appendRaw("\r\n     */\r\n");
        }
    }

    protected void collectRequiredTypes(HashSet<Type> requiredTypes) {
    }

    protected void appendPossibleErrors(HashSet<Type> requiredTypes, HTMLStringBuilder content, Method m) {
        Type[] exs = m.getGenericExceptionTypes();
        if (exs != null && exs.length > 0) {
            boolean f = true;
            for (Type e : exs) {
                f = this.appendPossibleError(requiredTypes, content, f, e);
            }
        }
    }

    protected boolean appendPossibleError(HashSet<Type> requiredTypes, HTMLStringBuilder sb, boolean f, Type e) {
        String key = "Possible Error(s)";
        if (!f) {
            key = "&nbsp;";
        } else {
            f = false;
        }
        sb.append("<li class='keyvalueentry'>");
        sb.append("<span class='key'>" + DefaultDocsPageFactory.htmlEncode(key) + "</span>").append("<span class='value'>" + this.typeToString(requiredTypes, e, true, false) + "</span>");
        sb.append("</li>");
        return f;
    }

    protected void addContent(HTMLStringBuilder content, Template template) {
        template.put("content", content.toString());
    }

    protected void addNavigation(HTMLStringBuilder nav, Template template) {
        template.put("navigation", nav.toString());
    }

    protected void addTitle(Template template) {
        template.put("title", "API Documentation");
    }

    protected void putReservedID(Type rt) {
        if (this.reservedAnchorIds.get(rt) == null) {
            this.reservedAnchorIds.put(rt, this.count.incrementAndGet());
            System.out.println("PUT reserved: " + rt + " - " + this.reservedAnchorIds.get(rt));
        }
    }

    protected Integer getReservedID(Type enumClass) {
        System.out.println("Get reserved: " + enumClass + " - " + this.reservedAnchorIds.get(enumClass));
        return this.reservedAnchorIds.get(enumClass);
    }

    private void addMenuEntry(HTMLStringBuilder content, HTMLStringBuilder nav, int i, String string, Integer aid, String tooltipHTML) {
        int id;
        int n = id = aid != null ? aid.intValue() : this.count.incrementAndGet();
        if (StringUtils.isNotEmpty(tooltipHTML)) {
            content.append("<div class='header" + i + "'><a class='anchor' id='tag_" + id + "'></a><h" + i + " class='tooltip'>" + DefaultDocsPageFactory.htmlEncode(string) + "<span class='tooltiptext'>" + tooltipHTML + "</span></h" + i + "></div>");
        } else {
            content.append("<div class='header" + i + "'><a class='anchor' id='tag_" + id + "'></a><h" + i + " class=''>" + DefaultDocsPageFactory.htmlEncode(string) + "</h" + i + "></div>");
        }
        nav.append("<div class='menu-h" + i + "'><a href=\"#tag_" + id + "\">" + DefaultDocsPageFactory.htmlEncode(string) + "</a></div>");
    }

    protected void appendDocs(HTMLStringBuilder sb, String value) {
        if (StringUtils.isNotEmpty(value)) {
            sb.append("\r\n<span class='comment'>" + value.replaceAll("[\r\n]{1,2}", "</br>") + "</span>");
        }
    }

    private void addParameter(HTMLStringBuilder sb, int count, int i, String[] parameterNames, String paramNameHTML) {
        String key = null;
        String value = null;
        key = count == 1 ? "Parameter" : "&nbsp;";
        value = parameterNames != null ? (i < parameterNames.length ? DefaultDocsPageFactory.htmlEncode(count + " - " + parameterNames[i] + " (") + paramNameHTML + DefaultDocsPageFactory.htmlEncode(")") : DefaultDocsPageFactory.htmlEncode(count + " - ") + paramNameHTML) : DefaultDocsPageFactory.htmlEncode(count + " - ") + paramNameHTML;
        sb.append("<li class='keyvalueentry'>");
        sb.append("<span class='key'>" + DefaultDocsPageFactory.htmlEncode(key) + "</span>").append("<span class='value'>" + value + "</span>");
        sb.append("</li>");
    }

    private void addKeyValueEntry(HTMLStringBuilder sb, String key, String value) {
        sb.append("<li class='keyvalueentry'>");
        sb.append("<span class='key'>" + DefaultDocsPageFactory.htmlEncode(key) + "</span>").append("<span class='value'>" + DefaultDocsPageFactory.htmlEncode(value) + "</span>");
        sb.append("</li>");
    }

    protected Template readHTMLTemplate() {
        try {
            String ret = IO.readURLToString(InterfaceHandler.class.getResource("html/docs.html"));
            Template t = new Template(ret);
            t.put("style", "<style>\r\n" + this.readCSSStyle() + "\r\n</style>");
            t.put("highlight.js", IO.readURLToString(InterfaceHandler.class.getResource("html/highlight.js")));
            t.put("highlight.js.css", IO.readURLToString(InterfaceHandler.class.getResource("html/highlight.js.css")));
            return t;
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
    }

    protected String readCSSStyle() {
        try {
            return IO.readURLToString(InterfaceHandler.class.getResource("html/style.css"));
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
    }

    private List<Type> getTypes(Type returnType) {
        return this.getTypes(returnType, new HashSet<Type>());
    }

    private List<Type> getTypes(Type returnType, HashSet<Type> dupe) {
        ArrayList<Type> ret = new ArrayList<Type>();
        if (!dupe.add(returnType)) {
            return ret;
        }
        if (returnType instanceof Class) {
            if (((Class)returnType).isEnum()) {
                ret.add(returnType);
                return ret;
            }
            if (((Class)returnType).isArray()) {
                Class<?> componentType = ((Class)returnType).getComponentType();
                ret.addAll(this.getTypes(componentType, dupe));
                return ret;
            }
            if (!this.isAddObjectToHelp(returnType)) {
                return ret;
            }
            ret.add(returnType);
            try {
                ClassCache cc = ClassCache.getClassCache(returnType);
                for (Getter getter : cc.getAllGetter()) {
                    ret.addAll(this.getTypes(getter.getMethod().getGenericReturnType(), dupe));
                }
                for (Setter setter : cc.getAllSetter()) {
                    ret.addAll(this.getTypes(setter.getMethod().getGenericParameterTypes()[0], dupe));
                }
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        } else if (returnType instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)returnType).getRawType();
            ret.addAll(this.getTypes(raw, dupe));
            for (Type subtype : ((ParameterizedType)returnType).getActualTypeArguments()) {
                ret.addAll(this.getTypes(subtype, dupe));
            }
        }
        return ret;
    }

    public class HTMLStringBuilder {
        private StringBuilder sb = new StringBuilder();

        public String toString() {
            return this.sb.toString();
        }

        public HTMLStringBuilder append(String string) {
            this.sb.append(string);
            this.sb.append("\r\n");
            return this;
        }

        public HTMLStringBuilder comment(String string) {
            this.sb.append("\r\n");
            this.sb.append("<!--" + string + "-->");
            this.sb.append("\r\n");
            return this;
        }

        public HTMLStringBuilder appendRaw(String string) {
            this.sb.append(string);
            return this;
        }
    }
}

