/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.storage.config.annotations.DefaultEnumArrayValue;
import org.appwork.storage.config.handler.ObjectKeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.DebugMode;

public class EnumSetKeyHandler
extends ObjectKeyHandler {
    public EnumSetKeyHandler(StorageHandler<?> storageHandler, String key, Type type) {
        super(storageHandler, key, type);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultEnumArrayValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        DefaultEnumArrayValue ann = this.getAnnotation(DefaultEnumArrayValue.class);
        if (ann != null) {
            ArrayList ret = new ArrayList();
            for (String value : ann.value()) {
                try {
                    String clazz;
                    String name;
                    int index = value.lastIndexOf(".");
                    if (index == -1) {
                        name = value;
                        ParameterizedType type = (ParameterizedType)this.getRawType();
                        clazz = ((Class)type.getActualTypeArguments()[0]).getName();
                    } else {
                        name = value.substring(index + 1);
                        clazz = value.substring(0, index);
                    }
                    ret.add(Enum.valueOf(Class.forName(clazz), name));
                }
                catch (Exception e) {
                    DebugMode.debugger(e);
                }
            }
            this.setDefaultValue(new CopyOnWriteArraySet(ret));
        } else {
            this.setDefaultValue(null);
        }
    }
}

