/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.tests;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.test.TestClassWithGenericArrayType;
import org.appwork.storage.simplejson.mapper.test.TestClassWithGenericArrayType2;
import org.appwork.testframework.AWTest;
import org.appwork.utils.reflection.CompiledType;

public class FlexiMapperTestGenericArrays
extends AWTest {
    public static void main(String[] args) throws FlexiMapperException, FlexiParserException {
        FlexiMapperTestGenericArrays.run();
    }

    @Override
    public void runTest() throws Exception {
        this.testTestClassWithGenericArrayType();
        this.testTestClassWithGenericArrayType2();
    }

    public void testTestClassWithGenericArrayType2() throws NoSuchMethodException, Exception, FlexiMapperException, FlexiParserException {
        TestClassWithGenericArrayType2<String> inst = new TestClassWithGenericArrayType2<String>();
        FlexiJSonMapper mapper = new FlexiJSonMapper(){

            @Override
            protected boolean isAnnotationCommentsEnabled() {
                return true;
            }

            @Override
            protected boolean isTypeCommentsEnabled() {
                return true;
            }
        };
        ClassCache cc = ClassCache.getClassCache(new TypeRef<TestClassWithGenericArrayType2<String>>(){}.getType());
        FlexiMapperTestGenericArrays.assertTrue(cc.getGetter((String)"array").type instanceof GenericArrayType);
        inst.setArray(new String[]{"mystitng"});
        inst.setGenArray(new ArrayList[]{new ArrayList<String>(Arrays.asList("A", "AB"))});
        String jsonmini = FlexiUtils.serializeMinimized(inst);
        CompiledType ctype = CompiledType.create(new TypeRef<TestClassWithGenericArrayType2<String>>(){});
        Type genericArrayType = new TypeRef<ArrayList<String>[]>(){}.getType();
        FlexiJSonNode nodes = mapper.objectToJsonNode(inst, new TypeRef<TestClassWithGenericArrayType2<String>>(){});
        String json1 = new FlexiJSonPrettyStringify().toJSONString(nodes);
        FlexiMapperTestGenericArrays.assertTrue(json1.contains("Type: Array<String>"));
        FlexiMapperTestGenericArrays.assertEquals(jsonmini, "{\"array\":[\"mystitng\"],\"genArray\":[[\"A\",\"AB\"]]}");
        TestClassWithGenericArrayType2<String> restored = FlexiUtils.jsonToObject(jsonmini, FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, new TypeRef<TestClassWithGenericArrayType2<String>>(){});
        FlexiMapperTestGenericArrays.assertEqualsDeep(inst, restored);
    }

    public void testTestClassWithGenericArrayType() throws NoSuchMethodException, Exception, FlexiMapperException, FlexiParserException {
        ClassCache cc = ClassCache.getClassCache(new TypeRef<TestClassWithGenericArrayType>(){}.getType());
        FlexiMapperTestGenericArrays.assertTrue(cc.getGetter((String)"genArray1").type instanceof GenericArrayType);
        TestClassWithGenericArrayType inst1 = new TestClassWithGenericArrayType();
        ArrayList[] test = new ArrayList[]{new ArrayList<String>(Arrays.asList("entry"))};
        inst1.setGenArray1(test);
        String json1 = FlexiUtils.serializeConfigStorable(inst1);
        FlexiMapperTestGenericArrays.assertTrue(json1.contains("Type: Array<Array<String>>"));
        FlexiMapperTestGenericArrays.assertTrue(json1.contains("\"genArray1\":[[\"entry\"]]"));
        String jsonmini = FlexiUtils.serializeMinimized(inst1);
        FlexiMapperTestGenericArrays.assertEquals(jsonmini, "{\"genArray1\":[[\"entry\"]]}");
        TestClassWithGenericArrayType restored = (TestClassWithGenericArrayType)FlexiUtils.jsonToObject(jsonmini, FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, new SimpleTypeRef((Type)((Object)TestClassWithGenericArrayType.class)));
        FlexiMapperTestGenericArrays.assertEqualsDeep(inst1, restored);
    }
}

