/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.simplejson.mapper.Property;
import org.appwork.utils.reflection.CompiledType;

public abstract class FlexiWalker {
    public static final FlexiJSonNode SKIP = new FlexiJSonValue();
    private FlexiJSonNode root;
    private CompiledType rootType;

    public FlexiWalker(FlexiJSonNode node, CompiledType type) {
        this.root = node;
        this.rootType = type;
    }

    public FlexiJSonNode run() {
        JSPath path = new JSPath();
        FlexiJSonNode newNode = this.build(this.root, this.rootType, path);
        if (!this.runOn(this.root, this.rootType, path, newNode)) {
            this.root = null;
        }
        return newNode;
    }

    public FlexiJSonNode getRoot() {
        return this.root;
    }

    protected FlexiJSonNode build(FlexiJSonNode sourceNode, CompiledType type, JSPath path) {
        return SKIP;
    }

    private boolean runOn(FlexiJSonNode node, CompiledType type, JSPath path, FlexiJSonNode buildNode) {
        block11: {
            FlexiJSonNode newNode;
            block10: {
                if (!this.onNode(node, type, path)) {
                    return false;
                }
                newNode = null;
                if (!(node instanceof FlexiJSonArray)) break block10;
                FlexiJSonArray array = (FlexiJSonArray)node;
                int i = 0;
                type = type == null ? null : type.getComponentTypeFor(Collection.class, Arrays.class);
                Iterator it = array.iterator();
                while (it.hasNext()) {
                    FlexiJSonNode sub = (FlexiJSonNode)it.next();
                    JSPath newPath = path.derive(i++);
                    if (buildNode != null && buildNode != SKIP && (newNode = this.build(sub, type, newPath)) != SKIP) {
                        ((FlexiJSonArray)buildNode).add(newNode);
                    }
                    if (this.runOn(sub, type, newPath, newNode)) continue;
                    it.remove();
                }
                break block11;
            }
            if (!(node instanceof FlexiJSonObject)) break block11;
            FlexiJSonObject object = (FlexiJSonObject)node;
            Iterator it = object.getElements().iterator();
            while (it.hasNext()) {
                KeyValueElement e = (KeyValueElement)it.next();
                CompiledType sub = null;
                if (type != null) {
                    if (type.isMap()) {
                        sub = type.getComponentTypeFor(Map.class);
                    } else {
                        Property prop = type.getClassCache().getProperty(e.getKey());
                        if (prop != null) {
                            sub = prop.type;
                        }
                    }
                }
                JSPath newPath = path.derive(e.getKey());
                if (newNode != null) {
                    newNode = this.build(e.getValue(), sub, newPath);
                    if (buildNode != null && buildNode != SKIP) {
                        ((FlexiJSonObject)buildNode).add(new KeyValueElement((FlexiJSonObject)buildNode, newPath, e.getKey(), newNode));
                    }
                }
                if (this.runOn(e.getValue(), sub, newPath, newNode)) continue;
                it.remove();
            }
        }
        return true;
    }

    private FlexiJSonNode build(FlexiJSonNode node, FlexiJSonNode newNode, CompiledType type, JSPath path) {
        return null;
    }

    public abstract boolean onNode(FlexiJSonNode var1, CompiledType var2, JSPath var3);
}

