/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonUtils;
import org.appwork.storage.simplejson.ValueType;
import org.appwork.utils.reflection.Clazz;

public class JSonValue
implements JSonNode,
Storable {
    public static final JSonValue BOOLEAN_TRUE = new JSonValue(true){

        @Override
        public void setValue(Object value) {
            throw new IllegalStateException();
        }

        @Override
        public void setType(ValueType type) {
            throw new IllegalStateException();
        }
    };
    public static final JSonValue BOOLEAN_FALSE = new JSonValue(false){

        @Override
        public void setValue(Object value) {
            throw new IllegalStateException();
        }

        @Override
        public void setType(ValueType type) {
            throw new IllegalStateException();
        }
    };
    public static final JSonValue BOOLEAN_NULL = new JSonValue((Boolean)null){

        @Override
        public void setValue(Object value) {
            throw new IllegalStateException();
        }

        @Override
        public void setType(ValueType type) {
            throw new IllegalStateException();
        }
    };
    public static final JSonValue NULL = new JSonValue((String)null){

        @Override
        public void setValue(Object value) {
            throw new IllegalStateException();
        }

        @Override
        public void setType(ValueType type) {
            throw new IllegalStateException();
        }
    };
    protected Object value;
    protected ValueType type;

    public void setValue(Object value) {
        this.value = value;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public JSonValue() {
        this.value = null;
    }

    public JSonValue(Boolean b) {
        this.value = b;
        this.type = ValueType.BOOLEAN;
    }

    public JSonValue(Number number) {
        this.value = number;
        this.type = Clazz.isFloatingPointNumber(number.getClass()) ? ValueType.DOUBLE : ValueType.LONG;
    }

    public JSonValue(String str) {
        if (str == null) {
            this.value = null;
            this.type = ValueType.NULL;
        } else {
            this.value = str;
            this.type = ValueType.STRING;
        }
    }

    public ValueType getType() {
        return this.type;
    }

    @AllowNonStorableObjects
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.getType()) {
            case BOOLEAN: 
            case DOUBLE: 
            case LONG: {
                return this.getValue().toString();
            }
            case STRING: {
                return "\"" + JSonUtils.escape(this.getValue().toString()) + "\"";
            }
            case NULL: {
                return "null";
            }
            case UNDEFINED: {
                return "undefined";
            }
        }
        return null;
    }

    @Override
    public String toPrettyString() {
        return this.toString();
    }
}

