/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.action;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.appwork.swing.components.tooltips.TooltipFactory;
import org.appwork.utils.KeyUtils;

public abstract class BasicAction
extends AbstractAction {
    private static final long serialVersionUID = -198177718803470771L;
    private TooltipFactory tooltipFactory;
    private boolean toggle = false;

    public static int charToMnemonic(char mnemonic) {
        try {
            Field f = KeyEvent.class.getField("VK_" + Character.toUpperCase(mnemonic));
            return (Integer)f.get(null);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public BasicAction() {
    }

    public BasicAction(String name) {
        super(name);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getShortCutString() {
        Object value = this.getValue("AcceleratorKey");
        return value == null ? null : KeyUtils.getShortcutString((KeyStroke)this.getValue("AcceleratorKey"), true);
    }

    public Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public TooltipFactory getTooltipFactory() {
        return this.tooltipFactory;
    }

    public String getTooltipText() {
        try {
            Object ret = this.getValue("ShortDescription");
            return ret == null ? null : ret.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isSelected() {
        Object value = this.getValue("SwingSelectedKey");
        return value == null ? false : (Boolean)value;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public BasicAction setAccelerator(KeyStroke stroke) {
        this.putValue("AcceleratorKey", stroke);
        return this;
    }

    public void setMnemonic(String key) {
        char mnemonic;
        if (this.getName() == null) {
            throw new IllegalStateException("First set Name");
        }
        if (key == null) {
            key = "-";
        }
        if ((mnemonic = key.charAt(0)) != '\u0000' && !key.contentEquals("-")) {
            int m = BasicAction.charToMnemonic(mnemonic);
            this.putValue("MnemonicKey", m);
            this.putValue("SwingDisplayedMnemonicIndexKey", this.getName().indexOf(m));
        }
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
        this.toggle = true;
    }

    public void setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setTooltipFactory(TooltipFactory factory) {
        this.tooltipFactory = factory;
    }

    public void setTooltipText(String text) {
        this.putValue("ShortDescription", text);
    }
}

