/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.circlebar;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.appwork.swing.components.IconComponentInterface;
import org.appwork.swing.components.circlebar.BasicCircleProgressBarUI;
import org.appwork.swing.components.circlebar.CircleProgressBarUI;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipFactory;
import org.appwork.swing.components.tooltips.TooltipTextDelegateFactory;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEventSender;

public class CircledProgressBar
extends JComponent
implements ToolTipHandler,
IconComponentInterface {
    private static final long serialVersionUID = -3518805542131925575L;
    private BoundedRangeModel model;
    private ChangeListener changeListener;
    private boolean indeterminate;
    private final ChangeEventSender eventSender = new ChangeEventSender();
    private IconPainter valueClipPainter;
    private IconPainter nonvalueClipPainter;
    private static final String UI_CLASS_ID = "CircleProgressBarUI";
    private TooltipFactory tooltipFactory = new TooltipTextDelegateFactory(this);

    public CircledProgressBar() {
        this(new DefaultBoundedRangeModel());
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public CircledProgressBar(BoundedRangeModel model) {
        this.installPainer();
        this.setModel(model);
        BasicProgressBarUI.class.getAnnotations();
        this.updateUI();
        this.setIndeterminate(false);
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(javax.swing.event.ChangeEvent e) {
                CircledProgressBar.this.eventSender.fireEvent(new ChangeEvent(e.getSource()));
            }
        };
    }

    @Override
    public boolean isTooltipWithoutFocusEnabled() {
        return true;
    }

    @Override
    public ExtTooltip createExtTooltip(Point mousePosition) {
        return this.tooltipFactory.createTooltip();
    }

    public int getAnimationFPS() {
        return 25;
    }

    public float getCyclesPerSecond() {
        return 0.5f;
    }

    public ChangeEventSender getEventSender() {
        return this.eventSender;
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public IconPainter getNonvalueClipPainter() {
        return this.nonvalueClipPainter;
    }

    public TooltipFactory getTooltipFactory() {
        return this.tooltipFactory;
    }

    @Override
    public Dimension getSize() {
        return super.getSize();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public IconPainter getValueClipPainter() {
        return this.valueClipPainter;
    }

    private void installPainer() {
        this.valueClipPainter = new IconPainter(){
            private Dimension dimension = new Dimension(32, 32);

            @Override
            public void paint(CircledProgressBar bar, Graphics2D g2, Shape shape, int diameter, double progress) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(CircledProgressBar.this.getForeground());
                Area a = new Area(shape);
                a.intersect(new Area(new Ellipse2D.Float(-diameter / 2, -diameter / 2, diameter, diameter)));
                g2.fill(a);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.dimension;
            }
        };
    }

    protected void invertPainter() {
        IconPainter fg = this.valueClipPainter;
        this.valueClipPainter = this.nonvalueClipPainter;
        this.nonvalueClipPainter = fg;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    @Override
    public boolean isTooltipDisabledUntilNextRefocus() {
        return true;
    }

    public void setIndeterminate(boolean newValue) {
        boolean oldValue = this.indeterminate;
        if (oldValue == newValue) {
            return;
        }
        this.indeterminate = newValue;
        this.firePropertyChange("indeterminate", oldValue, this.indeterminate);
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public synchronized void setModel(BoundedRangeModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            model.removeChangeListener(this.changeListener);
        }
        this.changeListener = this.createChangeListener();
        model.addChangeListener(this.changeListener);
        this.model = model;
        this.repaint();
    }

    public void setNonvalueClipPainter(IconPainter backgroundPainter) {
        this.nonvalueClipPainter = backgroundPainter;
    }

    public void setString(String string) {
    }

    public void setStringPainted(boolean b) {
    }

    public void setTooltipFactory(TooltipFactory tooltipFactory) {
        this.tooltipFactory = tooltipFactory;
        ToolTipController.getInstance().register(this);
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
        if (text == null || text.length() == 0) {
            ToolTipController.getInstance().unregister(this);
        } else {
            ToolTipController.getInstance().register(this);
        }
    }

    public void setUI(CircleProgressBarUI ui) {
        super.setUI(ui);
    }

    public void setValue(int n) {
        BoundedRangeModel brm = this.getModel();
        int oldValue = brm.getValue();
        brm.setValue(n);
    }

    public void setValueClipPainter(IconPainter iconPainter) {
        this.valueClipPainter = iconPainter;
    }

    @Override
    public int getTooltipDelay(Point mousePositionOnScreen) {
        return 0;
    }

    @Override
    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        return false;
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicCircleProgressBarUI());
    }

    @Override
    public List<Icon> getIcons(int x, int y) {
        Icon ico;
        ArrayList<Icon> ret = new ArrayList<Icon>();
        if (this.valueClipPainter != null && this.valueClipPainter instanceof ImagePainter && (ico = ((ImagePainter)this.valueClipPainter).getImage()) != null) {
            ret.add(ico);
        }
        if (this.nonvalueClipPainter != null && this.nonvalueClipPainter instanceof ImagePainter && (ico = ((ImagePainter)this.nonvalueClipPainter).getImage()) != null) {
            ret.add(ico);
        }
        return ret;
    }
}

