/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.multiprogressbar;

import javax.swing.JComponent;
import org.appwork.swing.components.multiprogressbar.BasicMultiProgressModelUI;
import org.appwork.swing.components.multiprogressbar.MultiProgressBarUI;
import org.appwork.swing.components.multiprogressbar.MultiProgressEvent;
import org.appwork.swing.components.multiprogressbar.MultiProgressEventSender;
import org.appwork.swing.components.multiprogressbar.MultiProgressModel;
import org.appwork.swing.components.multiprogressbar.MultiProgressModelListener;
import org.appwork.swing.components.multiprogressbar.Range;

public class MultiProgressBar
extends JComponent {
    private static final String UI_CLASS_ID = "MultiProgressBarUI";
    private MultiProgressModel model;
    private MultiProgressModelListener listener;
    private MultiProgressEventSender eventSender = new MultiProgressEventSender();
    private MultiProgressEvent changeEvent = new MultiProgressEvent(this);

    public MultiProgressEventSender getEventSender() {
        return this.eventSender;
    }

    public MultiProgressBar(long max) {
        this(new MultiProgressModel(max, new Range[0]));
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicMultiProgressModelUI());
    }

    public synchronized void setModel(MultiProgressModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            model.getEventSender().removeListener(this.listener);
        }
        this.listener = new MultiProgressModelListener(){

            @Override
            public void onChanged() {
                MultiProgressBar.this.eventSender.fireEvent(MultiProgressBar.this.changeEvent);
            }
        };
        model.getEventSender().addListener(this.listener);
        this.model = model;
        this.repaint();
    }

    public void setUI(MultiProgressBarUI ui) {
        super.setUI(ui);
    }

    public MultiProgressBar(MultiProgressModel multiProgressModel) {
        this.setModel(multiProgressModel);
        this.updateUI();
    }

    public MultiProgressModel getModel() {
        return this.model;
    }
}

