/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.searchcombo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.appwork.loggingv3.LogV3;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.searchcombo.ColorState;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;

public abstract class SearchComboBox<T>
extends JComboBox {
    private int actualMaximumRowCount = 8;
    public boolean autoCompletionEnabled = true;
    private static final long serialVersionUID = 6475635443708682554L;
    private final ColorState helpColorSet = new ColorState(Color.LIGHT_GRAY);
    private final ColorState badColorSet = new ColorState(Color.RED);
    private final ColorState normalColorSet = new ColorState(Color.BLACK);
    private String helptext;
    private boolean unkownTextInputAllowed;
    protected ImageIcon badgeIcon;
    private ColorState currentColorSet;
    private List<T> data;
    private boolean byPassTxtUpdate;

    protected void searchAutoComplete(ComboBoxModel model, String txt, List<T> found, List<T> all) {
        if (!this.isSearchCaseSensitive()) {
            txt = txt.toLowerCase(Locale.ROOT);
        }
        for (int i = 0; i < model.getSize(); ++i) {
            Object element = this.getModel().getElementAt(i);
            all.add(element);
            String text = this.getTextForValue(element);
            if (!this.matches(text, txt)) continue;
            found.add(element);
        }
    }

    protected boolean isSetTextFieldOnlyForSingleMatch() {
        return false;
    }

    protected boolean matches(String element, String matches) {
        return element != null && matches != null && (element.startsWith(matches) || !this.isSearchCaseSensitive() && element.toLowerCase(Locale.ENGLISH).startsWith(matches));
    }

    public SearchComboBox() {
        this((List)null);
    }

    protected void safeSet(String text) {
        ((Editor)this.editor).safeSet(text);
    }

    public SearchComboBox(T ... elements) {
        this(Arrays.asList(elements));
    }

    public SearchComboBox(List<T> plugins) {
        super((ComboBoxModel)null);
        this.normalColorSet.setForeground(this.getForeground());
        Color disabled = (Color)UIManager.get("TextField.disabledForeground");
        if (disabled != null) {
            this.helpColorSet.setForeground(disabled);
        }
        this.unkownTextInputAllowed = false;
        this.byPassTxtUpdate = false;
        this.data = plugins;
        this.setEditor(new Editor(this));
        if (plugins != null) {
            this.setList(plugins, true);
        }
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchComboBox.this.getEditor().getEditorComponent().requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchComboBox.this.hidePopup();
            }
        });
        this.setEditable(true);
        final ListCellRenderer org = this.getRenderer();
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SearchComboBox.this.setMaximumRowCount(SearchComboBox.this.getActualMaximumRowCount());
            }
        });
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                try {
                    JLabel ret = (JLabel)org.getListCellRendererComponent(list, SearchComboBox.this.getTextForValue(value), index, isSelected, cellHasFocus);
                    ret.setIcon(SearchComboBox.this.getIconForValue(value));
                    return ret;
                }
                catch (Throwable e) {
                    return org.getListCellRendererComponent(list, SearchComboBox.this.getTextForValue(value), index, isSelected, cellHasFocus);
                }
            }
        });
        this.setColorState(this.normalColorSet);
    }

    public JTextField createTextField() {
        return new JTextField(){
            private static final long serialVersionUID = 8594276945732071594L;
            private boolean key = false;

            @Override
            public void setText(String t) {
                super.setText(t);
            }

            @Override
            public void replaceSelection(String content) {
                if (this.key) {
                    super.replaceSelection(content);
                } else {
                    this.setText(content);
                }
            }

            @Override
            protected void fireActionPerformed() {
                if (SearchComboBox.this.isPopupVisible()) {
                    Object selected = SearchComboBox.this.getSelectedItem();
                    this.setText(SearchComboBox.this.getTextForValue(SearchComboBox.this.getSelectedItem()));
                }
                super.fireActionPerformed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                this.key = true;
                try {
                    boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                    return bl;
                }
                finally {
                    this.key = false;
                }
            }
        };
    }

    public int getActualMaximumRowCount() {
        return this.actualMaximumRowCount;
    }

    public String getEditorText() {
        return this.getTextField().getText();
    }

    protected abstract Icon getIconForValue(T var1);

    public T getSelectedItem() {
        return (T)super.getSelectedItem();
    }

    public String getText() {
        String ret = this.getTextField().getText();
        if (ret.equals(this.helptext)) {
            ret = "";
        }
        return ret;
    }

    public JTextField getTextField() {
        if (this.getEditor() == null) {
            return null;
        }
        return ((Editor)this.getEditor()).getTf();
    }

    protected abstract String getTextForValue(T var1);

    @Override
    public boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        ComboBoxEditor lEditor = this.getEditor();
        if (lEditor instanceof Editor) {
            return ((Editor)lEditor).getTf().hasFocus();
        }
        return false;
    }

    public boolean isAutoCompletionEnabled() {
        return this.autoCompletionEnabled;
    }

    public boolean isHelpTextVisible() {
        return this.helptext != null && this.helptext.equals(this.getText());
    }

    protected boolean isSearchCaseSensitive() {
        return false;
    }

    public boolean isUnkownTextInputAllowed() {
        return this.unkownTextInputAllowed;
    }

    public void onChanged() {
    }

    public void setActualMaximumRowCount(int count) {
        this.actualMaximumRowCount = count;
    }

    public void setAutoCompletionEnabled(boolean autoCompletionEnabled) {
        this.autoCompletionEnabled = autoCompletionEnabled;
    }

    public void setBadColor(Color color) {
        this.badColorSet.setForeground(color);
        JTextField tf = this.getTextField();
        if (tf != null) {
            tf.setForeground(this.currentColorSet.getForeground());
        }
    }

    private void setColorState(ColorState cs) {
        this.currentColorSet = cs;
        JTextField tf = this.getTextField();
        if (tf != null) {
            tf.setForeground(this.currentColorSet.getForeground());
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.setNormalColor(fg);
    }

    public void setHelpText(String helptext) {
        this.helptext = helptext;
        this.updateHelpText();
    }

    public T getProtoType(List<T> model) {
        if (this.usePrototype() && model != null && model.size() > 0) {
            return model.get(0);
        }
        return null;
    }

    public void setList(List<T> listModel) {
        this.setList(listModel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(List<T> listModel, boolean autoSelectFirstModelElement) {
        this.data = listModel;
        T prototype = this.getProtoType(listModel);
        if (this.usePrototype()) {
            this.setPrototypeDisplayValue(prototype);
        }
        if (!autoSelectFirstModelElement) {
            this.byPassTxtUpdate = true;
        }
        try {
            super.setModel(new DefaultComboBoxModel<Object>(listModel.toArray(new Object[0])));
        }
        finally {
            if (!autoSelectFirstModelElement) {
                this.setSelectedItem(null);
                this.byPassTxtUpdate = false;
            }
        }
        try {
            Accessible a;
            if (prototype != null && (a = this.getUI().getAccessibleChild(this, 0)) instanceof ComboPopup) {
                JList<Object> popupList = ((ComboPopup)((Object)a)).getList();
                popupList.setPrototypeCellValue(prototype);
            }
        }
        catch (Throwable a) {
            // empty catch block
        }
        try {
            BasicComboBoxUI udi = (BasicComboBoxUI)this.getUI();
            JComponent arrowButton = null;
            try {
                Field field = BasicComboBoxUI.class.getDeclaredField("arrowButton");
                Object bla = null;
                if (field != null) {
                    field.setAccessible(true);
                    arrowButton = (JComponent)field.get(udi);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (listModel.size() > 0) {
                udi.unconfigureArrowButton();
                udi.configureArrowButton();
                if (arrowButton != null) {
                    arrowButton.setEnabled(true);
                }
            } else {
                udi.unconfigureArrowButton();
                if (arrowButton != null) {
                    arrowButton.setEnabled(false);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.getEditor().getEditorComponent().setEnabled(b);
        super.setEnabled(b);
    }

    @Override
    @Deprecated
    public void setMaximumRowCount(int count) {
        super.setMaximumRowCount(count);
    }

    @Deprecated
    public void setModel(ComboBoxModel aModel) {
        if (aModel == null) {
            super.setModel(new DefaultComboBoxModel());
            return;
        }
        throw new RuntimeException("Use setList()");
    }

    public void setNormalColor(Color fg) {
        JTextField tf = this.getTextField();
        if (tf != null) {
            tf.setForeground(this.currentColorSet.getForeground());
        }
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        super.setRenderer(aRenderer);
    }

    public void setText(String text) {
        this.getTextField().setText(text);
        this.updateHelpText();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        JTextField tf = this.getTextField();
        if (tf != null) {
            tf.setToolTipText(text);
        }
    }

    public void setUnkownTextInputAllowed(boolean allowUnknownValuesEnabled) {
        this.unkownTextInputAllowed = allowUnknownValuesEnabled;
    }

    protected void sortFound(String search, List<T> found) {
    }

    protected void setListSearchResults(List<T> found, List<T> all) {
    }

    protected boolean textMatchesEntry(String txt) {
        if (txt == null) {
            return false;
        }
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            String text = this.getTextForValue(this.getModel().getElementAt(i));
            if (!this.matches(text, txt)) continue;
            return true;
        }
        return false;
    }

    public void updateColorByContent() {
        String txt = this.getTextField().getText();
        if (this.helptext != null && this.helptext.equals(txt)) {
            this.setColorState(this.helpColorSet);
        } else if (this.textMatchesEntry(txt)) {
            this.setColorState(this.normalColorSet);
        } else {
            this.setColorState(this.badColorSet);
        }
    }

    private void updateHelpText() {
        String txt;
        if (this.getEditor() == null || this.helptext == null) {
            return;
        }
        Document doc = this.getTextField().getDocument();
        try {
            txt = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            txt = "";
        }
        boolean hasHelpText = txt.equals(this.helptext);
        if (StringUtils.isEmpty(txt) || hasHelpText) {
            if (!hasHelpText) {
                this.setText(this.helptext);
            }
            this.updateColorByContent();
        }
    }

    public boolean usePrototype() {
        return true;
    }

    public void setSelectionAfterAutoComplete(JTextField tf, String txt, int pos, List<T> found) {
        tf.setCaretPosition(pos);
        tf.select(txt.length(), tf.getText().length());
    }

    class Editor
    implements ComboBoxEditor,
    FocusListener,
    DocumentListener {
        private final JTextField tf;
        private final MigPanel panel;
        private final JLabel icon;
        private T value;
        private volatile AtomicInteger valueSetter = new AtomicInteger(0);
        private final SearchComboBox searchComboBox;
        private DelayedRunnable delayer = new DelayedRunnable(500L){

            @Override
            public void delayedrun() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Editor.this.valueSetter.get() > 0) {
                            return;
                        }
                        Editor.this.autoComplete(true);
                    }
                });
            }
        };

        public Editor(SearchComboBox searchComboBox) {
            this.searchComboBox = searchComboBox;
            this.tf = SearchComboBox.this.createTextField();
            this.tf.getDocument().addDocumentListener(this);
            this.tf.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    SearchComboBox.this.hidePopup();
                    SearchComboBox.this.repaint();
                }
            });
            this.icon = new JLabel();
            this.panel = new MigPanel("ins 0", "[][grow,fill]", "[grow,fill]"){
                private static final long serialVersionUID = 3558783171884965102L;

                @Override
                public void requestFocus() {
                    Editor.this.tf.requestFocus();
                }

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    Editor.this.tf.setEnabled(enabled);
                }
            };
            this.tf.addFocusListener(this);
            this.panel.add(this.icon);
            this.panel.setOpaque(true);
            this.panel.setBackground(this.tf.getBackground());
            this.tf.setBackground(null);
            SwingUtils.setOpaque(this.tf, false);
            this.panel.add(this.tf);
            SwingUtils.setOpaque(this.panel, false);
            this.tf.setBorder(null);
            this.panel.setEnabled(searchComboBox.isEnabled());
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.tf.addActionListener(l);
        }

        private void auto() {
            if (!SearchComboBox.this.isAutoCompletionEnabled()) {
                return;
            }
            if (this.valueSetter.get() > 0) {
                return;
            }
            this.delayer.resetAndStart();
        }

        protected boolean autoComplete(final boolean showPopup) {
            if (!SearchComboBox.this.isAutoCompletionEnabled()) {
                return false;
            }
            String rawtxt = this.tf.getText();
            if (StringUtils.isEmpty(rawtxt)) {
                return false;
            }
            final String finalRaw = rawtxt;
            boolean caseSensitive = this.searchComboBox.isSearchCaseSensitive();
            final String txt = caseSensitive ? rawtxt : rawtxt.toLowerCase(Locale.ENGLISH);
            Object lValue = this.getItem();
            String valueText = SearchComboBox.this.getTextForValue(lValue);
            if (valueText != null && (valueText.equals(rawtxt) || !caseSensitive && StringUtils.equalsIgnoreCase(valueText, rawtxt))) {
                return true;
            }
            final ArrayList found = new ArrayList();
            final ArrayList all = new ArrayList();
            ComboBoxModel model = SearchComboBox.this.getModel();
            this.searchComboBox.searchAutoComplete(model, txt, found, all);
            SearchComboBox.this.sortFound(txt, found);
            System.out.println("Found: " + found);
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    block10: {
                        SearchComboBox.this.setListSearchResults(found, all);
                        int pos = Editor.this.tf.getCaretPosition();
                        if (found.size() == 0) {
                            SearchComboBox.this.hidePopup();
                            if (SearchComboBox.this.getSelectedIndex() != -1) {
                                SearchComboBox.this.setSelectedIndex(-1);
                                Editor.this.safeSet(finalRaw);
                                Editor.this.tf.setCaretPosition(Math.min(pos, finalRaw.length()));
                            }
                        } else {
                            Editor.this.tf.setForeground(SearchComboBox.this.getForeground());
                            if (!SearchComboBox.this.isSetTextFieldOnlyForSingleMatch() || found.size() <= 1) {
                                Editor.this.setItem(found.get(0));
                                SearchComboBox.this.setSelectedItem(found.get(0));
                                Editor.this.setItem(found.get(0));
                                SearchComboBox.this.setSelectionAfterAutoComplete(Editor.this.tf, txt, pos, found);
                            }
                            if (found.size() > 1 && showPopup) {
                                SearchComboBox.this.setMaximumRowCount(Math.min(SearchComboBox.this.getActualMaximumRowCount(), found.size()));
                                SearchComboBox.this.setPopupVisible(true);
                                try {
                                    Accessible popup = SearchComboBox.this.getUI().getAccessibleChild(SearchComboBox.this, 0);
                                    if (!(popup instanceof Container)) break block10;
                                    Component scrollPane = ((Container)((Object)popup)).getComponent(0);
                                    if (popup instanceof ComboPopup) {
                                        final JList<Object> jlist = ((ComboPopup)((Object)popup)).getList();
                                        final int selectedIndex = SearchComboBox.this.data.indexOf(found.get(0));
                                        if (scrollPane instanceof JScrollPane) {
                                            new EDTHelper<Void>(){

                                                @Override
                                                public Void edtRun() {
                                                    Rectangle cellBounds = jlist.getCellBounds(selectedIndex, selectedIndex + found.size() - 1);
                                                    System.out.println("Scroll to " + cellBounds);
                                                    if (cellBounds != null) {
                                                        jlist.scrollRectToVisible(cellBounds);
                                                    }
                                                    return null;
                                                }
                                            }.start(true);
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    LogV3.log(e);
                                }
                            } else {
                                SearchComboBox.this.hidePopup();
                            }
                        }
                    }
                    SearchComboBox.this.updateColorByContent();
                }
            };
            return found.size() > 0;
        }

        public void caretUpdate(CaretEvent arg0) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.auto();
            SearchComboBox.this.onChanged();
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            if (this.tf.getText().equals(SearchComboBox.this.helptext)) {
                this.safeSet("");
                SearchComboBox.this.updateColorByContent();
            } else {
                this.tf.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (!SearchComboBox.this.isUnkownTextInputAllowed() && !this.autoComplete(false)) {
                String ret = SearchComboBox.this.getTextForValue(this.getItem());
                this.safeSet(ret);
            } else {
                SearchComboBox.this.updateHelpText();
            }
            SearchComboBox.this.updateColorByContent();
        }

        @Override
        public Component getEditorComponent() {
            return this.panel;
        }

        public T getItem() {
            return this.value;
        }

        public JTextField getTf() {
            return this.tf;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.auto();
            SearchComboBox.this.onChanged();
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.tf.removeActionListener(l);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.tf.getSelectionEnd() - this.tf.getSelectionStart() == 0) {
                this.auto();
            }
            SearchComboBox.this.onChanged();
        }

        protected void safeSet(String txt) {
            if (SearchComboBox.this.byPassTxtUpdate) {
                return;
            }
            this.valueSetter.incrementAndGet();
            try {
                this.tf.setText(txt);
            }
            finally {
                this.valueSetter.decrementAndGet();
            }
        }

        @Override
        public void selectAll() {
            this.tf.selectAll();
        }

        @Override
        public void setItem(Object anObject) {
            this.valueSetter.incrementAndGet();
            try {
                this.safeSet(SearchComboBox.this.getTextForValue(anObject));
                this.icon.setIcon(SearchComboBox.this.getIconForValue(anObject));
                this.value = anObject;
                SearchComboBox.this.updateHelpText();
                SearchComboBox.this.updateColorByContent();
            }
            finally {
                this.valueSetter.decrementAndGet();
            }
        }
    }
}

