/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.ExtTransferable;

public class ExtTransferHandler<T>
extends TransferHandler {
    private static final long serialVersionUID = -6250155503485735869L;
    private ExtTable<T> table;

    public ExtTable<T> getTable() {
        return this.table;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        if (dl.isInsertRow()) {
            int dropRow = dl.getRow();
            try {
                return ((ExtTableModel)this.table.getModel()).move((List)support.getTransferable().getTransferData(this.table.getDataFlavor()), dropRow);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDrop()) {
            return support.isDataFlavorSupported(this.table.getDataFlavor());
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    public void setTable(ExtTable<T> table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new ExtTransferable(this.table.getDataFlavor(), ((ExtTableModel)this.table.getModel()).getSelectedObjects());
    }
}

