/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableModel;

public abstract class ExtCompoundColumn<T>
extends ExtColumn<T>
implements CellEditorListener {
    private static final long serialVersionUID = 1L;
    private ExtColumn<T> editor;
    private T editing;
    private ExtColumn<T> renderer;

    public ExtCompoundColumn(String name) {
        this(name, (ExtTableModel<T>)null);
    }

    public ExtCompoundColumn(String name, ExtTableModel<T> table) {
        super(name, table);
        this.setRowSorter(new ExtDefaultRowSorter<T>(){

            @Override
            public int compare(T o1, T o2) {
                String o1s = ExtCompoundColumn.this.getSortString(o1);
                String o2s = ExtCompoundColumn.this.getSortString(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return o1s.compareTo(o2s);
                }
                return o2s.compareTo(o1s);
            }
        });
    }

    @Override
    public void configureEditorComponent(T value, boolean isSelected, int row, int column) {
        this.editor.configureEditorComponent(value, isSelected, row, column);
    }

    @Override
    public void configureRendererComponent(T value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.configureRendererComponent(value, isSelected, hasFocus, row, column);
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.cancelCellEditing();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public boolean onDoubleClick(MouseEvent e, T obj) {
        return this.selectColumn(obj).onDoubleClick(e, obj);
    }

    @Override
    public boolean onRenameClick(MouseEvent e, T obj) {
        return this.selectColumn(obj).onRenameClick(e, obj);
    }

    @Override
    public boolean onSingleClick(MouseEvent e, T obj) {
        return this.selectColumn(obj).onSingleClick(e, obj);
    }

    @Override
    public JComponent getEditorComponent(T value, boolean isSelected, int row, int column) {
        this.editing = value;
        this.editor = this.selectColumn(this.editing);
        if (this.editor.getModel() != this.getModel()) {
            this.editor.setModel(this.getModel());
            this.editor.setTableColumn(this.getTableColumn(), false);
        }
        this.editor.removeCellEditorListener(this);
        this.editor.addCellEditorListener(this);
        return this.editor.getEditorComponent(value, isSelected, row, column);
    }

    @Override
    public JComponent getRendererComponent(T value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer = this.selectColumn(value);
        if (this.renderer.getModel() != this.getModel()) {
            this.renderer.setModel(this.getModel());
            this.renderer.setTableColumn(this.getTableColumn(), false);
        }
        return this.renderer.getRendererComponent(value, isSelected, hasFocus, row, column);
    }

    @Override
    public ExtDefaultRowSorter<T> getRowSorter() {
        return super.getRowSorter();
    }

    public abstract String getSortString(T var1);

    @Override
    protected String getTooltipText(T obj) {
        return super.getTooltipText(obj);
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            ExtTable table = this.getModel().getTable();
            int row = table.getRowIndexByPoint(((MouseEvent)evt).getPoint());
            ExtColumn edit = this.selectColumn(this.getModel().getElementAt(row));
            return ((MouseEvent)evt).getClickCount() >= edit.getClickcount() && edit.getClickcount() > 0;
        }
        return true;
    }

    @Override
    public boolean isEditable(T obj) {
        return this.selectColumn(obj).isEditable(obj);
    }

    @Override
    public boolean isEnabled(T obj) {
        return this.selectColumn(obj).isEnabled(obj);
    }

    @Override
    public boolean isSortable(T obj) {
        return false;
    }

    @Override
    public boolean matchSearch(T object, Pattern pattern) {
        return this.selectColumn(object).matchSearch(object, pattern);
    }

    @Override
    public void resetEditor() {
        this.editor.resetEditor();
    }

    @Override
    public void resetRenderer() {
        this.renderer.resetRenderer();
    }

    public abstract ExtColumn<T> selectColumn(T var1);

    @Override
    public void setValue(Object value, T object) {
        this.editor.setValue(value, object);
    }
}

