/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.regex.Pattern;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.FileList;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.CleanupException;
import org.appwork.updatesys.client.install.DeleteCallback;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.install.RevertException;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.ExtIOException;

public class DeleteFileOrFolderV2
extends InstallerAction {
    public static final String ID = "DELETE_V2";
    protected final String restore;
    protected final String backup;
    public static final String UPD_REMOVED = ".updRemoved";

    public DeleteFileOrFolderV2(String backup, String restore) {
        this.backup = backup;
        this.restore = restore;
    }

    public String getBackup() {
        return this.backup;
    }

    public String getRestore() {
        return this.restore;
    }

    @Override
    public void revert(UpdateClient client) throws RevertException, InterruptedException {
        AbsoluteFile dst;
        AbsoluteFile src;
        try {
            src = this.fromRelPath(client, this.getBackup());
            dst = this.fromRelPath(client, this.getRestore());
        }
        catch (CleanupException e1) {
            throw new RevertException(e1);
        }
        this.logger.info("Revert|Backup:" + src + "|Destination:" + dst);
        if (!src.exists()) {
            throw new RevertException(UpdTrans.I().getErrorCouldNotRestoreFILEAbecauseFILEBdoesNotExist(dst, src));
        }
        try {
            if (dst.exists()) {
                this.delete(dst, client);
                this.logger.info("Deleted|Destination:" + dst);
            }
        }
        catch (ExtIOException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(dst));
        }
        catch (RuntimeException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(dst));
        }
        FileAccessHandler fileSystem = client.getFileSystem();
        try {
            fileSystem.mkdirs(dst.getParentFile());
            fileSystem.moveFile(src, dst, false);
            this.logger.info("Reverted|" + dst);
        }
        catch (ExtIOException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dst));
        }
        catch (RuntimeException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dst));
        }
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String[] getParameters() {
        return new String[]{this.getBackup(), this.getRestore()};
    }

    @Override
    public void cleanup(UpdateClient client, final FileList fileList) throws CleanupException, InterruptedException {
        final AbsoluteFile toDelete = this.fromRelPath(client, this.getBackup());
        try {
            if (toDelete.exists()) {
                DeleteCallback callback = fileList == null ? null : new DeleteCallback(){

                    @Override
                    public void onDeleted(File file) throws ExtIOException, InterruptedException {
                        try {
                            String relPath = toDelete.deriveFromChild(file).getRelative().replaceAll("(\\.\\d+)" + Pattern.quote(DeleteFileOrFolderV2.UPD_REMOVED), "");
                            fileList.removeFile(relPath);
                        }
                        catch (ClosedByInterruptException e) {
                            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                        }
                        catch (IOException e) {
                            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
                        }
                    }
                };
                this.delete(toDelete, client, callback);
            }
        }
        catch (ExtIOException e) {
            throw new CleanupException(e);
        }
        catch (RuntimeException e) {
            throw new CleanupException(e);
        }
    }

    public static DeleteFileOrFolderV2 read(BufferedReader reader) throws IOException {
        return new DeleteFileOrFolderV2(reader.readLine(), reader.readLine());
    }
}

