/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.security.NoSuchAlgorithmException;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.FileList;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.CleanupException;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.install.RevertException;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.ExtIOException;

public class NewFileInstallAction
extends InstallerAction {
    public static final String ID = "NEW";
    protected final String file;

    public NewFileInstallAction(AbsoluteFile file) {
        this(file.getRelative());
    }

    public NewFileInstallAction(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public static InstallerAction read(BufferedReader reader) throws IOException {
        return new NewFileInstallAction(reader.readLine());
    }

    @Override
    public void revert(UpdateClient client) throws RevertException, InterruptedException {
        AbsoluteFile toDelete;
        try {
            toDelete = this.fromRelPath(client, this.getFile());
        }
        catch (CleanupException e1) {
            throw new RevertException(e1);
        }
        this.logger.info("Revert|" + toDelete);
        try {
            if (toDelete.exists()) {
                this.delete(toDelete, client);
                this.logger.info("Deleted|" + toDelete);
            }
            this.logger.info("Reverted|" + toDelete);
        }
        catch (ExtIOException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(toDelete));
        }
        catch (RuntimeException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(toDelete));
        }
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String[] getParameters() {
        return new String[]{this.getFile()};
    }

    @Override
    public void cleanup(UpdateClient client, FileList fileList) throws CleanupException, InterruptedException {
        if (fileList != null) {
            try {
                AbsoluteFile file = this.fromRelPath(client, this.getFile());
                if (file.exists()) {
                    fileList.addFile(file);
                }
            }
            catch (ClosedByInterruptException e) {
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
            }
            catch (IOException e) {
                throw new CleanupException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CleanupException(e);
            }
            catch (RuntimeException e) {
                throw new CleanupException(e);
            }
        }
    }
}

