/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;

public enum PackageInstallationHistory {
    PACKAGE_DOWNLOAD("d"),
    PACKAGE_INTERRUPTED("i"),
    PACKAGE_EXCEPTION("x"),
    PACKAGE_FINISH("f"),
    INSTALLATION_START("S"),
    INSTALLATION_FINISH("F"),
    INSTALLATION_INTERRUPTED("I"),
    INSTALLATION_EXCEPTION("X"),
    UNKNOWN("U"){

        @Override
        public int write(OutputStream os) throws IOException {
            return 0;
        }
    };

    private final byte[] bytes;
    private final String marker;

    private PackageInstallationHistory(String marker) {
        this.marker = marker;
        this.bytes = marker.getBytes();
    }

    public int write(OutputStream os) throws IOException {
        if (this.bytes != null) {
            os.write(this.bytes);
            return this.bytes.length;
        }
        return 0;
    }

    private static PackageInstallationHistory read(LogInterface logger, InputStream is) throws IOException {
        block4: {
            byte[] buf = new byte[1];
            int read = is.read(buf);
            if (read == -1) {
                return null;
            }
            try {
                for (PackageInstallationHistory marker : PackageInstallationHistory.values()) {
                    if (!Arrays.equals(marker.bytes, buf)) continue;
                    return marker;
                }
            }
            catch (IllegalArgumentException e) {
                if (logger == null) break block4;
                logger.log(e);
            }
        }
        return UNKNOWN;
    }

    public static String convert(Map<PackageInstallationHistory, Long> history) {
        if (history != null && history.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<PackageInstallationHistory, Long> entry : history.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(entry.getValue());
                sb.append("-");
                sb.append(entry.getKey().marker);
            }
            return sb.toString();
        }
        return null;
    }

    public static Map<PackageInstallationHistory, Long> read(LogInterface logger, boolean throwException, InputStream is) throws IOException {
        LinkedHashMap<PackageInstallationHistory, Long> ret = new LinkedHashMap<PackageInstallationHistory, Long>();
        try {
            PackageInstallationHistory entry;
            while ((entry = PackageInstallationHistory.read(logger, is)) != null) {
                Long counter = (Long)ret.get((Object)entry);
                if (counter == null) {
                    ret.put(entry, 1L);
                    continue;
                }
                ret.put(entry, counter + 1L);
            }
        }
        catch (IOException e) {
            if (throwException) {
                throw e;
            }
            logger.log(e);
        }
        return ret;
    }

    public static Map<PackageInstallationHistory, Long> convert(String string) {
        LinkedHashMap<PackageInstallationHistory, Long> ret = new LinkedHashMap<PackageInstallationHistory, Long>();
        String[][] matches = new Regex(string, "(\\d+)-([a-z0-9A-Z]+)").getMatches();
        if (matches != null && matches.length > 0) {
            for (String[] match : matches) {
                PackageInstallationHistory entry = UNKNOWN;
                for (PackageInstallationHistory marker : PackageInstallationHistory.values()) {
                    if (!marker.marker.equals(match[1])) continue;
                    entry = marker;
                }
                Long counter = (Long)ret.get((Object)entry);
                if (counter == null) {
                    ret.put(entry, Long.parseLong(match[0]));
                    continue;
                }
                ret.put(entry, counter + Long.parseLong(match[0]));
            }
            if (ret.size() > 0) {
                return ret;
            }
            return null;
        }
        return null;
    }
}

