/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableLink;
import org.appwork.storage.StorableSee;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.StorableValidateRegex;
import org.appwork.storage.StorableValidationLogic;
import org.appwork.updatesys.transport.exchange.setup.ConditionMatcherForSearchAndReplace;
import org.appwork.updatesys.transport.exchange.setup.ExecuteResultAction;
import org.appwork.updatesys.transport.exchange.setup.PreCondition;

@StorableAvailableSince(value="2023-06-23T00:00+0200")
@StorableDoc(value="A regex based search and replace definition. This uses string.replaceAll and thus has the same limitations and options.")
public class SearchAndReplace
implements Storable {
    @StorableDoc(value="Execute only if the conditions resolve to true. The conditions are matched against an instance of ExecuteConditionMatcher. Alternativly, a match against a filepath is possible: {\"\u00a7file\":{\"\u00a7options\":{\"path\":\".%CONNECT\"},\"directory\":true}}")
    @StorableLink(labels={"Matches against ExecuteConditionMatcher", "Supports FileLink"}, hrefs={"https://projects.appwork.org/projects/connect-system-documentation/wiki/ExecuteConditionMatcher", "https://projects.appwork.org/projects/connect-system-documentation/wiki/FileLink"})
    @StorableSee(value={ConditionMatcherForSearchAndReplace.class})
    private PreCondition[] conditions;
    @StorableDoc(value="The action to trigger if the query matches")
    @StorableValidateCondition(value="{\u00a7eq:null}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Define the action to trigger if the condition fails")
    private ExecuteResultAction noMatchAction;
    @StorableDoc(value="A regular expression to witch the text content is to be matched")
    @StorableValidateRegex(message="Must be a valid regular expression and NOT null", nullAllowed=false)
    private String regex;
    @StorableValidateNotNull
    @StorableDoc(value="the string to be substituted for each match. Note that dynamic links might get replaced (@see #resolveDynLinks). Dollar signs may be treated as references to captured subsequences as described above, and backslashes are used to escape literal characters in the replacement string. Use \\ to escape \\ or $ if required.")
    private String replacement;
    @StorableDoc(value="If enabled, dynamic links (.%EXAMPLE) in the replacement will get resolved during replacement.")
    private boolean resolveDynLinks = true;

    public PreCondition[] getConditions() {
        return this.conditions;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean isResolveDynLinks() {
        return this.resolveDynLinks;
    }

    public void setConditions(PreCondition[] conditions) {
        this.conditions = conditions;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public void setResolveDynLinks(boolean resolveDynLinks) {
        this.resolveDynLinks = resolveDynLinks;
    }
}

