/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.lang.reflect.Type;
import java.util.Date;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.transport.exchange.AbstractTrackDataItem;
import org.appwork.updatesys.transport.exchange.CannotRestoreItemException;
import org.appwork.utils.Time;
import org.appwork.utils.UniqueAlltimeID;

public class TrackDataItemLogEntry
implements Storable {
    protected AbstractTrackDataItem _item;
    protected Class<?> _class;
    protected long id = -1L;
    private String json;
    private String className;
    private volatile long doNotSendBefore = -1L;

    public long getId() {
        return this.id;
    }

    public String toString() {
        if (this.doNotSendBefore > Time.systemIndependentCurrentJVMTimeMillis()) {
            return this.className + " " + this.id + "(Do not send before " + new Date(this.doNotSendBefore);
        }
        return this.className + " " + this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public TrackDataItemLogEntry(AbstractTrackDataItem item) {
        this._item = item;
        this.className = item.getClass().getName();
        this.json = JSonStorage.serializeToJson(item);
        this.id = UniqueAlltimeID.next();
    }

    public AbstractTrackDataItem _getItem() throws CannotRestoreItemException {
        if (this._item == null) {
            try {
                final Type cls = this._getClass();
                this._item = JSonStorage.restoreFromString(this.getJson(), new TypeRef<AbstractTrackDataItem>(){

                    @Override
                    public Type getType() {
                        return cls;
                    }
                });
                if (this._item == null) {
                    throw new CannotRestoreItemException();
                }
            }
            catch (CannotRestoreItemException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                throw new CannotRestoreItemException(e);
            }
            catch (RuntimeException e) {
                throw new CannotRestoreItemException(e);
            }
        }
        return this._item;
    }

    public Type _getClass() throws ClassNotFoundException {
        if (this._class == null) {
            this._class = Class.forName(this.getClassName());
        }
        return this._class;
    }

    public TrackDataItemLogEntry() {
    }

    public String getClassName() {
        return this.className;
    }

    public TrackDataItemLogEntry className(String className) {
        this.setClassName(className);
        return this;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getJson() {
        return this.json;
    }

    public TrackDataItemLogEntry json(String json) {
        this.setJson(json);
        return this;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public long getDoNotSendBefore() {
        return this.doNotSendBefore;
    }

    public void setDoNotSendBefore(long lastFailDate) {
        this.doNotSendBefore = lastFailDate;
    }

    public AbstractTrackDataItem _getItemIfExists() {
        return this._item;
    }
}

