/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import org.appwork.moncompare.Condition;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;

@StorableDoc(value="Rules to define an application restart after the update finished")
public class RestartStrategy
implements Storable {
    private String[] cmd;
    private Condition condition;
    private String runInDir;
    private boolean useOldCmd;

    public static void main(String[] args) throws FlexiMapperException {
        System.out.println(FlexiUtils.serializeConfigStorable(new RestartStrategy()));
    }

    @StorableDoc(value="Commandline to start the application. The Commandline is only executed if the application was running before the update installation")
    public String[] getCmd() {
        return this.cmd;
    }

    @StorableDoc(value="https://projects.appwork.org/projects/connect-system-documentation/wiki/Condition\r\nCondition object to restart only if the condition matches the current state. Matcher: {client:<UpdateClient>,lock:<LockObject>}")
    public Condition getCondition() {
        return this.condition;
    }

    @StorableDoc(value="Absolute or relative path (Dynamic Links can be used)")
    public String getRunInDir() {
        return this.runInDir;
    }

    @StorableDoc(value="Use the exact commandline that was used for the process before terminating it. ")
    public boolean isUseOldCmd() {
        return this.useOldCmd;
    }

    public RestartStrategy cmd(String[] cmd) {
        this.setCmd(cmd);
        return this;
    }

    public void setCmd(String[] cmd) {
        this.cmd = cmd;
    }

    public RestartStrategy condition(Condition condition) {
        this.setCondition(condition);
        return this;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public RestartStrategy runInDir(String runInDir) {
        this.setRunInDir(runInDir);
        return this;
    }

    public void setRunInDir(String runInDir) {
        this.runInDir = runInDir;
    }

    public RestartStrategy useOldCmd(boolean useOldCmd) {
        this.setUseOldCmd(useOldCmd);
        return this;
    }

    public void setUseOldCmd(boolean useOldCmd) {
        this.useOldCmd = useOldCmd;
    }
}

