/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.track;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.appwork.storage.Storable;
import org.appwork.updatesys.transport.exchange.track.MayChangeOn;
import org.appwork.updatesys.transport.exchange.track.Property;
import org.appwork.updatesys.transport.exchange.track.WMIProperty;
import org.appwork.utils.CompareUtils;

public class Entity
implements Storable,
Comparable<Entity> {
    private ArrayList<Property> properties = new ArrayList();

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }

    public void put(String name, String str, MayChangeOn ... changeOptions) {
        this.properties.add(new Property(name, changeOptions, str));
    }

    public void sort() {
        Collections.sort(this.properties, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                int ret = CompareUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey()));
                if (ret != 0) {
                    return ret;
                }
                ret = CompareUtils.compare((Comparable)((Object)o1.getValue()), (Comparable)((Object)o2.getValue()));
                return ret;
            }
        });
    }

    @Override
    public int compareTo(Entity o) {
        return this.toIDString(new MayChangeOn[0]).compareTo(o.toIDString(new MayChangeOn[0]));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Property p : this.properties) {
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(p.toString());
        }
        return sb.toString();
    }

    public String toIDString(MayChangeOn ... changeOns) {
        StringBuilder sb = new StringBuilder();
        for (Property p : this.properties) {
            if (p.getOptions() != null) {
                HashSet<MayChangeOn> req = new HashSet<MayChangeOn>(Arrays.asList(p.getOptions()));
                for (MayChangeOn mco : changeOns) {
                    req.remove((Object)mco);
                }
                if (req.size() > 0) continue;
            }
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(p.toIDString(changeOns));
        }
        return sb.toString();
    }

    public void put(WMIProperty s, String value) {
        this.put(s.name(), value, s.getChangeOptions());
    }
}

