/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appwork.builddecision.BuildDecisions;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;

public class Application {
    private static Boolean IS_JARED = null;
    private static String APP_FOLDER = ".appwork";
    private static String ROOT;
    public static final long JAVA16;
    public static final long JAVA17;
    public static final long JAVA18;
    public static final long JAVA19;
    private static Boolean JVM64BIT;
    private static boolean REDIRECTED;
    public static PauseableOutputStream STD_OUT;
    public static PauseableOutputStream ERR_OUT;
    private static boolean DID_INIT;
    private static PrintStream ORG_STD_OUT;
    private static PrintStream ORG_STD_ERR;
    private static PrintStream REDIRECTED_STD_OUT;
    private static PrintStream REDIRECTED_STD_ERR;
    private static final ResourceLookup resourceLookup;
    private static Class<?> MAINCLASS;
    private static Map<String, String> MANIFEST;

    public static PrintStream getSystemStdOut() {
        return ORG_STD_OUT;
    }

    public static PrintStream getSystemStdErr() {
        return ORG_STD_ERR;
    }

    public static PrintStream getWrappedStdOut() {
        return REDIRECTED_STD_OUT;
    }

    public static PrintStream getWrappedStdErr() {
        return REDIRECTED_STD_ERR;
    }

    public static void addStreamCopy(File file, PauseableOutputStream stream) {
        int i = 0;
        File orgFile = file;
        while (true) {
            try {
                if (file.exists()) {
                    throw new FileNotFoundException("Exists");
                }
                stream.addBranch(new BufferedOutputStream(new FileOutputStream(file)));
            }
            catch (FileNotFoundException e1) {
                ++i;
                e1.printStackTrace();
                String extension = Files.getExtension(orgFile.getName());
                if (extension != null) {
                    file = new File(orgFile.getParentFile(), orgFile.getName().substring(0, orgFile.getName().length() - extension.length() - 1) + "." + i + "." + extension);
                    continue;
                }
                file = new File(orgFile.getParentFile(), orgFile.getName() + "." + i);
                continue;
            }
            break;
        }
    }

    @Deprecated
    public static void addUrlToClassPath(URL url, ClassLoader cl) throws IOException {
        try {
            if (url == null) {
                throw new IllegalArgumentException("file==null");
            }
            Method method = null;
            try {
                method = cl.getClass().getMethod("addURL", URL.class);
            }
            catch (NoSuchMethodException e) {
                method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            }
            method.setAccessible(true);
            method.invoke((Object)cl, url);
        }
        catch (Throwable t) {
            throw new IOException("Failed to add URL to system classloader: URL:" + url + "ClassLoader:" + cl, t);
        }
    }

    public static String getApplication() {
        return APP_FOLDER;
    }

    public static File getApplicationRoot() {
        return Application.getRootByClass(Application.class, null);
    }

    public static String getHome() {
        return Application.getRoot(Application.class);
    }

    public static URL getHomeURL() {
        try {
            return new File(Application.getHome()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new WTFException(e);
        }
    }

    public static File getJarFile(Class<?> clazz) {
        String name = clazz.getName().replaceAll("\\.", "/") + ".class";
        URL url = Application.getRessourceURL(name);
        String prot = url.getProtocol();
        String path = url.getPath();
        if (!"jar".equals(prot)) {
            throw new WTFException("Works in Jared mode only");
        }
        int index = path.indexOf(".jar!");
        if (index < 0) {
            throw new WTFException("Works in Jared mode only");
        }
        try {
            return new File(new URL(path.substring(0, index + 4)).toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static long getJavaVersion() {
        return JVMVersion.get();
    }

    public static String getJVMVersion() {
        return JVMVersion.getJVMVersion();
    }

    public static long parseJavaVersionString(String version) {
        return JVMVersion.parseJavaVersionString(version);
    }

    public static String getPackagePath(Class<?> class1) {
        return class1.getPackage().getName().replace('.', '/') + "/";
    }

    private static ResourceLookup initResourceLookup() {
        String resourceLookupClass = System.getProperty("org.appwork.utils.Application.ResourceLookup", null);
        if (resourceLookupClass != null) {
            try {
                Class<?> loadClass = Class.forName(resourceLookupClass);
                ResourceLookup ret = (ResourceLookup)loadClass.newInstance();
                return ret;
            }
            catch (ClassNotFoundException e) {
                throw new WTFException("ResourceLookupClass:" + resourceLookupClass, e);
            }
            catch (InstantiationException e) {
                throw new WTFException("ResourceLookupClass:" + resourceLookupClass, e);
            }
            catch (IllegalAccessException e) {
                throw new WTFException("ResourceLookupClass:" + resourceLookupClass, e);
            }
        }
        return null;
    }

    public static File getResource(String relative) {
        Application.warnInit();
        ResourceLookup resourceLookup = Application.resourceLookup;
        File ret = resourceLookup != null ? resourceLookup.getResource(relative) : Application.getHomeResource(relative);
        return ret;
    }

    public static File getHomeResource(String relative) {
        return new File(Application.getHome(), relative);
    }

    public static void warnInit() {
        if (!Application.isFrameWorkInitDone()) {
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            new Exception(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application").printStackTrace();
        }
    }

    public static URL getRessourceURL(String relative) {
        return Application.getRessourceURL(relative, true);
    }

    public static URL getRessourceURL(String relative, boolean preferClasspath) {
        ResourceLookup resourceLookup = Application.resourceLookup;
        URL ret = resourceLookup != null ? resourceLookup.getRessourceURL(relative, preferClasspath) : Application.getHomeRessourceURL(relative, preferClasspath);
        return ret;
    }

    public static URL getHomeRessourceURL(String relative, boolean preferClasspath) {
        try {
            if (relative == null) {
                return null;
            }
            if (relative.startsWith("/") || relative.startsWith("\\")) {
                throw new WTFException("getRessourceURL only works with relative paths.");
            }
            if (preferClasspath) {
                URL res = Application.class.getClassLoader().getResource(relative);
                if (res != null) {
                    return res;
                }
                File file = Application.getHomeResource(relative);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            } else {
                File file = Application.getHomeResource(relative);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
                URL res = Application.class.getClassLoader().getResource(relative);
                if (res != null) {
                    return res;
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getJarName(Class<?> clazz) {
        String name;
        String url;
        int index;
        if (clazz == null) {
            clazz = Application.class;
        }
        if ((index = (url = Application.getRessourceURL(name = clazz.getName().replaceAll("\\.", "/") + ".class").toString()).indexOf(".jar!")) < 0) {
            throw new IllegalStateException("No JarName Found");
        }
        try {
            return new File(new URL(url.substring(4, index + 4)).toURI()).getName();
        }
        catch (Exception exception) {
            throw new IllegalStateException("No JarName Found");
        }
    }

    public static String getRoot(Class<?> rootOfClazz) {
        if (rootOfClazz == null) {
            throw new IllegalArgumentException("rootOfClazz is null");
        }
        if (ROOT != null) {
            return ROOT;
        }
        String system = System.getProperty("ROOT");
        if (system != null) {
            ROOT = system;
            return system;
        }
        String key = "awuhome" + APP_FOLDER;
        String sysProp = System.getProperty(key);
        if (sysProp != null) {
            ROOT = sysProp;
            return sysProp;
        }
        if (Application.isJared(rootOfClazz)) {
            URL loc = rootOfClazz.getProtectionDomain().getCodeSource().getLocation();
            File appRoot = null;
            try {
                appRoot = Application.urlToFile(loc);
                ROOT = appRoot.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                ROOT = System.getProperty("user.home") + System.getProperty("file.separator") + APP_FOLDER + System.getProperty("file.separator");
            }
        } else {
            ROOT = System.getProperty("user.home") + System.getProperty("file.separator") + APP_FOLDER;
        }
        return ROOT;
    }

    @Deprecated
    public static File urlToFile(URL loc) throws URISyntaxException {
        if (loc == null) {
            throw new IllegalArgumentException("loc is null");
        }
        String path = loc.getPath();
        File appRoot = null;
        try {
            appRoot = new File(URLDecoder.decode(path, "UTF-8"));
            if (!appRoot.exists()) {
                appRoot = null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (appRoot == null && !(appRoot = new File(path)).exists()) {
            appRoot = null;
        }
        if (appRoot == null && !(appRoot = new File(loc.toURI())).exists()) {
            appRoot = null;
        }
        if (appRoot == null) {
            throw new URISyntaxException(loc + "", "Bad URI");
        }
        if (appRoot.isFile()) {
            appRoot = appRoot.getParentFile();
        }
        return appRoot;
    }

    public static File getRootByClass(Class<?> class1, String subPaths) {
        if (class1 == null) {
            throw new IllegalArgumentException("class is null");
        }
        URL loc = class1.getProtectionDomain().getCodeSource().getLocation();
        try {
            File appRoot = new File(loc.toURI());
            if (appRoot.isFile()) {
                appRoot = appRoot.getParentFile();
            }
            if (subPaths != null) {
                return new File(appRoot, subPaths);
            }
            return appRoot;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static URL getRootUrlByClass(Class<?> class1, String subPaths) {
        try {
            return Application.getRootByClass(class1, subPaths).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getTemp() {
        File ret = Application.getResource("tmp");
        if (!ret.exists()) {
            ret.mkdirs();
        }
        return ret;
    }

    public static File getTempFile(String prefix, String suffix) throws IOException {
        File tmp;
        String tmpDirProperty = System.getProperty("java.io.tmpdir");
        String random = Long.toString(UniqueAlltimeID.next());
        if (StringUtils.isEmpty(tmpDirProperty) || tmpDirProperty.contains("~") || !new File(tmpDirProperty).isDirectory()) {
            tmp = Application.getTemp();
            tmp.mkdirs();
        } else {
            tmp = null;
        }
        String tmpPrefix = prefix + random;
        try {
            return File.createTempFile(tmpPrefix, suffix, tmp);
        }
        catch (IOException e) {
            throw new IOException("failed to create tmpFile!prefix:" + tmpPrefix + "|suffix:" + suffix + "|tmp:" + tmp, e);
        }
    }

    public static File getTempResource(String cache) {
        return new File(Application.getTemp(), cache);
    }

    public static boolean is64BitJvm() {
        if (JVM64BIT != null) {
            return JVM64BIT;
        }
        String archDataModel = System.getProperty("sun.arch.data.model");
        try {
            if (archDataModel != null) {
                if (Integer.parseInt(archDataModel) == 64) {
                    JVM64BIT = true;
                    return true;
                }
                JVM64BIT = false;
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean is64BitJVM = CrossSystem.is64BitArch();
        JVM64BIT = is64BitJVM;
        return is64BitJVM;
    }

    public static boolean isJared(Class<?> rootOfClazz) {
        if (IS_JARED != null) {
            return IS_JARED == Boolean.TRUE;
        }
        if (rootOfClazz == null) {
            rootOfClazz = Application.class;
        }
        String name = rootOfClazz.getName().replaceAll("\\.", "/") + ".class";
        ClassLoader cll = Application.class.getClassLoader();
        if (cll == null) {
            IS_JARED = Boolean.TRUE;
            return true;
        }
        URL caller = cll.getResource(name);
        if (caller == null) {
            IS_JARED = false;
            return false;
        }
        boolean ret = caller.toString().matches("jar\\:.*\\.(jar|exe)\\!.*");
        IS_JARED = ret;
        return ret;
    }

    public static void printSystemProperties(LogInterface logger) {
        Application.printSystemProperties(logger, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void printSystemProperties(LogInterface logger, Collection<String> blackList) {
        Properties properties = System.getProperties();
        Enumeration<Object> propertiesKey = properties.keys();
        StringBuilder sb = new StringBuilder();
        try {
            List<String> lst = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String string : lst) {
                if (blackList != null && blackList.contains("jvm_" + string)) continue;
                sb.append("JVM: ").append(string);
                logger.info(sb.toString());
                sb.setLength(0);
            }
        }
        catch (Throwable e) {
            logger.log(e);
        }
        while (propertiesKey.hasMoreElements()) {
            String key = String.valueOf(propertiesKey.nextElement());
            if (blackList != null && blackList.contains("prop_" + (String)key)) continue;
            sb.append("SysProp: ").append(key).append(": ").append(properties.get(key));
            logger.info(sb.toString());
            sb.setLength(0);
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            String string = (String)entry.getKey();
            if (blackList != null && blackList.contains("env_" + string)) continue;
            sb.append("SysEnv: ").append(string).append(": ").append((String)entry.getValue());
            logger.info(sb.toString());
            sb.setLength(0);
        }
        URL url = Application.getRessourceURL("version.nfo");
        if (url != null) {
            try {
                logger.info(url + ":\r\n" + IO.readURLToString(url));
            }
            catch (IOException iOException) {
                logger.log(iOException);
            }
        }
        if ((url = Application.getRessourceURL("build.json")) != null) {
            try {
                logger.info(url + ":\r\n" + IO.readURLToString(url));
            }
            catch (IOException iOException) {
                logger.log(iOException);
            }
        }
        if ((url = Application.getRessourceURL("version.txt")) != null) {
            try {
                logger.info(url + ":\r\n" + IO.readURLToString(url));
            }
            catch (IOException iOException) {
                logger.log(iOException);
            }
        }
        try {
            Map<String, String> map = Application.getManifest();
            if (map != null && map.size() > 0) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    logger.info(entry.getKey() + ": " + entry.getValue());
                }
            }
            try {
                File file;
                String string = Application.getJarName(Application.class);
                if (string != null && (file = Application.getResource(string)).isFile()) {
                    logger.info(file + "- lastModified: " + DateFormat.getDateTimeInstance(3, 2).format(new Date(file.lastModified())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = System.getProperty("exe4j.moduleName");
            if (StringUtils.isNotEmpty(string)) {
                void var8_32;
                File file = new File(string);
                if (!file.isAbsolute() || !file.isFile() || file.length() == 0L) {
                    File file2 = Application.getResource(string);
                }
                if (var8_32.isFile()) {
                    logger.info(var8_32 + "- lastModified: " + DateFormat.getDateTimeInstance(3, 2).format(new Date(var8_32.lastModified())));
                }
            }
        }
        catch (Throwable throwable) {
            logger.log(throwable);
        }
    }

    private static String getCharSet(PrintStream ps) {
        try {
            String charSet;
            Field field = ReflectionUtils.getField(ps.getClass(), "charOut", (Object)ps, Writer.class);
            Writer writer = (Writer)field.get(ps);
            if (writer instanceof OutputStreamWriter && !StringUtils.isEmpty(charSet = ((OutputStreamWriter)writer).getEncoding())) {
                return Charset.forName(charSet).name();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Charset.defaultCharset().name();
    }

    public static void redirectOutputStreams() {
        if (REDIRECTED) {
            return;
        }
        ORG_STD_OUT = System.out;
        ORG_STD_ERR = System.err;
        try {
            if (System.getProperty("sun.stdout.encoding") == null && Charset.defaultCharset() == Charset.forName("cp1252")) {
                try {
                    STD_OUT = new PauseableOutputStream(new FileOutputStream(FileDescriptor.out));
                    System.setOut(new PrintStream((OutputStream)STD_OUT, true, "CP850"));
                    ERR_OUT = new PauseableOutputStream(new FileOutputStream(FileDescriptor.err));
                    System.setErr(new PrintStream((OutputStream)ERR_OUT, true, "CP850"));
                }
                catch (UnsupportedEncodingException e) {
                    STD_OUT = new PauseableOutputStream(System.out);
                    System.setOut(new PrintStream(STD_OUT));
                    ERR_OUT = new PauseableOutputStream(System.err);
                    System.setErr(new PrintStream(ERR_OUT));
                    e.printStackTrace();
                }
            } else {
                PrintStream stdOut = System.out;
                PrintStream stdErr = System.err;
                try {
                    STD_OUT = new PauseableOutputStream(stdOut);
                    System.setOut(new PrintStream((OutputStream)STD_OUT, true, System.getProperty("sun.stdout.encoding", Application.getCharSet(stdOut))));
                    ERR_OUT = new PauseableOutputStream(stdErr);
                    System.setErr(new PrintStream((OutputStream)ERR_OUT, true, System.getProperty("sun.stderr.encoding", Application.getCharSet(stdErr))));
                }
                catch (UnsupportedEncodingException e) {
                    STD_OUT = new PauseableOutputStream(stdOut);
                    System.setOut(new PrintStream(STD_OUT));
                    ERR_OUT = new PauseableOutputStream(stdErr);
                    System.setErr(new PrintStream(ERR_OUT));
                    e.printStackTrace();
                }
            }
        }
        finally {
            REDIRECTED_STD_OUT = System.out;
            REDIRECTED_STD_ERR = System.err;
            REDIRECTED = true;
        }
    }

    public static Class<?> getMainClass() {
        return MAINCLASS;
    }

    public static synchronized void setApplication(String newAppFolder) {
        ROOT = null;
        APP_FOLDER = newAppFolder;
        if (MAINCLASS == null) {
            MAINCLASS = Application.findMainClass();
        }
        ROOT = Application.getRoot(Application.class);
        Application.ensureFrameWorkInit();
    }

    private static Class<?> findMainClass() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            return null;
        }
        StackTraceElement first = stackTrace[stackTrace.length - 1];
        String className = first.getClassName();
        try {
            Class<?> clz = Class.forName(className);
            clz.getMethod("main", String[].class);
            return clz;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static File generateNumberedTempResource(String string) {
        return Application.generateNumbered(Application.getTempResource(string));
    }

    public static File generateNumberedResource(String string) {
        return Application.generateNumbered(Application.getResource(string));
    }

    private static File generateNumbered(File orgFile) {
        int i = 0;
        String extension = Files.getExtension(orgFile.getName());
        File file = null;
        while (file == null || file.exists()) {
            ++i;
            if (extension != null) {
                file = new File(orgFile.getParentFile(), orgFile.getName().substring(0, orgFile.getName().length() - extension.length() - 1) + "." + i + "." + extension);
                continue;
            }
            file = new File(orgFile.getParentFile(), orgFile.getName() + "." + i);
        }
        return file;
    }

    private static synchronized void ensureFrameWorkInit() {
        if (DID_INIT) {
            return;
        }
        DID_INIT = true;
        BuildDecisions.status(LogV3.defaultLogger());
        if (BuildDecisions.isEnabled() && !Application.isJared(null)) {
            if (System.getProperty("BUILD_DECISIONS_DIRECT") != null || BuildDecisions.isEmpty()) {
                BuildDecisions.validate();
            } else {
                new Thread("BuildDecisions Check"){
                    {
                        this.setDaemon(true);
                    }

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            LogV3.log(e);
                        }
                        BuildDecisions.validate();
                    }
                }.start();
            }
        }
        ShutdownController.getInstance();
    }

    public static boolean isFrameWorkInitDone() {
        return DID_INIT;
    }

    public static long getBuildTimeStamp() {
        try {
            String value = Application.getManifestEntry("build-timestamp");
            if (value == null) {
                return -1L;
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static String getBuildHotFix() {
        return Application.getManifestEntry("hotfix-base");
    }

    public static String getManifestEntry(String key) {
        Map<String, String> mf = Application.getManifest();
        if (mf == null) {
            return null;
        }
        String ts = mf.get(key.toLowerCase(Locale.ROOT));
        if (ts == null) {
            return null;
        }
        return ts;
    }

    public static int getBuildID() {
        try {
            String value = Application.getManifestEntry("build-id");
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static Map<String, String> getManifest() {
        File[] files;
        Map<String, String> ret = MANIFEST;
        if (ret != null) {
            return ret;
        }
        ArrayList<File> jars = new ArrayList<File>();
        try {
            File applicationJar = Application.getJarFile(Application.class);
            if (applicationJar.isFile()) {
                jars.add(applicationJar);
            }
        }
        catch (Exception applicationJar) {
            // empty catch block
        }
        if (jars.size() == 0 && (files = Application.getResource("").listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                jars.add(file);
            }
        }
        MANIFEST = ret = Application.readManifests(jars);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> readManifests(List<File> jars) {
        HashMap<String, String> manifestMap = new HashMap<String, String>();
        for (File jar : jars) {
            try {
                ZipFile zip = new ZipFile(jar);
                try {
                    ZipEntry manifestEntry = zip.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry == null) continue;
                    String manifest = IO.readStreamToString(zip.getInputStream(manifestEntry), -1, true);
                    manifestMap.clear();
                    for (String line : manifest.split("[\r\n]+")) {
                        int index;
                        if (!StringUtils.isNotEmpty(line) || (index = line.indexOf(":")) <= 0) continue;
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim();
                        manifestMap.put(key.toLowerCase(Locale.ROOT), value);
                    }
                    if (StringUtils.equals("AppWork GmbH", manifestMap.get("created-by"))) break;
                }
                finally {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception exception) {}
        }
        return manifestMap;
    }

    public static File getTempUniqueResource(String postFix) {
        File file = null;
        while (file == null || file.exists()) {
            file = Application.getResource("tmp/path_" + UniqueAlltimeID.next() + postFix);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getThreadDump() {
        StringBuilder sb;
        block31: {
            sb = new StringBuilder();
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            if (threadMXBean == null) break block31;
            Boolean originalContentionMonitoring = threadMXBean.isThreadContentionMonitoringSupported() ? Boolean.valueOf(threadMXBean.isThreadContentionMonitoringEnabled()) : null;
            try {
                if (originalContentionMonitoring != null) {
                    threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
                ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
                sb.append("=== Enhanced Thread Dump ===\r\n\r\n");
                for (ThreadInfo threadInfo : threadInfos) {
                    LockInfo[] lockedSynchronizers;
                    MonitorInfo[] lockedMonitors;
                    LockInfo lockInfo;
                    sb.append("Thread Name: ").append(threadInfo.getThreadName()).append("\r\n");
                    sb.append("Thread ID: ").append(threadInfo.getThreadId()).append("\r\n");
                    sb.append("Thread State: ").append((Object)threadInfo.getThreadState()).append("\r\n");
                    if (JavaVersion.getVersion().isMinimum(JavaVersion.JVM_9_0)) {
                        try {
                            sb.append("Thread Daemon: ").append(ReflectionUtils.invoke(ThreadInfo.class, "isDaemon", (Object)threadInfo, Boolean.TYPE, new Object[0])).append("\r\n");
                            sb.append("Thread Priority: ").append(ReflectionUtils.invoke(ThreadInfo.class, "getPriority", (Object)threadInfo, Integer.TYPE, new Object[0])).append("\r\n");
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    if (originalContentionMonitoring != null && threadMXBean.isThreadContentionMonitoringEnabled()) {
                        long waitedTime;
                        long blockedTime = threadInfo.getBlockedTime();
                        if (blockedTime > 0L) {
                            sb.append("Blocked Time (ms/count): ").append(blockedTime).append("/").append(threadInfo.getBlockedCount()).append("\r\n");
                        }
                        if ((waitedTime = threadInfo.getWaitedTime()) > 0L) {
                            sb.append("Waited Time (ms/count): ").append(waitedTime).append("/").append(threadInfo.getWaitedCount()).append("\r\n");
                        }
                    }
                    if ((lockInfo = threadInfo.getLockInfo()) != null && threadInfo.getLockOwnerId() != -1L) {
                        sb.append("  Waiting for Lock: ").append(lockInfo).append("\r\n");
                        sb.append("  Owned by Thread: ").append(threadInfo.getLockOwnerName()).append(" (ID: ").append(threadInfo.getLockOwnerId()).append(")\r\n");
                    }
                    if ((lockedMonitors = threadInfo.getLockedMonitors()).length > 0) {
                        sb.append("  Locked Monitors:\r\n");
                        for (MonitorInfo monitor : lockedMonitors) {
                            sb.append("    - ").append(monitor).append(" at ").append(monitor.getLockedStackFrame()).append("\r\n");
                        }
                    }
                    if ((lockedSynchronizers = threadInfo.getLockedSynchronizers()).length > 0) {
                        sb.append("  Locked Synchronizers:\r\n");
                        for (LockInfo synchronizer : lockedSynchronizers) {
                            sb.append("    - ").append(synchronizer).append("\r\n");
                        }
                    }
                    sb.append("  Stack Trace:\r\n");
                    for (StackTraceElement element : threadInfo.getStackTrace()) {
                        sb.append("    at ").append(element).append("\r\n");
                    }
                    sb.append("\r\n");
                }
                long[] deadlockedThreads = null;
                try {
                    if (threadMXBean.isSynchronizerUsageSupported()) {
                        deadlockedThreads = threadMXBean.findDeadlockedThreads();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (deadlockedThreads != null) {
                    ThreadInfo[] deadlockedThreadInfos;
                    sb.append("=== Deadlock Detected ===\r\n\r\n");
                    for (ThreadInfo deadlockThreadInfo : deadlockedThreadInfos = threadMXBean.getThreadInfo(deadlockedThreads)) {
                        sb.append("Thread Name: ").append(deadlockThreadInfo.getThreadName()).append("\r\n");
                        sb.append("Thread ID: ").append(deadlockThreadInfo.getThreadId()).append("\r\n");
                        sb.append("Thread State: ").append((Object)deadlockThreadInfo.getThreadState()).append("\r\n");
                        LockInfo lockInfo = deadlockThreadInfo.getLockInfo();
                        if (lockInfo != null) {
                            sb.append("  Waiting for Lock: ").append(lockInfo).append("\r\n");
                            sb.append("  Owned by Thread: ").append(deadlockThreadInfo.getLockOwnerName()).append(" (ID: ").append(deadlockThreadInfo.getLockOwnerId()).append(")\r\n");
                        }
                        sb.append("  Stack Trace:\r\n");
                        for (StackTraceElement element : deadlockThreadInfo.getStackTrace()) {
                            sb.append("    at ").append(element).append("\r\n");
                        }
                        sb.append("\r\n");
                    }
                } else {
                    sb.append("No deadlocks detected.\r\n");
                }
                String string = sb.toString();
                if (originalContentionMonitoring != null) {
                    threadMXBean.setThreadContentionMonitoringEnabled(originalContentionMonitoring);
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (originalContentionMonitoring != null) {
                        threadMXBean.setThreadContentionMonitoringEnabled(originalContentionMonitoring);
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    sb.append("\r\nException during ThreadDump: \r\n" + Exceptions.getStackTrace(e));
                }
            }
        }
        sb.append("=== Basic Thread Dump ===\r\n\r\n");
        for (Map.Entry<Thread, StackTraceElement[]> next : Thread.getAllStackTraces().entrySet()) {
            Thread thread = next.getKey();
            sb.append("Thread Name: ").append(thread.getName()).append("\r\n");
            sb.append("Thread ID: ").append(thread.getId()).append("\r\n");
            sb.append("Thread State: ").append((Object)thread.getState()).append("\r\n");
            sb.append("Thread Daemon: ").append(thread.isDaemon()).append("\r\n");
            sb.append("Thread Priority: ").append(thread.getPriority()).append("\r\n");
            sb.append("  Stack Trace:\r\n");
            for (StackTraceElement stackTraceElement : next.getValue()) {
                sb.append("\tat " + stackTraceElement + "\r\n");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    static {
        JAVA16 = JVMVersion.JAVA16;
        JAVA17 = JVMVersion.JAVA17;
        JAVA18 = JVMVersion.JAVA18;
        JAVA19 = JVMVersion.JAVA19;
        JVM64BIT = null;
        REDIRECTED = false;
        DID_INIT = false;
        if (System.getProperty("NO_SYSOUT_REDIRECT") == null) {
            Application.redirectOutputStreams();
        }
        System.setProperty("com.sun.jndi.rmi.object.trustURLCodebase", "false");
        System.setProperty("com.sun.jndi.ldap.object.trustURLCodebase", "false");
        System.setProperty("com.sun.jndi.cosnaming.object.trustURLCodebase", "false");
        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
        resourceLookup = Application.initResourceLookup();
        MAINCLASS = null;
    }

    public static class PauseableOutputStream
    extends OutputStream {
        private final OutputStream _out;
        private final AtomicReference<ByteArrayOutputStream> buffer = new AtomicReference();
        private final CopyOnWriteArrayList<OutputStream> branches = new CopyOnWriteArrayList();

        public PauseableOutputStream(OutputStream out) {
            this._out = out;
        }

        @Override
        public void write(int paramInt) throws IOException {
            ByteArrayOutputStream buffer;
            if (this.branches.size() > 0) {
                for (OutputStream os : this.branches) {
                    try {
                        os.write(paramInt);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((buffer = this.buffer.get()) != null) {
                buffer.write(paramInt);
            } else {
                this._out.write(paramInt);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            ByteArrayOutputStream buffer;
            if (this.branches.size() > 0) {
                for (OutputStream os : this.branches) {
                    try {
                        os.write(b);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((buffer = this.buffer.get()) != null) {
                buffer.write(b);
            } else {
                this._out.write(b);
            }
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            ByteArrayOutputStream buffer;
            if (this.branches.size() > 0) {
                for (OutputStream os : this.branches) {
                    try {
                        os.write(buff, off, len);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((buffer = this.buffer.get()) != null) {
                buffer.write(buff, off, len);
            } else {
                this._out.write(buff, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            for (OutputStream os : this.branches) {
                try {
                    os.flush();
                }
                catch (Throwable throwable) {}
            }
            ByteArrayOutputStream buffer = this.buffer.get();
            if (buffer != null) {
                buffer.flush();
            } else {
                this._out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                for (OutputStream os : this.branches) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {}
                }
                ByteArrayOutputStream buffer = this.buffer.get();
                if (buffer != null) {
                    buffer.close();
                    this.setBufferEnabled(false);
                }
            }
            finally {
                this._out.close();
            }
        }

        public boolean enableBuffer() throws IOException {
            return this.setBufferEnabled(true);
        }

        public boolean disableBuffer(boolean dropBufferedData) throws IOException {
            if (dropBufferedData) {
                this.buffer.set(null);
            }
            return this.setBufferEnabled(false);
        }

        public boolean setBufferEnabled(boolean b) throws IOException {
            if (b) {
                return !this.buffer.compareAndSet(null, new ByteArrayOutputStream());
            }
            ByteArrayOutputStream buffer = this.buffer.getAndSet(null);
            if (buffer != null) {
                buffer.writeTo(this._out);
                return true;
            }
            return false;
        }

        public boolean addBranch(OutputStream os) {
            return os != null && this.branches.addIfAbsent(os);
        }

        public boolean removeBranch(OutputStream os) {
            return os != null && this.branches.remove(os);
        }

        public void setBranches(List<OutputStream> branches) {
            if (branches == null || branches.size() == 0) {
                this.branches.clear();
            } else {
                for (OutputStream os : branches) {
                    this.addBranch(os);
                }
                this.branches.retainAll(branches);
            }
        }

        public void setBranch(OutputStream outputStream) {
            if (outputStream == null) {
                this.branches.clear();
            } else {
                this.setBranches(Arrays.asList(outputStream));
            }
        }
    }

    public static interface ResourceLookup {
        public File getResource(String var1);

        public URL getRessourceURL(String var1, boolean var2);
    }
}

