/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.HashMap;
import java.util.Map;
import org.appwork.storage.config.annotations.IntegerInterface;

public class CounterMap<KeyType>
extends HashMap<KeyType, WrappedInteger> {
    public WrappedInteger getEnsureValue(KeyType key) {
        WrappedInteger ret = (WrappedInteger)super.get(key);
        if (ret == null) {
            ret = new WrappedInteger();
            super.put(key, ret);
        }
        return ret;
    }

    public int increment(KeyType key) {
        return this.add(key, 1);
    }

    public int decrement(KeyType key) {
        return this.add(key, -1);
    }

    public int add(KeyType key, int add) {
        WrappedInteger wrapper = this.getEnsureValue(key);
        return wrapper.increment(add);
    }

    public int getInt(KeyType key) {
        WrappedInteger ret = (WrappedInteger)this.get(key);
        if (ret != null) {
            return ret.getInt();
        }
        return 0;
    }

    public HashMap<KeyType, Integer> toMap() {
        HashMap ret = new HashMap();
        for (Map.Entry es : this.entrySet()) {
            ret.put(es.getKey(), ((WrappedInteger)es.getValue()).getInt());
        }
        return ret;
    }

    public static class WrappedInteger
    implements IntegerInterface {
        private int i = 0;

        @Override
        public int getInt() {
            return this.i;
        }

        public int increment(int add) {
            this.i += add;
            return this.i;
        }

        public String toString() {
            return String.valueOf(this.i);
        }
    }
}

