/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class GetterSetter {
    private Method setter;
    private String key;
    private Method getter;
    private Field field;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public GetterSetter(String key) {
        this.key = key;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean hasField() {
        return this.field != null;
    }

    public boolean hasGetter() {
        return this.getter != null;
    }

    public boolean hasSetter() {
        return this.setter != null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> class1) {
        return this.getAnnotation(class1) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> class1) {
        T ann;
        if (this.getter != null && (ann = this.getter.getAnnotation(class1)) != null) {
            return ann;
        }
        if (this.setter != null && (ann = this.setter.getAnnotation(class1)) != null) {
            return ann;
        }
        if (this.field != null && (ann = this.field.getAnnotation(class1)) != null) {
            return ann;
        }
        return null;
    }

    public Type getType() {
        if (this.getter != null) {
            return this.getter.getGenericReturnType();
        }
        if (this.setter != null) {
            return this.setter.getGenericParameterTypes()[0];
        }
        if (this.field != null) {
            return this.field.getGenericType();
        }
        return null;
    }

    public void setAccessible(boolean b) {
        if (this.getter != null) {
            this.getter.setAccessible(b);
        }
        if (this.setter != null) {
            this.setter.setAccessible(b);
        }
        if (this.field != null) {
            this.field.setAccessible(b);
        }
    }

    public Object get(Object actionClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.getter != null) {
            this.getter.setAccessible(true);
            return this.getter.invoke(actionClass, new Object[0]);
        }
        if (this.field != null) {
            this.field.setAccessible(true);
            return this.field.get(actionClass);
        }
        throw new NullPointerException("Field and getter not available");
    }

    public void set(Object action, Object v) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.setter != null) {
            this.setter.setAccessible(true);
            this.setter.invoke(action, v);
        } else if (this.field != null) {
            this.field.setAccessible(true);
            this.field.set(action, v);
        } else {
            throw new NullPointerException("Field and setter not available");
        }
    }
}

