/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.duration;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.flexijson.mapper.typemapper.DateMapper;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.MathUtils;
import org.appwork.utils.duration.ContextMissingException;
import org.appwork.utils.duration.IllegalTargetUnitsException;
import org.appwork.utils.duration.InvalidTimeSpanException;
import org.appwork.utils.duration.TimeSpanWithContext;
import org.appwork.utils.duration.Unit;

@StorableDoc(value="A timespan instance defines an interval or a timeperiod. Available Units: [+-]*Y(ears)*M(onths)*W\u00b4(eeks)*D(ays)*h(ours)*m(inutes)*s(seconds)*S(milliSeconds)*\u00b5(microseconds)*n(anoseconds)!<CONTEXT>\r\n.Each unit is optional, but there has to be at least one. The context is optional, and may either be a number (e.g. 1Y!365.25) that represents the amount of days/year, or a fixed date (e.g. 1Y!2022-01-01T00:00:00+0100 ")
public class TimeSpan
implements Comparable<TimeSpan> {
    private static final double AVERAGE_DAYS_PER_YEAR = 365.2425;
    private static final BigDecimal INT_MAX = new BigDecimal(Integer.MAX_VALUE);
    private static volatile HashMap<Object, WeakReference<TimeSpan>> CACHE = new HashMap();
    public static final TimeSpanWithContext HOURS_1 = (TimeSpanWithContext)TimeSpan.parseWithoutException("1h!365.2425");
    public static final TimeSpanWithContext HOURS_12 = (TimeSpanWithContext)TimeSpan.parseWithoutException("12h!365.2425");
    public static final TimeSpanWithContext DAYS_1 = (TimeSpanWithContext)TimeSpan.parseWithoutException("1D!365.2425");
    public static final TimeSpanWithContext WEEKS_1 = (TimeSpanWithContext)TimeSpan.parseWithoutException("1W!365.2425");
    public static final TimeSpanWithContext MINUTES_10 = (TimeSpanWithContext)TimeSpan.parseWithoutException("10m!365.2425");
    public static final TimeSpanWithContext MINUTES_1 = (TimeSpanWithContext)TimeSpan.parseWithoutException("1m!365.2425");
    public static final TimeSpanWithContext AVERAGE_YEAR = (TimeSpanWithContext)TimeSpan.parseWithoutException("1Y!365.2425");
    public static final TimeSpanWithContext MINUTES_5 = (TimeSpanWithContext)TimeSpan.parseWithoutException("5m!365.2425");
    public static final TimeSpanWithContext ZERO = (TimeSpanWithContext)TimeSpan.parseWithoutException("0s!365.2425");
    long contextEpochMillis = 0L;
    int days = 0;
    private volatile Integer hashCode;
    int hours = 0;
    int microseconds = 0;
    int milliseconds = 0;
    int minutes = 0;
    int months = 0;
    int nanoseconds = 0;
    protected BigDecimal nanosPerYear;
    private boolean negative;
    private TimeSpan normalized;
    int seconds = 0;
    int weeks;
    int years = 0;
    protected double daysPerYear = 0.0;
    private static int[] CALENDAR_UNITS = new int[]{1, 2, 5, 10, 12, 13, 14};
    private static Unit[] UNITS_WITH_CALENDAR_REP = new Unit[]{Unit.YEARS, Unit.MONTHS, Unit.DAYS, Unit.HOURS, Unit.MINUTES, Unit.SECONDS, Unit.MILLISECONDS};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeSpanWithContext fromMillis(final long durationInMS, double daysInAYear) {
        if (daysInAYear == 0.0) {
            throw new IllegalArgumentException("Context may not be 0. Use 'withoutContext' instead");
        }
        HashMap<Object, WeakReference<TimeSpan>> hashMap = CACHE;
        synchronized (hashMap) {
            TimeSpan el;
            WeakReference<TimeSpan> ret = CACHE.get(durationInMS + "S!" + daysInAYear);
            if (ret != null && (el = (TimeSpan)ret.get()) != null) {
                if (el instanceof TimeSpanWithContext) {
                    return (TimeSpanWithContext)el;
                }
                return el.withFallbackStaticContext(daysInAYear);
            }
        }
        TimeSpan ret = new TimeSpan(){

            @Override
            protected BigDecimal getValueByUnitInternal(Unit s) {
                if (s == Unit.MILLISECONDS) {
                    return new BigDecimal(Math.abs(durationInMS));
                }
                return super.getValueByUnitInternal(s);
            }
        };
        if (durationInMS < 0L) {
            ret.negative = true;
        }
        ret.validate();
        TimeSpanWithContext context = ret.normalized().withFallbackStaticContext(daysInAYear);
        HashMap<Object, WeakReference<TimeSpan>> hashMap2 = CACHE;
        synchronized (hashMap2) {
            CACHE.put(durationInMS + "S!" + daysInAYear, new WeakReference<TimeSpanWithContext>(context));
        }
        return context;
    }

    private static TimeSpan parseWithoutException(String string) {
        try {
            return TimeSpan.parse(string);
        }
        catch (InvalidTimeSpanException e) {
            throw new WTFException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeSpan fromMillis(final long durationInMS) {
        HashMap<Object, WeakReference<TimeSpan>> hashMap = CACHE;
        synchronized (hashMap) {
            TimeSpan el;
            WeakReference<TimeSpan> ret = CACHE.get(durationInMS + "S");
            if (ret != null && (el = (TimeSpan)ret.get()) != null) {
                if (el instanceof TimeSpanWithContext) {
                    return ((TimeSpanWithContext)el).withoutContext();
                }
                return el;
            }
        }
        TimeSpan ret = new TimeSpan(){

            @Override
            protected BigDecimal getValueByUnitInternal(Unit s) {
                if (s == Unit.MILLISECONDS) {
                    return new BigDecimal(Math.abs(durationInMS));
                }
                return super.getValueByUnitInternal(s);
            }
        };
        if (durationInMS < 0L) {
            ret.negative = true;
        }
        ret.validate();
        ret = ret.normalized();
        HashMap<Object, WeakReference<TimeSpan>> hashMap2 = CACHE;
        synchronized (hashMap2) {
            CACHE.put(durationInMS + "S", new WeakReference<2>(ret));
        }
        return ret;
    }

    protected TimeSpan() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeSpan parse(String spanAsString) throws InvalidTimeSpanException {
        try {
            spanAsString = spanAsString.trim();
            HashMap<Object, WeakReference<TimeSpan>> hashMap = CACHE;
            synchronized (hashMap) {
                TimeSpan el;
                WeakReference<TimeSpan> ret = CACHE.get(spanAsString);
                if (ret != null && (el = (TimeSpan)ret.get()) != null) {
                    return el;
                }
            }
            long ms = 0L;
            spanAsString = spanAsString.replace("ms", Unit.MILLISECONDS.sign + "");
            char[] chars = spanAsString.toCharArray();
            TimeSpan ret = spanAsString.contains("!") ? new TimeSpanWithContext() : new TimeSpan();
            StringBuilder sb = new StringBuilder();
            boolean contentStarted = false;
            HashSet<Unit> dupe = new HashSet<Unit>();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (Character.isWhitespace(c)) continue;
                if (c == 'P' || c == 'p') {
                    if (ms == 0L) {
                        ret = TimeSpan.parseIso8601(chars);
                        ret.validate();
                        HashMap<Object, WeakReference<TimeSpan>> hashMap2 = CACHE;
                        synchronized (hashMap2) {
                            CACHE.put(spanAsString, new WeakReference<TimeSpan>(ret));
                        }
                        return ret;
                    }
                    throw new InvalidTimeSpanException("Invalid usage of P (ISO8601 format)");
                }
                if (c == '!') {
                    String context;
                    if (sb.length() > 0) {
                        if (dupe.size() == 0) {
                            ret.milliseconds = Integer.parseInt(sb.toString());
                            sb.setLength(0);
                        } else {
                            throw new InvalidTimeSpanException("Unexpected End of literal: " + sb.toString());
                        }
                    }
                    if ("NOW".equalsIgnoreCase(context = new String(chars, i + 1, chars.length - i - 1).trim())) {
                        ret.contextEpochMillis = System.currentTimeMillis();
                        break;
                    }
                    try {
                        ret._setDaysPerYearInternal(Double.parseDouble(context));
                    }
                    catch (Exception e) {
                        Date date = new DateMapper().parseString(context);
                        if (date == null) {
                            throw new InvalidTimeSpanException("Invalid Context:" + context);
                        }
                        ret.contextEpochMillis = date.getTime();
                    }
                    break;
                }
                if (c == '-' && !contentStarted) {
                    ret.negative = !ret.negative;
                    continue;
                }
                if (c == '.' || c == ',' || Character.isDigit(c)) {
                    contentStarted = true;
                    sb.append(c);
                    continue;
                }
                contentStarted = true;
                if (c == 'Y' || c == 'y') {
                    if (!dupe.add(Unit.YEARS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.years = Integer.parseInt(sb.toString());
                } else if (c == 'M') {
                    if (!dupe.add(Unit.MONTHS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.months = Integer.parseInt(sb.toString());
                } else if (c == 'W' || c == 'w') {
                    if (!dupe.add(Unit.WEEKS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.weeks = Integer.parseInt(sb.toString());
                } else if (c == 'D' || c == 'd') {
                    if (!dupe.add(Unit.DAYS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.days = Integer.parseInt(sb.toString());
                } else if (c == 'h' || c == 'H') {
                    if (!dupe.add(Unit.HOURS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.hours = Integer.parseInt(sb.toString());
                } else if (c == 'm') {
                    if (!dupe.add(Unit.MINUTES)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.minutes = Integer.parseInt(sb.toString());
                } else if (c == 's') {
                    if (!dupe.add(Unit.SECONDS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.addFloatingPoint(Unit.SECONDS, Double.parseDouble(sb.toString()));
                } else if (c == 'S') {
                    if (!dupe.add(Unit.MILLISECONDS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.addFloatingPoint(Unit.MILLISECONDS, Double.parseDouble(sb.toString()));
                } else if (c == '\u00b5' || c == 'u') {
                    if (!dupe.add(Unit.MICROSECONDS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.addFloatingPoint(Unit.MICROSECONDS, Double.parseDouble(sb.toString()));
                } else if (c == 'n') {
                    if (!dupe.add(Unit.NANO_SECONDS)) {
                        throw new InvalidTimeSpanException("Unit duplicate: " + c);
                    }
                    ret.nanoseconds = MathUtils.addExact(ret.nanoseconds, Integer.parseInt(sb.toString()));
                } else {
                    throw new InvalidTimeSpanException("'" + c + "' is not a valid qualifier");
                }
                sb.setLength(0);
            }
            if (sb.length() > 0) {
                if (dupe.size() == 0) {
                    ret.milliseconds = Integer.parseInt(sb.toString());
                    sb.setLength(0);
                } else {
                    throw new InvalidTimeSpanException("Unexpected End of literal: " + sb.toString());
                }
            }
            ret.validate();
            HashMap<Object, WeakReference<TimeSpan>> hashMap3 = CACHE;
            synchronized (hashMap3) {
                CACHE.put(spanAsString, new WeakReference<TimeSpan>(ret));
            }
            return ret;
        }
        catch (NumberFormatException e) {
            throw new InvalidTimeSpanException(e);
        }
    }

    protected void validate() {
        if (this.normalized == null) {
            try {
                this.normalized = this.convert(null);
            }
            catch (IllegalTargetUnitsException e) {
                throw new WTFException(e);
            }
            this.normalized.normalized = this.normalized;
        }
    }

    public static TimeSpan parse(String string, double dayPerYear) throws NumberFormatException, InvalidTimeSpanException {
        return TimeSpan.parse(string + "!" + dayPerYear);
    }

    public static TimeSpan parseIso8601(char[] chars) throws InvalidTimeSpanException {
        StringBuilder sb = new StringBuilder();
        boolean time = false;
        boolean p = false;
        TimeSpan ret = new TimeSpan();
        HashSet<Unit> dupe = new HashSet<Unit>();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c) || c == '+') continue;
            if (c == '-' && !p) {
                ret.negative = !ret.negative;
                continue;
            }
            if (c == 'P' || c == 'p') {
                if (p) {
                    throw new InvalidTimeSpanException("Illegal usage of 'p'");
                }
                p = true;
                continue;
            }
            if (!time && c == 'T') {
                time = true;
                continue;
            }
            if (c == '-') {
                throw new InvalidTimeSpanException("Illegal - at this position");
            }
            if (c == '.' || c == ',' || Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (!p) {
                throw new InvalidTimeSpanException("Missing leading [-+]P");
            }
            if (c == 'Y' || c == 'y') {
                if (time) {
                    throw new InvalidTimeSpanException("Cannot use '" + c + "' if 'T' was set before");
                }
                if (!dupe.add(Unit.YEARS)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                ret.years = Integer.parseInt(sb.toString());
            } else if (!(time || c != 'M' && c != 'm')) {
                if (!dupe.add(Unit.MONTHS)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                ret.months = Integer.parseInt(sb.toString());
            } else if (c == 'W' || c == 'w') {
                if (!dupe.add(Unit.WEEKS)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                if (time) {
                    throw new InvalidTimeSpanException("Cannot use '" + c + "' if 'T' was set before");
                }
                ret.weeks = Integer.parseInt(sb.toString());
            } else if (c == 'D' || c == 'd') {
                if (!dupe.add(Unit.DAYS)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                ret.days = Integer.parseInt(sb.toString());
            } else if (c == 'h' || c == 'H') {
                if (!dupe.add(Unit.HOURS)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                ret.hours = Integer.parseInt(sb.toString());
            } else if (time && (c == 'M' || c == 'm')) {
                if (!dupe.add(Unit.MINUTES)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                ret.minutes = Integer.parseInt(sb.toString());
            } else if (c == 's' || c == 'S') {
                if (!dupe.add(Unit.SECONDS)) {
                    throw new InvalidTimeSpanException("Unit duplicate: " + c);
                }
                ret.addFloatingPoint(Unit.SECONDS, Double.parseDouble(sb.toString()));
            }
            sb.setLength(0);
        }
        return ret;
    }

    private BigDecimal _getWithCalendar(Unit targetUnit, long timestamp) {
        BigDecimal result;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timestamp);
        long before = c.getTimeInMillis();
        c.add(1, this.years);
        c.add(2, this.months);
        c.add(5, this.days);
        c.add(5, this.weeks * 7);
        c.add(10, this.hours);
        c.add(12, this.minutes);
        c.add(13, this.seconds);
        c.add(14, this.milliseconds);
        long endTimeInMillis = c.getTimeInMillis();
        BigDecimal lowerUnits = BigDecimal.ZERO;
        for (Unit s : new Unit[]{Unit.MICROSECONDS, Unit.NANO_SECONDS}) {
            BigDecimal value = this.getValueByUnitInternal(s);
            if (value == BigDecimal.ZERO) continue;
            BigDecimal converted = s.convertTo(Unit.MILLISECONDS, this, value);
            lowerUnits = lowerUnits.add(converted);
        }
        BigDecimal fixed = lowerUnits.setScale(0, 5);
        c.add(14, fixed.intValueExact());
        lowerUnits = lowerUnits.subtract(fixed);
        if (targetUnit.ordinal() <= Unit.WEEKS.ordinal()) {
            result = new BigDecimal(c.getTimeInMillis() - timestamp);
            result = Unit.MILLISECONDS.convertTo(targetUnit, this, result);
            BigDecimal lowerInTarget = Unit.MILLISECONDS.convertTo(targetUnit, this, lowerUnits);
            result = result.add(lowerInTarget);
        } else {
            int target = 0;
            switch (targetUnit) {
                case MONTHS: {
                    target = 2;
                    break;
                }
                case YEARS: {
                    target = 1;
                    break;
                }
                default: {
                    throw new WTFException();
                }
            }
            result = BigDecimal.ZERO;
            long count = 0L;
            while (true) {
                c.add(target, -1);
                if (c.getTimeInMillis() < timestamp) break;
                if (++count != Long.MAX_VALUE) continue;
                result = result.add(new BigDecimal(count));
                count = 0L;
            }
            c.add(target, 1);
            result = result.add(new BigDecimal(count));
            long lastInMillis = c.getTimeInMillis();
            BigDecimal missing = new BigDecimal(lastInMillis - timestamp);
            missing = missing.add(lowerUnits);
            c.setTimeInMillis(endTimeInMillis);
            c.set(14, 0);
            c.set(13, 0);
            c.set(12, 0);
            c.set(10, 0);
            switch (targetUnit) {
                case YEARS: {
                    c.set(5, 1);
                    c.set(2, 0);
                    break;
                }
                case MONTHS: {
                    c.set(5, 1);
                    break;
                }
                default: {
                    throw new WTFException();
                }
            }
            System.out.println(c.toInstant());
            lastInMillis = c.getTimeInMillis();
            c.add(target, 1);
            System.out.println(c.toInstant());
            long fullUnitInMS = c.getTimeInMillis() - lastInMillis;
            missing = missing.divide(new BigDecimal(fullUnitInMS), 20, RoundingMode.HALF_DOWN);
            result = result.add(missing);
        }
        return result.stripTrailingZeros();
    }

    private void addFloatingPoint(Unit unit, double d) {
        Unit[] values = Unit.values();
        for (int i = unit.ordinal(); i >= 0; --i) {
            Unit u = values[i];
            long asLong = (long)d;
            if (asLong > Integer.MAX_VALUE) {
                throw new ArithmeticException("Max Integer.MAX_VALUE supported");
            }
            int fixed = (int)asLong;
            u.setValue(this, MathUtils.addExact(u.getValue(this), fixed));
            if ((d -= (double)fixed) <= 0.0) break;
            if (i == 0) {
                return;
            }
            BigDecimal factor = values[i].getToNanosFactor(this).divide(values[i - 1].getToNanosFactor(this));
            if (factor == null) {
                throw new IllegalStateException("To add a floating point value as " + (Object)((Object)unit) + ", you have to set the daysPerYear Property");
            }
            d *= factor.doubleValue();
        }
    }

    protected TimeSpan fillClone(TimeSpan ret) {
        for (Unit u : Unit.values()) {
            u.setValue(ret, u.getValue(this));
        }
        ret.nanosPerYear = this.nanosPerYear;
        ret.daysPerYear = this.daysPerYear;
        ret.contextEpochMillis = this.contextEpochMillis;
        ret.negative = this.negative;
        return ret;
    }

    public TimeSpan convert(Unit ... allowedTargetUnits) throws IllegalTargetUnitsException, ArithmeticException {
        HashSet<Unit> allowed;
        TimeSpan ret = this.hasStaticContext() || this.hasCalendarContext() ? new TimeSpanWithContext() : new TimeSpan();
        ret.daysPerYear = this.daysPerYear;
        ret.nanosPerYear = this.nanosPerYear;
        ret.contextEpochMillis = this.contextEpochMillis;
        ret.negative = this.negative;
        HashSet<Unit> hashSet = allowed = allowedTargetUnits == null ? null : new HashSet<Unit>(Arrays.asList(allowedTargetUnits));
        if (this.hasCalendarContext()) {
            try {
                BigDecimal smallest = this.getBigDecimal(Unit.NANO_SECONDS);
                BigDecimal[] remainder = smallest.divideAndRemainder(new BigDecimal(1000000L));
                BigDecimal millisToDist = remainder[0];
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(this.getContextEpochMillis());
                long millis = c.getTimeInMillis();
                for (int i = 0; i < CALENDAR_UNITS.length; ++i) {
                    BigDecimal toSubstract;
                    int count;
                    block12: {
                        if (allowed != null && !allowed.contains((Object)UNITS_WITH_CALENDAR_REP[i])) continue;
                        if (CALENDAR_UNITS[i] == 14) {
                            millisToDist = millisToDist.subtract(millisToDist);
                            UNITS_WITH_CALENDAR_REP[i].setValue(ret, millisToDist.intValueExact());
                            break;
                        }
                        count = 0;
                        toSubstract = BigDecimal.ZERO;
                        do {
                            c.add(CALENDAR_UNITS[i], 1);
                            BigDecimal diff = new BigDecimal(c.getTimeInMillis() - millis);
                            if (diff.compareTo(millisToDist) > 0) break block12;
                            toSubstract = diff;
                        } while (++count != Integer.MAX_VALUE);
                        throw new WTFException("TODO:OVERflow");
                    }
                    c.add(CALENDAR_UNITS[i], -1);
                    millis = c.getTimeInMillis();
                    millisToDist = millisToDist.subtract(toSubstract);
                    UNITS_WITH_CALENDAR_REP[i].setValue(ret, count);
                    if (millisToDist.compareTo(BigDecimal.ZERO) == 0) break;
                }
                long nanos = remainder[1].multiply(new BigDecimal(1000000L)).longValueExact();
                Unit.MICROSECONDS.setValue(ret, (int)(nanos / 1000L));
                Unit.NANO_SECONDS.setValue(ret, (int)nanos % 1000);
                return ret;
            }
            catch (ContextMissingException e) {
                throw new WTFException(e);
            }
        }
        Unit[] values = Unit.values();
        BigDecimal smallest = BigDecimal.ZERO;
        Unit lowest = null;
        for (Unit s : values) {
            if (lowest == null) {
                lowest = s;
            }
            BigDecimal value = this.getValueByUnitInternal(s);
            BigDecimal factor = s.getFactorTo(lowest, ret);
            if (factor == null) {
                this.dist(ret, smallest, lowest, Unit.values()[s.ordinal() - 1], allowed);
                smallest = value;
                lowest = s;
                continue;
            }
            if (value == BigDecimal.ZERO) continue;
            smallest = smallest.add(value.multiply(factor));
        }
        this.dist(ret, smallest, lowest, Unit.YEARS, allowed);
        boolean equals = true;
        for (Unit u : Unit.values()) {
            if (this.getValueByUnitInternal(u).equals(ret.getValueByUnitInternal(u))) continue;
            equals = false;
            break;
        }
        if (equals) {
            return this;
        }
        if (allowed == null) {
            ret.normalized = ret;
        }
        ret.validate();
        return ret;
    }

    private void addLongToCalendar(Calendar c, int type, long value) {
        int amount;
        do {
            amount = value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
            c.add(type, amount);
        } while ((value -= (long)amount) != 0L);
    }

    public boolean hasCalendarContext() {
        return this.contextEpochMillis > 0L;
    }

    private void dist(TimeSpan ret, BigDecimal value, Unit valueUnit, Unit maxUnit, HashSet<Unit> allowedTargetUnits) throws IllegalTargetUnitsException {
        if (value == BigDecimal.ZERO) {
            return;
        }
        for (int i = maxUnit.ordinal(); i >= 0; --i) {
            BigDecimal matches;
            Unit u = Unit.values()[i];
            if (allowedTargetUnits != null && !allowedTargetUnits.contains((Object)u)) continue;
            if (u == valueUnit) {
                if (u.getValue(ret) > 0) {
                    throw new WTFException();
                }
                int forUnitU = value.intValueExact();
                u.setValue(ret, forUnitU);
                return;
            }
            BigDecimal factor = u.getFactorTo(valueUnit, ret);
            if (factor == null || value.compareTo(factor) < 0 || (matches = value.divide(factor, 0, RoundingMode.DOWN)).compareTo(BigDecimal.ONE) < 0) continue;
            int forUnitU = matches.compareTo(INT_MAX) > 0 ? Integer.MAX_VALUE : matches.intValueExact();
            if (u.getValue(ret) > 0) {
                throw new WTFException();
            }
            u.setValue(ret, forUnitU);
            value = value.subtract(new BigDecimal(forUnitU).multiply(factor));
            if (value.compareTo(BigDecimal.ZERO) != 0) continue;
            return;
        }
        if (value.compareTo(BigDecimal.ZERO) != 0) {
            throw new IllegalTargetUnitsException("Conversion failed - selected target units cannot represent the timespan", null);
        }
    }

    protected BigDecimal getValueByUnitInternal(Unit s) {
        int v = s.getValue(this);
        if (v == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(v);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        TimeSpan meNormal = this.normalized();
        TimeSpan otherNormal = other.normalized();
        if (!CompareUtils.equalsNumber(this.contextEpochMillis, other.contextEpochMillis)) {
            return false;
        }
        if (obj.hashCode() != this.hashCode()) {
            return false;
        }
        boolean sameValues = true;
        for (Unit u : Unit.values()) {
            if (u.getValue(meNormal) == u.getValue(otherNormal)) continue;
            sameValues = false;
            break;
        }
        if (sameValues && Unit.NANO_SECONDS.getValue(this) == 0) {
            return true;
        }
        if (!CompareUtils.equals(this.nanosPerYear, other.nanosPerYear)) {
            return false;
        }
        if (!CompareUtils.equals(this.negative, other.negative)) {
            return false;
        }
        return sameValues;
    }

    public String format(boolean withContext) {
        StringBuilder ret = new StringBuilder();
        if (this.negative) {
            ret.append("-");
        }
        Unit[] values = Unit.values();
        for (int i = values.length - 1; i >= 0; --i) {
            Unit u = values[i];
            if (u.getValue(this) == 0) continue;
            ret.append(u.getValue(this)).append(u.sign);
        }
        if (ret.length() < 2) {
            ret.append("0s");
        }
        if (withContext) {
            if (this.daysPerYear > 0.0) {
                ret.append("!");
                ret.append(this.daysPerYear);
            } else if (this.contextEpochMillis > 0L) {
                ret.append("!");
                ret.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz", Locale.US).format(new Date(this.contextEpochMillis)));
            }
        }
        return ret.toString();
    }

    public BigDecimal getBigDecimal(Unit targetUnit) throws ContextMissingException {
        if (this.getContextEpochMillis() > 0L) {
            return this._getWithCalendar(targetUnit, this.getContextEpochMillis());
        }
        Unit[] values = Unit.values();
        BigDecimal ret = BigDecimal.ZERO;
        for (Unit s : values) {
            BigDecimal value = this.getValueByUnitInternal(s);
            if (value == BigDecimal.ZERO) continue;
            BigDecimal converted = s.convertTo(targetUnit, this, value);
            if (converted == null) {
                throw new ContextMissingException();
            }
            ret = ret.add(converted);
        }
        return ret;
    }

    public long getContextEpochMillis() {
        return this.contextEpochMillis;
    }

    public int getDays() {
        return this.days;
    }

    public double getDaysInAYear() {
        return this.daysPerYear;
    }

    public int getDeclared(Unit unit) {
        return unit.getValue(this);
    }

    public double getDouble(Unit targetUnit) throws ContextMissingException {
        return this.toDoubleExact(this.getBigDecimal(targetUnit));
    }

    public int getHours() {
        return this.hours;
    }

    public long getLong(Unit targetUnit) throws ContextMissingException {
        return this.getBigDecimal(targetUnit).setScale(0, 5).longValueExact();
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getMonths() {
        return this.months;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getYears() {
        return this.years;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            TimeSpan normed = this.normalized();
            this.hashCode = ("" + normed.years + normed.months + normed.weeks + normed.days + normed.hours + normed.minutes + normed.seconds + normed.milliseconds + normed.microseconds + normed.nanoseconds + (normed.negative ? 1 : 0) + this.contextEpochMillis + (this.nanosPerYear == null ? 0L : this.nanosPerYear.longValue())).hashCode();
        }
        return this.hashCode;
    }

    public TimeSpan normalized() {
        return this.normalized;
    }

    public TimeSpanWithContext withCalendarContext(long contextEpochMillis) {
        if (contextEpochMillis == 0L) {
            throw new IllegalArgumentException("Context may not be 0. Use 'withoutContext' instead");
        }
        if (contextEpochMillis == this.contextEpochMillis && this instanceof TimeSpanWithContext) {
            return (TimeSpanWithContext)this;
        }
        TimeSpanWithContext ret = new TimeSpanWithContext();
        this.fillClone(ret);
        ret.contextEpochMillis = contextEpochMillis;
        ret.validate();
        return ret;
    }

    public TimeSpan withoutContext() {
        if (!(this.hasCalendarContext() || this.hasStaticContext() || this instanceof TimeSpanWithContext)) {
            return this;
        }
        TimeSpan ret = new TimeSpan();
        this.fillClone(ret);
        ret.contextEpochMillis = 0L;
        ret.nanosPerYear = null;
        ret.daysPerYear = 0.0;
        ret.validate();
        return ret;
    }

    public TimeSpanWithContext withStaticContext(double daysInAYear) {
        if (daysInAYear == 0.0) {
            throw new IllegalArgumentException("Context may not be 0. Use 'withoutContext' instead");
        }
        if (daysInAYear == this.daysPerYear && this instanceof TimeSpanWithContext) {
            return (TimeSpanWithContext)this;
        }
        TimeSpanWithContext ret = new TimeSpanWithContext();
        this.fillClone(ret);
        ret.contextEpochMillis = 0L;
        ret._setDaysPerYearInternal(daysInAYear);
        ret.validate();
        return ret;
    }

    public TimeSpan setDays(int days) throws InvalidTimeSpanException {
        TimeSpan ret = this.copy();
        ret.days = days;
        ret.validate();
        return ret;
    }

    protected TimeSpan copy() {
        TimeSpan ret = this.hasContext() ? new TimeSpanWithContext() : new TimeSpan();
        this.fillClone(ret);
        return ret;
    }

    protected void _setDaysPerYearInternal(double daysInAYear) {
        this.daysPerYear = daysInAYear;
        this.nanosPerYear = Unit.DAYS.getToNanosFactor(this).multiply(new BigDecimal(daysInAYear));
        if (this.nanosPerYear.signum() == 0) {
            this.nanosPerYear = null;
        }
    }

    public TimeSpan setHours(int hours) throws InvalidTimeSpanException {
        if (hours == this.hours) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.hours = hours;
        ret.validate();
        return ret;
    }

    public TimeSpan setMicroseconds(int microseconds) throws InvalidTimeSpanException {
        if (microseconds == this.microseconds) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.microseconds = microseconds;
        ret.validate();
        return ret;
    }

    public TimeSpan setMilliseconds(int milliseconds) throws InvalidTimeSpanException {
        if (milliseconds == this.milliseconds) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.milliseconds = milliseconds;
        ret.validate();
        return ret;
    }

    public TimeSpan setMinutes(int minutes) throws InvalidTimeSpanException {
        if (minutes == this.minutes) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.minutes = minutes;
        ret.validate();
        return ret;
    }

    public TimeSpan setMonths(int months) throws InvalidTimeSpanException {
        if (months == this.months) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.months = months;
        ret.validate();
        return ret;
    }

    public TimeSpan setNanoseconds(int nanoseconds) throws InvalidTimeSpanException {
        if (nanoseconds == this.nanoseconds) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.nanoseconds = nanoseconds;
        ret.validate();
        return ret;
    }

    public TimeSpan setSeconds(int seconds) throws InvalidTimeSpanException {
        if (seconds == this.seconds) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.seconds = seconds;
        ret.validate();
        return ret;
    }

    public TimeSpan setWeeks(int weeks) throws InvalidTimeSpanException {
        if (weeks == this.weeks) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.weeks = weeks;
        ret.validate();
        return ret;
    }

    public TimeSpan setYears(int years) throws InvalidTimeSpanException {
        if (years == this.years) {
            return this;
        }
        TimeSpan ret = this.copy();
        ret.years = years;
        ret.validate();
        return ret;
    }

    private double toDoubleExact(BigDecimal big) {
        double ret = big.doubleValue();
        if (ret == Double.POSITIVE_INFINITY || ret == Double.NEGATIVE_INFINITY) {
            throw new ArithmeticException("BigDecimal to large to fit in double");
        }
        return ret;
    }

    public String toString() {
        return this.format(true);
    }

    @Override
    public int compareTo(TimeSpan o) throws TimeSpanCompareException {
        try {
            BigDecimal myNanos = this.getBigDecimal(Unit.NANO_SECONDS);
            BigDecimal othersNanos = o.getBigDecimal(Unit.NANO_SECONDS);
            return myNanos.compareTo(othersNanos);
        }
        catch (ContextMissingException myNanos) {
            try {
                BigDecimal myNanos2 = this.getBigDecimal(Unit.MONTHS);
                BigDecimal othersNanos = o.getBigDecimal(Unit.MONTHS);
                return myNanos2.compareTo(othersNanos);
            }
            catch (ContextMissingException contextMissingException) {
                throw new TimeSpanCompareException();
            }
        }
    }

    public boolean isLessThan(TimeSpan other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThan(long milliseconds) throws ContextMissingException {
        return this.getBigDecimal(Unit.MILLISECONDS).longValue() < milliseconds;
    }

    public TimeSpan max(TimeSpan other) {
        if (this.isLessThan(other)) {
            return other;
        }
        return this;
    }

    public TimeSpan limit(TimeSpan min, TimeSpan max) {
        TimeSpan minWithContext = min.withContext(this);
        TimeSpan maxWithContext = max.withContext(this);
        TimeSpan ret = this;
        if (ret.isLessThan(minWithContext)) {
            ret = minWithContext;
        }
        if (ret.isMoreThan(maxWithContext)) {
            ret = maxWithContext;
        }
        return ret;
    }

    public boolean hasStaticContext() {
        return this.daysPerYear > 0.0;
    }

    public TimeSpan withContext(TimeSpan context) {
        if (context.hasCalendarContext()) {
            return this.withCalendarContext(context.getContextEpochMillis());
        }
        if (context.hasStaticContext()) {
            return this.withStaticContext(context.daysPerYear);
        }
        return this.withoutContext();
    }

    public boolean isMoreThan(TimeSpan other) {
        return this.compareTo(other) > 0;
    }

    public boolean isSameAs(TimeSpan other) {
        return this.compareTo(other) == 0;
    }

    public String toReadableString(boolean withContext) {
        StringBuilder ret = new StringBuilder();
        Unit[] values = Unit.values();
        for (int i = values.length - 1; i >= 0; --i) {
            Unit u = values[i];
            if (u.getValue(this) == 0) continue;
            int v = u.getValue(this);
            String unit = u.getReadableName();
            if (v == 1) {
                unit = unit.replaceAll("s$", "");
            }
            if (ret.length() > 0) {
                ret.append(", ");
            }
            ret.append(v).append(" ").append(unit);
        }
        if (ret.length() == 0) {
            return "0 " + Unit.SECONDS.getReadableName();
        }
        if (withContext) {
            if (this.daysPerYear > 0.0) {
                ret.append(" (Static Context: ");
                ret.append(this.daysPerYear);
                ret.append(" days per year)");
            } else if (this.contextEpochMillis > 0L) {
                ret.append(" (Calendar Context: ");
                ret.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz").format(new Date(this.contextEpochMillis)));
                ret.append(")");
            }
        }
        if (this.negative) {
            return "- " + ret.toString();
        }
        return ret.toString();
    }

    public boolean hasContext() {
        return this.hasStaticContext() || this.hasCalendarContext();
    }

    public TimeSpan withFallbackContext(TimeSpan max) {
        if (this.hasContext() && this instanceof TimeSpanWithContext) {
            return this;
        }
        return this.withContext(max);
    }

    public TimeSpanWithContext withFallbackStaticContext(double daysInAYear) {
        if (this.hasContext() && this instanceof TimeSpanWithContext) {
            return (TimeSpanWithContext)this;
        }
        return this.withStaticContext(daysInAYear);
    }

    public TimeSpanWithContext withFallbackCalendarContext(long timestampEpochMillis) {
        if (this.hasContext() && this instanceof TimeSpanWithContext) {
            return (TimeSpanWithContext)this;
        }
        return this.withCalendarContext(timestampEpochMillis);
    }

    public TimeSpan shorten() {
        LinkedList<Unit> all = new LinkedList<Unit>(Arrays.asList(Unit.values()));
        TimeSpan best = null;
        while (all.size() > 0) {
            block4: {
                try {
                    TimeSpan test = this.convert(all.toArray(new Unit[0]));
                    if (best == null || test.format(true).length() < best.format(true).length()) {
                        best = test;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedException)) break block4;
                    Thread.currentThread().interrupt();
                }
            }
            all.removeLast();
        }
        return best;
    }

    public TimeSpan withZero(Unit ... units) {
        TimeSpan ret = this.copy();
        for (Unit u : units) {
            u.setValue(ret, 0);
        }
        ret.validate();
        return ret;
    }

    public TimeSpanWithContext withFallbackAverageYearContext() {
        return this.withFallbackStaticContext(365.2425);
    }

    public static TimeSpanWithContext withFallbackAverageYearContext(TimeSpan timeout) {
        if (timeout == null) {
            return null;
        }
        return timeout.withFallbackAverageYearContext();
    }

    public static class TimeSpanCompareException
    extends RuntimeException {
    }
}

