/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.duration;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Locale;
import org.appwork.utils.StringUtils;
import org.appwork.utils.duration.TimeSpan;

public enum Unit {
    NANO_SECONDS('n', 1L, 0){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getNanoseconds();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.nanoseconds = value;
        }
    }
    ,
    MICROSECONDS('\u00b5', 1000L, 3){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getMicroseconds();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.microseconds = value;
        }
    }
    ,
    MILLISECONDS('S', 1000000L, 6){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getMilliseconds();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.milliseconds = value;
        }
    }
    ,
    SECONDS('s', 1000000000L, 9){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getSeconds();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.seconds = value;
        }
    }
    ,
    MINUTES('m', 60000000000L, 11){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getMinutes();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.minutes = value;
        }
    }
    ,
    HOURS('h', 3600000000000L, 13){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getHours();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.hours = value;
        }
    }
    ,
    DAYS('D', 86400000000000L, 14){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getDays();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.days = value;
        }
    }
    ,
    WEEKS('W', 604800000000000L, 15){

        @Override
        protected int getValue(TimeSpan d) {
            return d.getWeeks();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.weeks = value;
        }
    }
    ,
    MONTHS('M', 0L, 16){
        private BigDecimal bd12 = new BigDecimal(12);

        @Override
        protected int getValue(TimeSpan d) {
            return d.getMonths();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.months = value;
        }

        @Override
        public BigDecimal convertTo(Unit target, TimeSpan d, BigDecimal value) {
            if (target == YEARS) {
                BigDecimal ret = value.divide(this.bd12, 1);
                ret = ret.setScale(0, 1);
                return ret;
            }
            return super.convertTo(target, d, value);
        }

        @Override
        BigDecimal getToNanosFactor(TimeSpan d) {
            if (d != null && d.nanosPerYear != null) {
                return d.nanosPerYear.divide(this.bd12);
            }
            return null;
        }
    }
    ,
    YEARS('Y', 0L, 17){
        private BigDecimal bd12 = new BigDecimal(12);

        @Override
        protected int getValue(TimeSpan d) {
            return d.getYears();
        }

        @Override
        protected void setValue(TimeSpan d, int value) {
            d.years = value;
        }

        @Override
        public BigDecimal convertTo(Unit target, TimeSpan d, BigDecimal value) {
            if (target == MONTHS) {
                BigDecimal div = value.multiply(this.bd12);
                div = div.setScale(0, 1);
                return div;
            }
            return super.convertTo(target, d, value);
        }

        @Override
        BigDecimal getToNanosFactor(TimeSpan d) {
            if (d != null && d.nanosPerYear != null) {
                return d.nanosPerYear;
            }
            return null;
        }
    };

    public final BigDecimal toNanos;
    public final char sign;
    protected int scale;
    private final BigDecimal fromNanos;
    private HashMap<Unit, BigDecimal> convertToFactors;

    private Unit(char sign, long toNanos, int scale) {
        this.scale = scale;
        if (toNanos > 0L) {
            this.toNanos = new BigDecimal(toNanos);
            this.fromNanos = BigDecimal.ONE.divide(this.toNanos, scale, RoundingMode.UP);
        } else {
            this.toNanos = null;
            this.fromNanos = null;
        }
        this.sign = sign;
        this.convertToFactors = new HashMap();
    }

    protected abstract int getValue(TimeSpan var1);

    protected abstract void setValue(TimeSpan var1, int var2);

    BigDecimal getToNanosFactor(TimeSpan d) {
        return this.toNanos;
    }

    public BigDecimal convertTo(Unit target, TimeSpan d, BigDecimal value) {
        if (this == target) {
            return value;
        }
        BigDecimal targetFactor = target.getToNanosFactor(d);
        BigDecimal thisFactor = this.getToNanosFactor(d);
        if (targetFactor != null && thisFactor != null) {
            BigDecimal div = thisFactor.multiply(value);
            div = target != NANO_SECONDS ? div.divide(targetFactor, target.getRequiredScale(), RoundingMode.HALF_DOWN) : div.setScale(0, RoundingMode.HALF_DOWN);
            return div;
        }
        return null;
    }

    protected BigDecimal getFactorTo(Unit lowest, TimeSpan ref) {
        BigDecimal ret = this.convertToFactors.get((Object)lowest);
        if (ret != null) {
            return ret;
        }
        BigDecimal myFactor = this.getToNanosFactor(ref);
        BigDecimal targetFactor = lowest.getToNanosFactor(ref);
        if (myFactor != null && targetFactor != null) {
            return myFactor.divide(targetFactor, lowest.getRequiredScale(), RoundingMode.HALF_DOWN);
        }
        return null;
    }

    public int getRequiredScale() {
        return this.scale;
    }

    protected boolean isZero(TimeSpan ret, BigDecimal value) {
        if (value == BigDecimal.ZERO) {
            return true;
        }
        if (value.signum() == 0) {
            return true;
        }
        if (this.fromNanos != null) {
            return value.compareTo(this.fromNanos) < 0;
        }
        BigDecimal nanoFactor = this.getToNanosFactor(ret);
        if (nanoFactor == null) {
            return false;
        }
        BigDecimal nanoInMe = BigDecimal.ONE.divide(nanoFactor, this.getRequiredScale(), RoundingMode.DOWN);
        return value.compareTo(nanoInMe) < 0;
    }

    String getReadableName() {
        return StringUtils.toCamelCase(this.name().toLowerCase(Locale.ROOT), true);
    }

    static {
        for (Unit a : Unit.values()) {
            for (Unit b : Unit.values()) {
                if (a.toNanos == null || b.toNanos == null) continue;
                a.convertToFactors.put(b, a.toNanos.divide(b.toNanos, 20, RoundingMode.HALF_DOWN).stripTrailingZeros());
            }
        }
        Unit.MONTHS.convertToFactors.put(YEARS, BigDecimal.ONE.divide(new BigDecimal(12), 20, RoundingMode.HALF_DOWN).stripTrailingZeros());
        Unit.YEARS.convertToFactors.put(MONTHS, new BigDecimal(12));
    }
}

