/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.appwork.resources.HighDPIIcon;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.ModificationType;

public class DisabledIcon
extends AbstractIconPipe {
    private HighDPIIcon grayedIcon;
    private final int width;
    private final int height;
    private static final Set<ModificationType> MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.COLOR)));

    public DisabledIcon(Icon icon) {
        super(icon);
        this.width = icon.getIconWidth();
        this.height = icon.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
        if (this.grayedIcon == null) {
            DisabledIcon disabledIcon = this;
            synchronized (disabledIcon) {
                if (this.grayedIcon == null) {
                    double scaling;
                    Image image = IconIO.toImage(this.delegate);
                    if (MultiResolutionImageHelper.isSupported() && !MultiResolutionImageHelper.isInstanceOf(image) && (scaling = MultiResolutionImageHelper.getHighestMonitorScaling()) != 1.0) {
                        Image imagebig = IconIO.toImage(IconIO.getScaledInstance(this.delegate, (int)Math.round((double)this.getIconWidth() * scaling), (int)Math.round((double)this.getIconHeight() * scaling)));
                        image = MultiResolutionImageHelper.create(image, Arrays.asList(image, imagebig));
                    }
                    Image grayImage = IconIO.toGrayScale(image);
                    this.grayedIcon = new HighDPIIcon(grayImage);
                    this.delegate = null;
                }
            }
        }
        if (parents == null) {
            parents = new ArrayList<Icon>();
        }
        parents.add(this);
        this.grayedIcon.paintIcon(c, g, x, y, parents);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public Set<ModificationType> getModifications() {
        return MODIFICATIONS;
    }
}

