/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.appwork.JNAHelper;
import org.appwork.builddecision.BuildDecisionRequired;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.testframework.AWTestValidateClassReference;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.URLStream;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.CanScaleItSelfIcon;
import org.appwork.utils.images.IconPipe;
import org.appwork.utils.images.Interpolation;
import org.appwork.utils.images.JNAImageHelper;
import org.appwork.utils.images.ModificationType;
import org.appwork.utils.images.ScalableIcon;
import org.appwork.utils.images.svg.NoSVGSupportFactory;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.os.CrossSystem;

@BuildDecisionRequired(tags={"SVG-JSVG", "SVG-SALAMANDER", "SVG-NONE"}, imports={"org.appwork.utils.images.svg.WeisjJSVGFactory", "org.appwork.utils.images.svg.KitFoxFactory", ""})
public class IconIO {
    @AWTestValidateClassReference
    protected static final String CLASS_ORG_APPWORK_UTILS_IMAGES_SVG_KIT_FOX_FACTORY = "org.appwork.utils.images.svg.KitFoxFactory";
    @AWTestValidateClassReference
    protected static final String CLASS_ORG_APPWORK_UTILS_IMAGES_SVG_WEISJ_JSVG_FACTORY = "org.appwork.utils.images.svg.WeisjJSVGFactory";
    public static final String SVG_NONE = "SVG-NONE";
    public static final String SVG_SALAMANDER = "SVG-SALAMANDER";
    public static final String SVG_JSVG = "SVG-JSVG";
    public static final String SVG_FACTORY_KEY = "SVG_FACTORY";
    private static final AtomicReference<SVGFactory> SVG_FACTORY = new AtomicReference();
    private static Boolean ICO_SUPPORTED;
    private static volatile Method ICO_DECODER;

    public static BufferedImage blur(BufferedImage image) {
        float[] matrix = new float[400];
        for (int i = 0; i < 400; ++i) {
            matrix[i] = 0.0025f;
        }
        ConvolveOp op = new ConvolveOp(new Kernel(20, 20, matrix), 1, null);
        return op.filter(image, null);
    }

    public static Image centerImage(Image input) {
        return IconIO.centerImage(input, Math.max(input.getWidth(null), input.getHeight(null)), Math.max(input.getWidth(null), input.getHeight(null)), null);
    }

    public static Image centerImage(Image input, int width, int height, Color background) {
        if (input.getWidth(null) == width && input.getHeight(null) == height) {
            return input;
        }
        if (MultiResolutionImageHelper.isSupported() && MultiResolutionImageHelper.isInstanceOf(input)) {
            int baseWidth = input.getWidth(null);
            int baseHeight = input.getHeight(null);
            List<Image> variants = MultiResolutionImageHelper.getResolutionVariants(input);
            Image[] newList = new Image[variants.size()];
            int baseIndex = 0;
            for (int i = 0; i < newList.length; ++i) {
                Image v = variants.get(i);
                double wFactor = (double)v.getWidth(null) / (double)baseWidth;
                double hFactor = (double)v.getHeight(null) / (double)baseHeight;
                if (wFactor == 1.0 && hFactor == 1.0) {
                    baseIndex = i;
                }
                newList[i] = IconIO.centerImage(v, (int)((double)width * wFactor), (int)((double)height * hFactor), background);
            }
            return MultiResolutionImageHelper.create(baseIndex, newList);
        }
        BufferedImage newImage = IconIO.createEmptyImage(width, height, input);
        Graphics2D g2d = newImage.createGraphics();
        double scale = g2d.getTransform().getScaleX();
        DebugMode.breakIf(scale > 1.0, new Object[0]);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Interpolation.BILINEAR.getHint());
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (background != null) {
            g2d.setColor(background);
            g2d.fillRect(0, 0, width, height);
        }
        int x = (width - input.getWidth(null)) / 2;
        int y = (height - input.getHeight(null)) / 2;
        g2d.drawImage(input, x, y, null);
        g2d.dispose();
        return newImage;
    }

    public static int clipScale(int v, double sv) {
        if (sv == 1.0) {
            return v;
        }
        double newv = (double)v * sv;
        if (newv < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (newv > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.round(newv);
    }

    public static BufferedImage colorRangeToTransparency(BufferedImage image, Color c1, Color c2) {
        final int r1 = c1.getRed();
        final int g1 = c1.getGreen();
        final int b1 = c1.getBlue();
        final int r2 = c2.getRed();
        final int g2 = c2.getGreen();
        final int b2 = c2.getBlue();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                if (r >= r1 && r <= r2 && g >= g1 && g <= g2 && b >= b1 && b <= b2) {
                    int dist = (Math.abs(r - (r1 + r2) / 2) + Math.abs(g - (g1 + g2) / 2) + Math.abs(b - (b1 + b2) / 2)) * 2;
                    return new Color(r, g, b, Math.min(255, dist)).getRGB();
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        return IconIO.toBufferedImage(img);
    }

    public static BufferedImage colorRangeToTransparency(BufferedImage image, Color col, double tollerance) {
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        int a = col.getAlpha();
        return IconIO.colorRangeToTransparency(image, new Color(Math.max((int)((double)r * (1.0 - tollerance)), 0), Math.max((int)((double)g * (1.0 - tollerance)), 0), Math.max((int)((double)b * (1.0 - tollerance)), 0), a), new Color(Math.min(255, (int)((double)r * (1.0 + tollerance))), Math.min(255, (int)((double)g * (1.0 + tollerance))), Math.min(255, (int)((double)b * (1.0 + tollerance))), a));
    }

    public static BufferedImage convertIconToBufferedImage(Icon icon) {
        Image ret;
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon && (ret = ((ImageIcon)icon).getImage()) instanceof BufferedImage) {
            return (BufferedImage)ret;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = IconIO.createEmptyImage(w, h, 2, 3);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static BufferedImage createEmptyImage(int w, int h) {
        return IconIO.createEmptyImage(w, h, -1, -1);
    }

    public static BufferedImage createEmptyImage(int width, int height, Image deriveFrom) {
        int imageType = 2;
        int transparency = 3;
        if (deriveFrom instanceof BufferedImage) {
            imageType = ((BufferedImage)deriveFrom).getType();
            if (imageType <= 0) {
                imageType = 2;
            }
            if ((transparency = ((BufferedImage)deriveFrom).getTransparency()) <= 0) {
                transparency = 3;
            }
        }
        return IconIO.createEmptyImage(width, height, imageType, transparency);
    }

    public static BufferedImage createEmptyImage(int width, int height, int imageType, int transparency) {
        BufferedImage newImage;
        if (imageType <= 0) {
            imageType = 2;
        }
        if (transparency <= 0) {
            transparency = 3;
        }
        if (Application.isHeadless()) {
            newImage = new BufferedImage(width, height, imageType);
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            newImage = gc.createCompatibleImage(width, height, transparency);
        }
        return newImage;
    }

    private static SVGFactory createSVGFactory() {
        String fromSysProp = System.getProperty(SVG_FACTORY_KEY);
        if (fromSysProp != null && StringUtils.isEmpty(fromSysProp)) {
            return null;
        }
        List<String> clazzes = Arrays.asList(fromSysProp, CLASS_ORG_APPWORK_UTILS_IMAGES_SVG_WEISJ_JSVG_FACTORY, CLASS_ORG_APPWORK_UTILS_IMAGES_SVG_KIT_FOX_FACTORY);
        for (String clazz : clazzes) {
            if (!StringUtils.isNotEmpty(clazz)) continue;
            try {
                SVGFactory factory = (SVGFactory)Class.forName(clazz, false, Thread.currentThread().getContextClassLoader()).newInstance();
                if (!factory.isSupported()) continue;
                return factory;
            }
            catch (Throwable e) {
                if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) continue;
                throw new WTFException(e);
            }
        }
        return null;
    }

    public static Icon getIcon(URL resource, int w, int h) {
        Icon ret = IconIO.loadVectorIcon(resource, w, h);
        if (ret != null) {
            return ret;
        }
        Image image = IconIO.loadImage(resource);
        if (image.getWidth(null) == w && image.getHeight(null) == h) {
            return new ImageIcon(image);
        }
        if (w <= 0 && h <= 0) {
            return new ImageIcon(image);
        }
        return new ImageIcon(IconIO.getScaledInstance(image, w, h, Interpolation.BICUBIC, true));
    }

    public static Icon getIconFromDataUrl(String dataURL) throws IOException {
        return new ImageIcon(IconIO.getImageFromDataUrl(dataURL));
    }

    @Deprecated
    public static Image getImage(URL resource, boolean Dummy) {
        return IconIO.loadImage(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image loadImage(URL resource) {
        InputStream is;
        if (resource == null) {
            return null;
        }
        if (StringUtils.endsWithCaseInsensitive(resource.getPath(), ".exe") && IconIO.isExeSupported()) {
            try {
                Image ret = JNAImageHelper.getImageFromExe(resource);
                if (ret != null) {
                    return ret;
                }
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        if (StringUtils.endsWithCaseInsensitive(resource.getPath(), ".ico") && IconIO.isIcoSupported()) {
            try {
                is = resource.openStream();
                try {
                    List bufferedImages = (List)ICO_DECODER.invoke(null, is);
                    if (bufferedImages != null && bufferedImages.size() > 0) {
                        ArrayList<Image> images = new ArrayList<Image>(bufferedImages);
                        MultiResolutionImageHelper.sortImagesBySize(images);
                        if (images.size() > 1 && MultiResolutionImageHelper.isSupported()) {
                            Image image = MultiResolutionImageHelper.create(images.size() - 1, images.toArray(new Image[0]));
                            return image;
                        }
                        Image image = images.get(images.size() - 1);
                        return image;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (InvocationTargetException e) {
                LogV3.log(e);
            }
            catch (IllegalAccessException e) {
                LogV3.log(e);
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        is = null;
        try {
            is = URLStream.openStream(resource);
            BufferedImage ret = ImageIO.read(is);
            if (ret == null) return null;
            BufferedImage bufferedImage = ret;
            return bufferedImage;
        }
        catch (IOException e) {
            LogV3.log(new IOException("URL:" + resource, e));
            return null;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static Image getImageFromDataUrl(String dataURL) throws IOException {
        return ImageIO.read(IO.dataUrlToInputStream(dataURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon loadVectorIcon(URL resource, int w, int h) {
        if (resource != null && StringUtils.endsWithCaseInsensitive(resource.getPath(), ".svg")) {
            if (IconIO.getSvgFactory() != null) {
                ScalableIcon scalableIcon;
                InputStream is = resource.openStream();
                try {
                    scalableIcon = IconIO.getSvgFactory().getIconFromSVG(is, null, w, h, null);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        LogV3.log(e);
                    }
                }
                is.close();
                return scalableIcon;
            } else {
                LogV3.warning("SVG Factory not found!");
            }
        }
        return null;
    }

    public static Icon getScaledInstance(Icon icon, int width, int height) {
        return IconIO.getScaledInstance(icon, width, height, Interpolation.BICUBIC);
    }

    public static Icon getScaledInstance(Icon icon, int width, int height, Interpolation bicubic) {
        if (icon.getIconHeight() == height && icon.getIconWidth() == width) {
            return icon;
        }
        if (icon instanceof ScalableIcon) {
            return new ScaledIcon(icon, width, height, bicubic);
        }
        if (icon instanceof ScaledIcon) {
            ScaledIcon scaledIcon = (ScaledIcon)icon;
            if (scaledIcon.getIconHeight() == height && scaledIcon.getIconWidth() == width) {
                return icon;
            }
            ScaledIcon newScaledIcon = new ScaledIcon(scaledIcon.getOrigin(), width, height, bicubic);
            if (newScaledIcon.getIconHeight() == scaledIcon.getIconHeight() && newScaledIcon.getIconWidth() == scaledIcon.getIconWidth()) {
                return scaledIcon;
            }
            return newScaledIcon;
        }
        if (icon instanceof CanScaleItSelfIcon) {
            return ((CanScaleItSelfIcon)icon).getScaledInstance(width, height, bicubic);
        }
        return new ScaledIcon(icon, width, height, bicubic);
    }

    public static Image getScaledInstance(Image img, int width, int height) {
        return IconIO.getScaledInstance(img, width, height, Interpolation.BICUBIC, true);
    }

    public static Image getScaledInstance(Image img, int width, int height, Interpolation interpolation, boolean higherQuality) {
        return IconIO.getScaledInstance(img, width, height, interpolation, higherQuality, true);
    }

    public static Image getScaledInstance(Image img, int width, int height, Interpolation interpolation, boolean higherQuality, boolean keepratio) {
        int h;
        int w;
        DebugMode.breakIf(img == null, new Object[0]);
        double faktor = Math.max((double)img.getWidth(null) / (double)width, (double)img.getHeight(null) / (double)height);
        if (keepratio || width <= 0 || height <= 0) {
            if (faktor == 1.0) {
                return img;
            }
            width = (int)Math.max(Math.round((double)img.getWidth(null) / faktor), 1L);
            height = (int)Math.max(Math.round((double)img.getHeight(null) / faktor), 1L);
        } else if (height == img.getHeight(null) && width == img.getWidth(null)) {
            return img;
        }
        if (MultiResolutionImageHelper.isInstanceOf(img)) {
            img = MultiResolutionImageHelper.getResolutionVariant(img, width, height);
        }
        Image ret = img;
        if (higherQuality) {
            w = Math.max(width, img.getWidth(null));
            h = Math.max(height, img.getHeight(null));
        } else {
            w = width;
            h = height;
        }
        do {
            if (higherQuality && w > width && (w /= 2) < width) {
                w = width;
            }
            if (higherQuality && h > height && (h /= 2) < height) {
                h = height;
            }
            BufferedImage tmp = IconIO.createEmptyImage(w, h, img);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation.getHint());
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != width || h != height);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVGFactory getSvgFactory() {
        SVGFactory factory = SVG_FACTORY.get();
        if (factory == null) {
            AtomicReference<SVGFactory> atomicReference = SVG_FACTORY;
            synchronized (atomicReference) {
                factory = SVG_FACTORY.get();
                if (factory == null) {
                    factory = IconIO.createSVGFactory();
                    if (factory == null) {
                        factory = new NoSVGSupportFactory();
                    }
                    SVG_FACTORY.set(factory);
                }
            }
        }
        if (!factory.isSupported()) {
            return null;
        }
        return factory;
    }

    public static Image getTransparent(Image src, float f) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        BufferedImage image = IconIO.createEmptyImage(w, h, 2, 3);
        Graphics2D g = image.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, f));
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return image;
    }

    public static boolean isExeSupported() {
        return JNAHelper.isJNAAvailable() && CrossSystem.isWindows();
    }

    public static boolean isIcoSupported() {
        if (ICO_SUPPORTED != null) {
            return ICO_SUPPORTED == Boolean.TRUE;
        }
        try {
            Class<?> cls = Class.forName("net.sf.image4j.codec.ico.ICODecoder");
            Method method = cls.getMethod("read", InputStream.class);
            ParameterizedType type = (ParameterizedType)method.getGenericReturnType();
            if (type.getRawType() == List.class && type.getActualTypeArguments()[0] == BufferedImage.class) {
                ICO_DECODER = method;
                ICO_SUPPORTED = true;
            }
        }
        catch (ClassNotFoundException e) {
            LogV3.log(e);
            ICO_SUPPORTED = false;
        }
        catch (NoSuchMethodException e) {
            LogV3.log(e);
            ICO_SUPPORTED = false;
        }
        catch (SecurityException e) {
            LogV3.log(e);
            ICO_SUPPORTED = false;
        }
        return ICO_SUPPORTED == Boolean.TRUE;
    }

    public static boolean isImageCanGetDownscaled(int width, int height, Image img) {
        double faktor = Math.max((double)img.getWidth(null) / (double)width, (double)img.getHeight(null) / (double)height);
        if (faktor < 1.0) {
            return false;
        }
        int targetWidth = (int)Math.max(Math.round((double)img.getWidth(null) / faktor), 1L);
        int targetHeight = (int)Math.max(Math.round((double)img.getHeight(null) / faktor), 1L);
        return !(width > 0 && img.getWidth(null) < targetWidth || height > 0 && img.getHeight(null) < targetHeight);
    }

    public static boolean isImageMaxSizeInViewport(int width, int height, Image baseImage) {
        int iw = baseImage.getWidth(null);
        int ih = baseImage.getHeight(null);
        if (!(width > 0 && iw != width || height > 0 && ih != height)) {
            return true;
        }
        if (iw == width && (height <= 0 || ih < height)) {
            return true;
        }
        return iw == width && (height <= 0 || ih < height);
    }

    public static BufferedImage removeBackground(BufferedImage image, double tollerance) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int biggestValue = 0;
        int color = -1;
        for (int rgb : image.getRGB(0, 0, image.getWidth() - 1, image.getHeight() - 1, null, 0, image.getWidth())) {
            Integer v = (Integer)map.get(rgb);
            if (v == null) {
                v = 0;
            }
            Integer n = v;
            Integer n2 = v = Integer.valueOf(v + 1);
            map.put(rgb, v);
            if (v <= biggestValue) continue;
            biggestValue = v;
            color = rgb;
        }
        Color col = new Color(color);
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        int a = col.getAlpha();
        return IconIO.colorRangeToTransparency(image, new Color(Math.max((int)((double)r * (1.0 - tollerance)), 0), Math.max((int)((double)g * (1.0 - tollerance)), 0), Math.max((int)((double)b * (1.0 - tollerance)), 0), a), new Color(Math.min(255, (int)((double)r * (1.0 + tollerance))), Math.min(255, (int)((double)g * (1.0 + tollerance))), Math.min(255, (int)((double)b * (1.0 + tollerance))), a));
    }

    public static Image replaceColor(BufferedImage image, Color search, final int tollerance, final Color replace, final boolean keepBrightness) {
        if (search == null) {
            RGBImageFilter filter = new RGBImageFilter(){

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    int a = rgb >> 24 & 0xFF;
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb >> 0 & 0xFF;
                    double brightness = !keepBrightness ? 1.0 : 0.299 * (double)r + 0.578 * (double)g + 0.114 * (double)b;
                    Color nc = new Color((int)((double)replace.getRed() * brightness), (int)((double)replace.getGreen() * brightness), (int)((double)replace.getBlue() * brightness), replace.getAlpha() * a / 255);
                    return nc.getRGB();
                }
            };
            FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
            Image img = Toolkit.getDefaultToolkit().createImage(ip);
            return img;
        }
        final int a1 = search.getAlpha();
        final int r1 = search.getRed();
        final int g1 = search.getGreen();
        final int b1 = search.getBlue();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb >> 0 & 0xFF;
                if (Math.abs(r - r1) <= tollerance && Math.abs(g - g1) <= tollerance && Math.abs(b - b1) <= tollerance && Math.abs(a - a1) <= tollerance) {
                    if (!keepBrightness) {
                        return replace.getRGB();
                    }
                    double brightness = (0.299 * (double)r + 0.578 * (double)g + 0.114 * (double)b) / 255.0;
                    Color nc = new Color((int)((double)replace.getRed() * brightness), (int)((double)replace.getGreen() * brightness), (int)((double)replace.getBlue() * brightness), replace.getAlpha() * a / 255);
                    return nc.getRGB();
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        return img;
    }

    public static Icon replaceColor(Icon icon, Color search, int tollerance, Color replace, boolean keepBrightness) {
        return new ImageIcon(IconIO.replaceColor(IconIO.toBufferedImage(icon), search, tollerance, replace, keepBrightness));
    }

    public static BufferedImage rotate(BufferedImage src, int degree) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        AffineTransform at = new AffineTransform();
        at.rotate((double)degree * Math.PI / 180.0);
        Point2D.Double p2din = new Point2D.Double(0.0, 0.0);
        Point2D p2dout = at.transform(p2din, null);
        double ytrans = p2dout.getY();
        double xtrans = p2dout.getX();
        p2din = new Point2D.Double(0.0, h);
        p2dout = at.transform(p2din, null);
        ytrans = Math.min(ytrans, p2dout.getY());
        xtrans = Math.min(xtrans, p2dout.getX());
        p2din = new Point2D.Double(w, h);
        p2dout = at.transform(p2din, null);
        ytrans = Math.min(ytrans, p2dout.getY());
        xtrans = Math.min(xtrans, p2dout.getX());
        p2din = new Point2D.Double(w, 0.0);
        p2dout = at.transform(p2din, null);
        ytrans = Math.min(ytrans, p2dout.getY());
        xtrans = Math.min(xtrans, p2dout.getX());
        AffineTransform tat = new AffineTransform();
        tat.translate(-xtrans, -ytrans);
        at.preConcatenate(tat);
        AffineTransformOp bio = new AffineTransformOp(at, 2);
        Rectangle r = bio.getBounds2D(src).getBounds();
        BufferedImage image = IconIO.createEmptyImage(r.width, r.height, src);
        image = bio.filter(src, image);
        return image;
    }

    public static BufferedImage toBufferedImage(Icon icon) {
        Image img;
        if (icon instanceof ImageIcon && (img = ((ImageIcon)icon).getImage()) instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = IconIO.createEmptyImage(w, h);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static BufferedImage toBufferedImage(Image src) {
        if (src instanceof BufferedImage) {
            return (BufferedImage)src;
        }
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        BufferedImage image = IconIO.createEmptyImage(w, h, src);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return image;
    }

    public static String toDataUrl(BufferedImage image, DataURLFormat dataURLFormat) throws IOException {
        String ret;
        BufferedImage ouput;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream b64os = new Base64OutputStream(bos);
        switch (dataURLFormat) {
            case JPG: {
                ouput = IconIO.createEmptyImage(image.getWidth(), image.getHeight(), 1, 1);
                break;
            }
            default: {
                ouput = IconIO.createEmptyImage(image.getWidth(), image.getHeight(), 2, 3);
            }
        }
        Graphics g = ouput.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        switch (dataURLFormat) {
            case JPG: {
                ImageProvider.writeImage((RenderedImage)ouput, "jpg", b64os);
                b64os.close();
                ret = "image/jpeg;base64," + bos.toString("UTF-8");
                break;
            }
            default: {
                ImageProvider.writeImage((RenderedImage)ouput, "png", b64os);
                b64os.close();
                ret = "image/png;base64," + bos.toString("UTF-8");
            }
        }
        return ret;
    }

    public static Image toGrayScale(Image input) {
        Image ret = GrayFilter.createDisabledImage(input);
        return ret;
    }

    public static Image toImage(Icon icon) {
        Icon i = icon;
        while (i != null && i.getIconHeight() == icon.getIconHeight() && i.getIconWidth() == icon.getIconWidth()) {
            Set<ModificationType> mods;
            if (i instanceof ImageIcon) {
                return ((ImageIcon)i).getImage();
            }
            if (!(i instanceof IconPipe) || (mods = ((IconPipe)((Object)i)).getModifications()) != null && !mods.contains((Object)ModificationType.NONE)) break;
            i = ((IconPipe)((Object)i)).getDelegate();
        }
        return IconIO.toBufferedImage(icon);
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(IconIO.toBufferedImage(icon));
    }

    public static byte[] toJpgBytes(Image image) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedImage jpg = IconIO.createEmptyImage(image.getWidth(null), image.getHeight(null), 1, 1);
        Graphics g = jpg.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ImageProvider.writeImage((RenderedImage)jpg, "jpg", bos);
        bos.close();
        return bos.toByteArray();
    }

    public static byte[] toPngBytes(Image image) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedImage jpg = IconIO.createEmptyImage(image.getWidth(null), image.getHeight(null), 2, 3);
        Graphics g = jpg.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ImageProvider.writeImage((RenderedImage)jpg, "png", bos);
        bos.close();
        return bos.toByteArray();
    }

    public static IconIdentifier getPrimaryIdentifier(Icon icon) {
        while (icon != null) {
            if (icon instanceof IDIcon) {
                return ((IDIcon)((Object)icon)).getIdentifier();
            }
            if (!(icon instanceof IconPipe)) break;
            icon = ((IconPipe)((Object)icon)).getDelegate();
        }
        return null;
    }

    public static Image getPrimaryImage(Icon icon) {
        while (icon != null) {
            if (icon instanceof ImageIcon) {
                return ((ImageIcon)icon).getImage();
            }
            if (!(icon instanceof IconPipe)) break;
            icon = ((IconPipe)((Object)icon)).getDelegate();
        }
        return null;
    }

    public static boolean isImageDimensionWithinRange(Image img, int fromWidth, int toWidth, int fromHeight, int toHeight) {
        boolean widthInTolerance = fromWidth <= 0 || img.getWidth(null) >= fromWidth;
        if (widthInTolerance &= toWidth <= 0 || img.getWidth(null) <= toWidth) {
            boolean heightInTolerance = fromHeight <= 0 || img.getHeight(null) >= fromHeight;
            if (heightInTolerance &= toHeight <= 0 || img.getHeight(null) <= toHeight) {
                return true;
            }
        }
        return false;
    }

    static {
        ImageIO.setUseCache(false);
    }

    public static class ScaledIcon
    extends AbstractIconPipe
    implements Icon,
    IDIcon {
        private final int width;
        private final int height;
        private final Interpolation interpolation;
        private final double faktor;
        private static final Set<ModificationType> MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.SIZE)));

        @Override
        public Set<ModificationType> getModifications() {
            return MODIFICATIONS;
        }

        public ScaledIcon(Icon icon, int width, int height, Interpolation interpolation) {
            super(icon);
            this.faktor = 1.0 / Math.max((double)icon.getIconWidth() / (double)width, (double)icon.getIconHeight() / (double)height);
            this.width = Math.max((int)Math.round((double)icon.getIconWidth() * this.faktor), 1);
            this.height = Math.max((int)Math.round((double)icon.getIconHeight() * this.faktor), 1);
            this.interpolation = interpolation;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public IconIdentifier getIdentifier() {
            if (this.delegate instanceof IDIcon) {
                return ((IDIcon)((Object)this.delegate)).getIdentifier();
            }
            return new IconIdentifier("unknown", this.delegate.toString());
        }

        protected Icon getOrigin() {
            if (this.delegate instanceof ScaledIcon) {
                return ((ScaledIcon)this.delegate).getOrigin();
            }
            return this.delegate;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
            if (this.delegate instanceof ScalableIcon) {
                ((ScalableIcon)this.delegate).paintIcon(c, g, x, y, this.getIconWidth(), this.getIconHeight());
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolation.getHint());
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform old = g2.getTransform();
            g2.translate(x, y);
            g2.scale(this.faktor, this.faktor);
            this.paintDelegate(c, g2, 0, 0, parents);
            g2.setTransform(old);
        }
    }

    public static enum DataURLFormat {
        JPG,
        PNG;

    }
}

