/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.appwork.utils.JDK8BufferHelper;

public class CharSequenceInputStream
extends InputStream {
    protected final CharBuffer cb;
    protected final CharsetEncoder enc;
    protected final ByteBuffer buf;
    private final byte[] readBuf = new byte[1];

    public CharBuffer getCharBuffer() {
        return this.cb;
    }

    public Charset get() {
        return this.enc.charset();
    }

    public CharSequenceInputStream(CharBuffer charBuffer, Charset charSet) {
        this.cb = charBuffer;
        this.enc = this.newEncoder(charSet);
        this.buf = this.initByteBuffer(this.cb, this.enc);
    }

    protected CharsetEncoder newEncoder(Charset charSet) {
        return charSet.newEncoder();
    }

    public CharSequenceInputStream(CharSequence charSequence, Charset charSet) {
        this(CharBuffer.wrap(charSequence), charSet);
    }

    protected ByteBuffer initByteBuffer(CharBuffer charSequence, CharsetEncoder encoder) {
        ByteBuffer ret = ByteBuffer.allocate((int)encoder.averageBytesPerChar() * 16);
        JDK8BufferHelper.flip(ret);
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buf.remaining() > 0) {
            len = Math.min(len, this.buf.remaining());
            this.buf.get(b, off, len);
            return len;
        }
        if (!this.cb.hasRemaining()) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.wrap(b, off, len);
        CoderResult cr = this.enc.encode(this.cb, bb, !this.cb.hasRemaining());
        if (bb.position() > 0) {
            return bb.position();
        }
        if (cr.isOverflow()) {
            JDK8BufferHelper.clear(this.buf);
            cr = this.enc.encode(this.cb, this.buf, !this.cb.hasRemaining());
            if (this.buf.position() > 0) {
                JDK8BufferHelper.flip(this.buf);
                return this.read(b, off, len);
            }
            throw new IOException(cr.toString());
        }
        throw new IOException(cr.toString());
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.readBuf, 0, 1) == -1) {
            return -1;
        }
        return this.readBuf[0];
    }
}

