/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;

public class HTTPProxy {
    public static final HTTPProxy NONE = new HTTPProxy(TYPE.NONE){

        @Override
        public void setConnectMethodPrefered(boolean value) {
        }

        @Override
        public void setLocal(String local) {
        }

        @Override
        public void setPass(String pass) {
        }

        @Override
        public void setPort(int port) {
        }

        @Override
        public void setType(TYPE type) {
            super.setType(TYPE.NONE);
        }

        @Override
        public void setUser(String user) {
        }
    };
    protected String local = null;
    protected String user = null;
    protected String pass = null;
    protected int port = 80;
    protected String host = null;
    protected TYPE type = TYPE.DIRECT;
    protected boolean useConnectMethod = false;
    protected boolean preferNativeImplementation = false;
    protected boolean resolveHostname = false;
    protected boolean keepAliveSupported = false;
    protected boolean doNotStoreInstance = false;

    public static List<HTTPProxy> getFromSystemProperties() {
        ArrayList<HTTPProxy> ret = new ArrayList<HTTPProxy>();
        try {
            String pass;
            String user;
            HTTPProxy pr;
            String ports;
            int port;
            String host = System.getProperties().getProperty("http.proxyHost");
            if (!StringUtils.isEmpty(host)) {
                port = 80;
                ports = System.getProperty("http.proxyPort");
                if (!StringUtils.isEmpty(ports)) {
                    port = Integer.parseInt(ports);
                }
                pr = new HTTPProxy(TYPE.HTTP, host, port);
                user = System.getProperty("http.proxyUser");
                pass = System.getProperty("http.proxyPassword");
                if (!StringUtils.isEmpty(user)) {
                    pr.setUser(user);
                }
                if (!StringUtils.isEmpty(pass)) {
                    pr.setPass(pass);
                }
                ret.add(pr);
            }
            if (!StringUtils.isEmpty(host = System.getProperties().getProperty("https.proxyHost"))) {
                port = 443;
                ports = System.getProperty("https.proxyPort");
                if (!StringUtils.isEmpty(ports)) {
                    port = Integer.parseInt(ports);
                }
                pr = new HTTPProxy(TYPE.HTTPS, host, port);
                user = System.getProperty("https.proxyUser");
                pass = System.getProperty("https.proxyPassword");
                if (!StringUtils.isEmpty(user)) {
                    pr.setUser(user);
                }
                if (!StringUtils.isEmpty(pass)) {
                    pr.setPass(pass);
                }
                ret.add(pr);
            }
            if (!StringUtils.isEmpty(host = System.getProperties().getProperty("socksProxyHost"))) {
                port = 1080;
                ports = System.getProperty("socksProxyPort");
                if (!StringUtils.isEmpty(ports)) {
                    port = Integer.parseInt(ports);
                }
                pr = new HTTPProxy(TYPE.SOCKS5, host, port);
                ret.add(pr);
            }
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        return ret;
    }

    public static HTTPProxy getHTTPProxy(HTTPProxyStorable storable) {
        HTTPProxy ret;
        if (storable == null || storable.getType() == null) {
            return null;
        }
        switch (storable.getType()) {
            case NONE: {
                ret = new HTTPProxy(TYPE.NONE);
                break;
            }
            case DIRECT: {
                ret = new HTTPProxy(TYPE.DIRECT);
                ret.setLocal(storable.getAddress());
                break;
            }
            case HTTP: {
                ret = new HTTPProxy(TYPE.HTTP);
                ret.setHost(storable.getAddress());
                break;
            }
            case HTTPS: {
                ret = new HTTPProxy(TYPE.HTTPS);
                ret.setHost(storable.getAddress());
                break;
            }
            case SOCKS4: {
                ret = new HTTPProxy(TYPE.SOCKS4);
                ret.setHost(storable.getAddress());
                break;
            }
            case SOCKS4A: {
                ret = new HTTPProxy(TYPE.SOCKS4A);
                ret.setHost(storable.getAddress());
                break;
            }
            case SOCKS5: {
                ret = new HTTPProxy(TYPE.SOCKS5);
                ret.setHost(storable.getAddress());
                break;
            }
            case AUTO: {
                ret = new HTTPProxy(TYPE.AUTO);
                ret.setHost(storable.getAddress());
                break;
            }
            default: {
                return null;
            }
        }
        ret.setPreferNativeImplementation(storable.isPreferNativeImplementation());
        ret.setConnectMethodPrefered(storable.isConnectMethodPrefered());
        ret.setResolveHostname(storable.isResolveHostName());
        ret.setPass(storable.getPassword());
        ret.setUser(storable.getUsername());
        ret.setPort(storable.getPort());
        return ret;
    }

    private static String[] getInfo(String host, String port) {
        String[] info = new String[2];
        if (host == null) {
            return info;
        }
        String tmphost = host.replaceFirst("^https?://", "");
        String tmpport = new Regex(host, ":(\\d+)(/|$)").getMatch(0);
        if (tmpport != null) {
            info[1] = tmpport;
        } else {
            if (port != null) {
                tmpport = new Regex(port, "(\\d+)").getMatch(0);
            }
            info[1] = tmpport != null ? tmpport : "8080";
        }
        info[0] = new Regex(tmphost, "(.*?)(:\\d+$|:\\d+/|/|$)").getMatch(0);
        return info;
    }

    public static HTTPProxyStorable getStorable(HTTPProxy proxy) {
        if (proxy == null || proxy.getType() == null) {
            return null;
        }
        HTTPProxyStorable ret = new HTTPProxyStorable();
        proxy.fillProxyStorable(ret);
        return ret;
    }

    public void fillProxyStorable(HTTPProxyStorable ret) {
        switch (this.getType()) {
            case NONE: {
                ret.setType(HTTPProxyStorable.TYPE.NONE);
                ret.setAddress(null);
                break;
            }
            case DIRECT: {
                ret.setType(HTTPProxyStorable.TYPE.DIRECT);
                ret.setAddress(this.getLocal());
                break;
            }
            case HTTP: {
                ret.setType(HTTPProxyStorable.TYPE.HTTP);
                ret.setAddress(this.getHost());
                break;
            }
            case HTTPS: {
                ret.setType(HTTPProxyStorable.TYPE.HTTPS);
                ret.setAddress(this.getHost());
                break;
            }
            case SOCKS4: {
                ret.setType(HTTPProxyStorable.TYPE.SOCKS4);
                ret.setAddress(this.getHost());
                break;
            }
            case SOCKS4A: {
                ret.setType(HTTPProxyStorable.TYPE.SOCKS4A);
                ret.setAddress(this.getHost());
                break;
            }
            case SOCKS5: {
                ret.setType(HTTPProxyStorable.TYPE.SOCKS5);
                ret.setAddress(this.getHost());
                break;
            }
            case AUTO: {
                ret.setType(HTTPProxyStorable.TYPE.AUTO);
                ret.setAddress(this.getHost());
                break;
            }
        }
        ret.setConnectMethodPrefered(this.isConnectMethodPrefered());
        ret.setPreferNativeImplementation(this.isPreferNativeImplementation());
        ret.setResolveHostName(this.isResolveHostname());
        ret.setPort(this.getPort());
        ret.setPassword(this.getPass());
        ret.setUsername(this.getUser());
        ret._setDoNotStoreInstance(this.isDoNotStoreInstance());
    }

    public static HTTPProxy parseHTTPProxy(String s) {
        HTTPProxy ret;
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        String type = new Regex(s, "(https?|socks(5|4a|4)|direct|none)://").getMatch(0);
        String auth = new Regex(s, "://(.+)@").getMatch(0);
        String host = new Regex(s, "://(.+@)?(.*?)(/|$)").getMatch(1);
        if (StringUtils.equalsIgnoreCase("none", type)) {
            ret = new HTTPProxy(TYPE.NONE);
        } else if (StringUtils.equalsIgnoreCase("https", type)) {
            ret = new HTTPProxy(TYPE.HTTPS);
            ret.setPort(443);
        } else if (StringUtils.equalsIgnoreCase("http", type)) {
            ret = new HTTPProxy(TYPE.HTTP);
            ret.setPort(8080);
        } else if (StringUtils.equalsIgnoreCase("socks5", type)) {
            ret = new HTTPProxy(TYPE.SOCKS5);
            ret.setPort(1080);
        } else if (StringUtils.equalsIgnoreCase("socks4", type)) {
            ret = new HTTPProxy(TYPE.SOCKS4);
            ret.setPort(1080);
        } else if (StringUtils.equalsIgnoreCase("socks4a", type)) {
            ret = new HTTPProxy(TYPE.SOCKS4A);
            ret.setPort(1080);
        } else if (StringUtils.equalsIgnoreCase("direct", type)) {
            ret = new HTTPProxy(TYPE.DIRECT);
            ret.setLocal(host);
        } else {
            return null;
        }
        String hostname = new Regex(host, "(.*?)(:\\d+$|$)").getMatch(0);
        String port = new Regex(host, ".*?:(\\d+)$").getMatch(0);
        if (!StringUtils.isEmpty(hostname)) {
            ret.setHost(hostname);
        }
        if (!StringUtils.isEmpty(port)) {
            ret.setPort(Integer.parseInt(port));
        }
        String username = new Regex(auth, "(.*?)(:|$)").getMatch(0);
        String password = new Regex(auth, ".*?:(.+)").getMatch(0);
        if (!StringUtils.isEmpty(username)) {
            ret.setUser(username);
        }
        if (!StringUtils.isEmpty(password)) {
            ret.setPass(password);
        }
        switch (ret.getType()) {
            case NONE: {
                return ret;
            }
        }
        if (!StringUtils.isEmpty(ret.getHost())) {
            return ret;
        }
        return null;
    }

    public boolean isDoNotStoreInstance() {
        return this.doNotStoreInstance;
    }

    public void setDoNotStoreInstance(boolean doNotStoreInstance) {
        this.doNotStoreInstance = doNotStoreInstance;
    }

    public boolean isKeepAliveSupported() {
        return this.keepAliveSupported;
    }

    public void setKeepAliveSupported(boolean keepAliveSupported) {
        this.keepAliveSupported = keepAliveSupported;
    }

    public boolean isResolveHostname() {
        return this.resolveHostname;
    }

    public void setResolveHostname(boolean resolveHostname) {
        this.resolveHostname = resolveHostname;
    }

    protected HTTPProxy() {
    }

    public HTTPProxy(HTTPProxy proxy) {
        this.set(proxy);
    }

    public HTTPProxy(InetAddress direct) {
        this.setType(TYPE.DIRECT);
        this.setLocal(direct.getHostAddress());
    }

    public HTTPProxy(TYPE type) {
        this.setType(type);
    }

    public HTTPProxy(TYPE type, String host, int port) {
        this.setPort(port);
        this.setType(type);
        this.setHost(HTTPProxy.getInfo(host, Integer.toString(port))[0]);
    }

    public String _toString() {
        TYPE type = this.getType();
        if (type != null) {
            switch (type) {
                case NONE: {
                    return _AWU.T.proxy_none();
                }
                case HTTP: {
                    return _AWU.T.proxy_http(this.getHost(), this.getPort());
                }
                case HTTPS: {
                    return _AWU.T.proxy_https(this.getHost(), this.getPort());
                }
                case SOCKS5: {
                    return _AWU.T.proxy_socks5(this.getHost(), this.getPort());
                }
                case SOCKS4: {
                    return _AWU.T.proxy_socks4(this.getHost(), this.getPort());
                }
                case SOCKS4A: {
                    return _AWU.T.proxy_socks4a(this.getHost(), this.getPort());
                }
                case DIRECT: {
                    return _AWU.T.proxy_direct(this.getLocal());
                }
                case AUTO: {
                    return _AWU.T.proxy_type_auto_detect();
                }
            }
            return "UNKNOWN:" + type;
        }
        return "UNKNOWN";
    }

    public HTTPProxy clone() {
        HTTPProxy ret = new HTTPProxy();
        ret.cloneProxy(this);
        return ret;
    }

    protected void cloneProxy(HTTPProxy proxy) {
        if (proxy != null) {
            this.set(proxy);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof HTTPProxy)) {
            return false;
        }
        HTTPProxy p = (HTTPProxy)obj;
        if (this.getType() != p.getType()) {
            return false;
        }
        switch (this.getType()) {
            case DIRECT: {
                return StringUtils.equals(this.getLocal(), p.getLocal());
            }
            case NONE: {
                return true;
            }
        }
        if (!StringUtils.equals(this.getHost(), p.getHost())) {
            return false;
        }
        if (this.getPort() != p.getPort()) {
            return false;
        }
        if (!StringUtils.equals(StringUtils.isEmpty(this.getUser()) ? null : this.getUser(), StringUtils.isEmpty(p.getUser()) ? null : p.getUser())) {
            return false;
        }
        return StringUtils.equals(StringUtils.isEmpty(this.getPass()) ? null : this.getPass(), StringUtils.isEmpty(p.getPass()) ? null : p.getPass());
    }

    public boolean equalsWithSettings(HTTPProxy proxy) {
        if (this.equals(proxy)) {
            switch (this.getType()) {
                case HTTP: 
                case HTTPS: {
                    if (this.isConnectMethodPrefered() == proxy.isConnectMethodPrefered()) break;
                    return false;
                }
                case SOCKS4: 
                case SOCKS4A: 
                case SOCKS5: {
                    if (this.isKeepAliveSupported() == proxy.isKeepAliveSupported()) break;
                    return false;
                }
            }
            if (this.isPreferNativeImplementation() != proxy.isPreferNativeImplementation()) {
                return false;
            }
            return this.isResolveHostname() == proxy.isResolveHostname();
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public String getLocal() {
        return this.local;
    }

    public String getPass() {
        return this.pass;
    }

    public int getPort() {
        return this.port;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        return HTTPProxy.class.hashCode();
    }

    public boolean isConnectMethodPrefered() {
        return this.useConnectMethod;
    }

    public boolean isDirect() {
        return this.type == TYPE.DIRECT;
    }

    public boolean isLocal() {
        return this.isDirect() || this.isNone();
    }

    public boolean isNone() {
        return this.type == TYPE.NONE;
    }

    public boolean isPreferNativeImplementation() {
        return this.preferNativeImplementation;
    }

    public boolean isRemote() {
        return !this.isDirect() && !this.isNone();
    }

    protected void set(HTTPProxy proxy) {
        if (proxy != null) {
            this.setUser(proxy.getUser());
            this.setHost(proxy.getHost());
            this.setLocal(proxy.getLocal());
            this.setPass(proxy.getPass());
            this.setPort(proxy.getPort());
            this.setType(proxy.getType());
            this.setResolveHostname(proxy.isResolveHostname());
            this.setConnectMethodPrefered(proxy.isConnectMethodPrefered());
            this.setPreferNativeImplementation(proxy.isPreferNativeImplementation());
            this.setKeepAliveSupported(proxy.isKeepAliveSupported());
            this.setDoNotStoreInstance(proxy.isDoNotStoreInstance());
        }
    }

    public void setConnectMethodPrefered(boolean value) {
        this.useConnectMethod = value;
    }

    public void setHost(String host) {
        this.host = host != null ? host.trim() : host;
    }

    public void setLocal(String local) {
        this.local = local != null ? local.trim() : local;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPreferNativeImplementation(boolean preferNativeImplementation) {
        this.preferNativeImplementation = preferNativeImplementation;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        String ret = this._toString();
        if (StringUtils.isNotEmpty(this.user)) {
            ret = this.user + ":" + (StringUtils.isEmpty(this.pass) ? "-" : "*****") + "@" + ret;
        }
        if (this.isPreferNativeImplementation()) {
            ret = ret + "(prefer native)";
        }
        return ret;
    }

    public static TYPE convertNativeProxyType(Proxy proxy) {
        if (proxy != null) {
            switch (proxy.type()) {
                case SOCKS: {
                    try {
                        if (ReflectionUtils.isInstanceOf("sun.net.SocksProxy", proxy) && ReflectionUtils.invoke("sun.net.SocksProxy", "protocolVersion", (Object)proxy, Number.class, new Object[0]).intValue() == 4) {
                            return TYPE.SOCKS4;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return TYPE.SOCKS5;
                }
                case HTTP: {
                    return TYPE.HTTP;
                }
                case DIRECT: {
                    return TYPE.NONE;
                }
            }
            return null;
        }
        return null;
    }

    public Proxy toNativeProxy() {
        switch (this.getType()) {
            case NONE: 
            case DIRECT: {
                return Proxy.NO_PROXY;
            }
            case HTTP: {
                return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getHost(), this.getPort()));
            }
            case SOCKS4: 
            case SOCKS4A: {
                try {
                    Proxy ret = ReflectionUtils.invoke("sun.net.SocksProxy", "create", null, Proxy.class, new Class[]{SocketAddress.class, Integer.TYPE}, new Object[]{new InetSocketAddress(this.getHost(), this.getPort()), 4});
                    if (ret != null) {
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.getHost(), this.getPort()));
            }
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.getHost(), this.getPort()));
            }
        }
        return null;
    }

    public static HTTPProxy fromNativeProxy(Proxy proxy) {
        if (proxy != null) {
            switch (proxy.type()) {
                case DIRECT: {
                    return new HTTPProxy(TYPE.NONE);
                }
                case HTTP: {
                    if (proxy.address() instanceof InetSocketAddress) {
                        String host = ((InetSocketAddress)proxy.address()).getHostName();
                        int port = ((InetSocketAddress)proxy.address()).getPort();
                        return new HTTPProxy(TYPE.HTTP, host, port);
                    }
                    return null;
                }
                case SOCKS: {
                    if (proxy.address() instanceof InetSocketAddress) {
                        String host = ((InetSocketAddress)proxy.address()).getHostName();
                        int port = ((InetSocketAddress)proxy.address()).getPort();
                        return new HTTPProxy(HTTPProxy.convertNativeProxyType(proxy), host, port);
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static List<? extends HTTPProxy> convert(List<Proxy> plist) {
        ArrayList<HTTPProxy> ret = new ArrayList<HTTPProxy>();
        if (plist != null) {
            for (Proxy nativeProxy : plist) {
                try {
                    HTTPProxy proxy = HTTPProxy.fromNativeProxy(nativeProxy);
                    if (proxy == null) continue;
                    ret.add(proxy);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static enum TYPE implements LabelInterface
    {
        NONE{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_none();
            }
        }
        ,
        DIRECT{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_direct();
            }
        }
        ,
        HTTP{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_http();
            }
        }
        ,
        HTTPS{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_https();
            }
        }
        ,
        SOCKS4{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_socks4();
            }
        }
        ,
        SOCKS4A{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_socks4a();
            }
        }
        ,
        SOCKS5{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_socks5();
            }
        }
        ,
        AUTO{

            @Override
            public String getLabel() {
                return _AWU.T.proxy_type_auto_detect();
            }
        };

    }
}

