/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.appwork.loggingv3.LogV3;
import org.appwork.sunwrapper.sun.net.www.protocol.http.AuthCacheValueWrapper;
import org.appwork.utils.Exceptions;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.CountingInputStream;
import org.appwork.utils.net.EmptyInputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.StreamValidEOF;
import org.appwork.utils.net.httpconnection.CountingGZIPInputStream;
import org.appwork.utils.net.httpconnection.CountingInflaterInputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionProfilerInterface;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPHeaderMap;
import org.appwork.utils.net.httpconnection.HTTPOutputStream;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.NativeSSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;

public class NativeHTTPConnectionImpl
implements HTTPConnection {
    protected static final ProxySelector DEFAULT_PROXY_SELECTOR = ProxySelector.getDefault();
    protected final URL httpURL;
    protected final HTTPProxy proxy;
    protected final HTTPHeaderMap<String> requestProperties;
    protected final HTTPHeaderMap<List<String>> headers;
    protected HttpURLConnection con;
    protected int readTimeout = 30000;
    protected int connectTimeout = 30000;
    private int[] allowedResponseCodes = new int[0];
    protected long postTodoLength = -1L;
    protected HTTPConnection.RequestMethod httpMethod = HTTPConnection.RequestMethod.GET;
    protected HTTPOutputStream outputStream = null;
    protected InputStream inputStream = null;
    protected InputStream convertedInputStream = null;
    protected boolean inputStreamConnected = false;
    protected boolean outputClosed = false;
    protected int httpResponseCode = -1;
    protected String httpResponseMessage = "";
    protected String customcharset = null;
    protected long requestTime = -1L;
    protected long[] ranges;
    protected boolean contentDecoded = true;
    private boolean connected = false;
    private boolean wasConnected = false;
    private boolean sslTrustALL = false;
    private boolean legacyConnectFlag = true;
    protected final CopyOnWriteArrayList<String> connectExceptions = new CopyOnWriteArrayList();
    private static final WeakHashMap<Thread, HTTPProxy> CURRENT_THREAD_PROXY_AUTH = new WeakHashMap();
    private static final WeakHashMap<Thread, Proxy> CURRENT_THREAD_NATIVE_PROXY = new WeakHashMap();
    private static boolean proxySelectorSet = false;
    private static SSLSocketStreamFactory defaultSSLSocketStreamFactory;

    protected boolean appendPortToHostHeaderonCONNECT(HTTPProxy p) {
        return false;
    }

    public NativeHTTPConnectionImpl(URL url) {
        this(url, null);
    }

    protected String getExceptionMessage(Exception e) {
        if (e == null) {
            return null;
        }
        if (e.getMessage() != null) {
            return e.getClass().getName() + "(" + e.getMessage() + ")";
        }
        return e.getClass().getName();
    }

    protected URL getProxyConnectHostHeaderWorkaroundURL(final URL url, HTTPProxy p) {
        if (this.appendPortToHostHeaderonCONNECT(p) && JVMVersion.get() <= JVMVersion.JAVA18 && p != null && HTTPProxy.TYPE.HTTP.equals(p.getType()) && StringUtils.equalsIgnoreCase(url.getProtocol(), "https")) {
            try {
                final int hostPort = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
                Field portField = url.getClass().getDeclaredField("port");
                portField.setAccessible(true);
                Field handlerField = url.getClass().getDeclaredField("handler");
                handlerField.setAccessible(true);
                final URLStreamHandler handler = (URLStreamHandler)handlerField.get(url);
                URL ret = new URL(null, url.toExternalForm(), new URLStreamHandler(){

                    @Override
                    protected int getDefaultPort() {
                        if (Exceptions.getStackTrace(new Exception()).contains("sendCONNECT")) {
                            int ret = hostPort + 1;
                            return ret;
                        }
                        return url.getDefaultPort();
                    }

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        try {
                            Method openConnection = handler.getClass().getDeclaredMethod("openConnection", URL.class);
                            openConnection.setAccessible(true);
                            return (URLConnection)openConnection.invoke((Object)handler, u);
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }

                    @Override
                    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
                        try {
                            Method openConnection = handler.getClass().getDeclaredMethod("openConnection", URL.class, Proxy.class);
                            openConnection.setAccessible(true);
                            return (URLConnection)openConnection.invoke((Object)handler, u, p);
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                });
                portField.set(ret, hostPort);
                return ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public NativeHTTPConnectionImpl(URL url, HTTPProxy proxy) {
        this.httpURL = this.getProxyConnectHostHeaderWorkaroundURL(url, proxy);
        this.proxy = this.isProxySupported(proxy);
        this.requestProperties = new HTTPHeaderMap();
        this.headers = new HTTPHeaderMap();
        if (proxy != null) {
            switch (proxy.getType()) {
                case HTTP: 
                case HTTPS: {
                    this.setRequestProperty("Proxy-Connection", "close");
                    break;
                }
            }
        }
    }

    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy == null) {
            return null;
        }
        if (proxy.toNativeProxy() == null) {
            throw new IllegalArgumentException("Unsupported ProxyType " + this.proxy.getType());
        }
        return proxy;
    }

    protected String getSSLSocketStreamOptionsID(String host, int port, boolean trustAllFlag) {
        return host + ":" + port + ":" + trustAllFlag;
    }

    protected SSLSocketStreamOptions getNewSSLSocketStreamOptionsInstance(String host, int port, boolean trustAllFlag) {
        String id = this.getSSLSocketStreamOptionsID(host, port, trustAllFlag);
        SSLSocketStreamOptions ret = new SSLSocketStreamOptions(id, trustAllFlag){

            @Override
            protected void initCipherSuitesLists() {
            }
        };
        return this.getSSLSocketStreamOptions(ret);
    }

    protected SSLSocketStreamOptions getSSLSocketStreamOptions(SSLSocketStreamOptions options) {
        return options;
    }

    protected void setRequestMethod(HttpURLConnection con, HTTPConnection.RequestMethod requestMethod) throws ProtocolException {
        try {
            con.setRequestMethod(requestMethod.name());
        }
        catch (ProtocolException e) {
            try {
                Field field = ReflectionUtils.getField(HttpURLConnection.class, "method", (Object)con, String.class);
                field.setAccessible(true);
                field.set(con, requestMethod.name());
            }
            catch (Throwable e2) {
                throw Exceptions.addSuppressed(e, e2);
            }
        }
    }

    public static void setDefaultSSLSocketStreamFactory(SSLSocketStreamFactory defaultSSLSocketStreamFactory) {
        NativeHTTPConnectionImpl.defaultSSLSocketStreamFactory = defaultSSLSocketStreamFactory;
    }

    public static SSLSocketStreamFactory getDefaultSSLSocketStreamFactory() {
        SSLSocketStreamFactory ret = defaultSSLSocketStreamFactory;
        if (ret != null) {
            return ret;
        }
        return NativeSSLSocketStreamFactory.getInstance();
    }

    protected SSLSocketStreamFactory getSSLSocketStreamFactory(SSLSocketStreamOptions sslSocketStreamOptions) {
        SSLSocketStreamFactory ret;
        SSLSocketStreamFactory sSLSocketStreamFactory = ret = sslSocketStreamOptions != null ? sslSocketStreamOptions.getSSLSocketStreamFactory() : null;
        if (ret != null) {
            return ret;
        }
        return NativeHTTPConnectionImpl.getDefaultSSLSocketStreamFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        WeakHashMap<Thread, Object> weakHashMap;
        if (this.isConnected()) {
            return;
        }
        this.wasConnected = false;
        long startTime = Time.systemIndependentCurrentJVMTimeMillis();
        Proxy nativeProxy = this.proxy != null ? this.proxy.toNativeProxy() : null;
        try {
            if (nativeProxy != null) {
                weakHashMap = CURRENT_THREAD_PROXY_AUTH;
                synchronized (weakHashMap) {
                    CURRENT_THREAD_PROXY_AUTH.put(Thread.currentThread(), this.proxy);
                }
                AuthCacheValueWrapper.setAuthCacheImpl();
                if (proxySelectorSet && (HTTPProxy.TYPE.SOCKS4.equals(this.proxy.getType()) || HTTPProxy.TYPE.SOCKS4A.equals(this.proxy.getType()))) {
                    weakHashMap = CURRENT_THREAD_NATIVE_PROXY;
                    synchronized (weakHashMap) {
                        CURRENT_THREAD_NATIVE_PROXY.put(Thread.currentThread(), nativeProxy);
                    }
                    this.con = (HttpURLConnection)this.httpURL.openConnection();
                } else {
                    this.con = (HttpURLConnection)this.httpURL.openConnection(nativeProxy);
                }
            } else {
                weakHashMap = CURRENT_THREAD_PROXY_AUTH;
                synchronized (weakHashMap) {
                    CURRENT_THREAD_PROXY_AUTH.remove(Thread.currentThread());
                }
                this.con = (HttpURLConnection)this.httpURL.openConnection();
            }
            if (this.con instanceof HttpsURLConnection) {
                HttpsURLConnection scon = (HttpsURLConnection)this.con;
                final boolean trustAll = this.isSSLTrustALL();
                String urlHost = this.httpURL.getHost();
                int hostPort = this.httpURL.getPort() != -1 ? this.httpURL.getPort() : this.httpURL.getDefaultPort();
                SSLSocketStreamOptions options = this.getNewSSLSocketStreamOptionsInstance(urlHost, hostPort, trustAll);
                SSLSocketStreamFactory nativeSSLSocketStreamFactory = this.getSSLSocketStreamFactory(options);
                scon.setSSLSocketFactory(nativeSSLSocketStreamFactory.getSSLSocketFactory(options, urlHost));
                final HostnameVerifier hostNameVerifier = scon.getHostnameVerifier();
                scon.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String host, SSLSession sslSession) {
                        if (trustAll) {
                            return true;
                        }
                        try {
                            return Boolean.TRUE.equals(HTTPConnectionUtils.verifySSLHostname(hostNameVerifier, sslSession, host));
                        }
                        catch (IOException e) {
                            NativeHTTPConnectionImpl.this.connectExceptions.add(NativeHTTPConnectionImpl.this.getExceptionMessage(e));
                            return false;
                        }
                    }
                });
            }
            this.con.setConnectTimeout(this.connectTimeout);
            this.con.setReadTimeout(this.readTimeout);
            this.setRequestMethod(this.con, this.getRequestMethod());
            this.con.setAllowUserInteraction(false);
            this.con.setInstanceFollowRedirects(false);
            if (this.isRequiresOutputStream()) {
                this.con.setDoOutput(true);
            } else {
                this.outputClosed = true;
                this.con.setDoOutput(false);
            }
            for (Map.Entry<String, String> next : this.requestProperties.entrySet()) {
                if (next.getValue() == null) continue;
                if (StringUtils.equalsIgnoreCase("Content-Length", next.getKey())) {
                    this.postTodoLength = Long.parseLong(next.getValue().trim());
                }
                this.con.setRequestProperty(next.getKey(), next.getValue());
            }
            this.con.connect();
            this.connected = true;
            this.wasConnected = true;
            this.requestTime = Time.systemIndependentCurrentJVMTimeMillis() - startTime;
            if (!this.isRequiresOutputStream()) {
                this.outputStream = new HTTPOutputStream(new NullOutputStream());
                this.outputClosed = true;
                this.connectInputStream();
            } else {
                this.outputStream = new HTTPOutputStream(this.con.getOutputStream());
            }
        }
        finally {
            if (proxySelectorSet) {
                weakHashMap = CURRENT_THREAD_NATIVE_PROXY;
                synchronized (weakHashMap) {
                    CURRENT_THREAD_NATIVE_PROXY.remove(Thread.currentThread());
                }
            }
        }
    }

    protected synchronized void connectInputStream() throws IOException {
        long done;
        if (this.isRequiresOutputStream() && (done = this.outputStream.transferedBytes()) != this.postTodoLength) {
            throw new IOException("Content-Length " + this.postTodoLength + " does not match send " + done + " bytes");
        }
        if (this.inputStreamConnected) {
            return;
        }
        if (this.isRequiresOutputStream()) {
            this.outputStream.flush();
        }
        IOException inputException = null;
        try {
            this.inputStream = this.con.getInputStream();
        }
        catch (IOException e) {
            inputException = e;
            this.inputStream = this.con.getErrorStream();
        }
        this.inputStreamConnected = true;
        this.httpResponseCode = this.con.getResponseCode();
        this.httpResponseMessage = this.con.getResponseMessage();
        for (Map.Entry<String, List<String>> next : this.con.getHeaderFields().entrySet()) {
            String key = next.getKey();
            List<String> value = next.getValue();
            List<String> list = this.headers.get(key);
            if (list == null) {
                list = new ArrayList<String>();
                this.headers.put(key, list);
            }
            list.addAll(value);
        }
        if (this.inputStream == null && inputException != null) {
            if (this.getContentLength() == 0L) {
                this.inputStream = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }
                };
            } else {
                throw inputException;
            }
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean freeConnection) {
        try {
            this.con.disconnect();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.connected = false;
            if (freeConnection) {
                this.con = null;
            }
        }
    }

    @Override
    public void finalizeConnect() throws IOException {
        this.connect();
        this.connectInputStream();
    }

    @Override
    public int[] getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    @Override
    public String getCharset() {
        int i;
        if (this.customcharset != null) {
            return this.customcharset;
        }
        return this.getContentType() != null && (i = this.getContentType().toLowerCase().indexOf("charset=")) > 0 ? this.getContentType().substring(i + 8).trim() : null;
    }

    @Override
    public long getCompleteContentLength() {
        long[] range = this.getRange();
        if (range != null) {
            return range[2];
        }
        return this.getContentLength();
    }

    @Override
    public long getContentLength() {
        String length = this.getHeaderField("Content-Length");
        if (length != null && length.trim().matches("^\\d+$")) {
            return Long.parseLong(length.trim());
        }
        return -1L;
    }

    @Override
    public String getContentType() {
        String type = this.getHeaderField("Content-Type");
        if (type == null) {
            return "unknown";
        }
        return type;
    }

    @Override
    public String getHeaderField(String string) {
        List<String> ret = this.headers.get(string);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret.get(0);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public List<String> getHeaderFields(String string) {
        List<String> ret = this.headers.get(string);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    protected InputStream getRawInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isLegacyConnectEnabled() && !this.isConnected()) {
            throw new IllegalStateException("not connected!");
        }
        this.connect();
        this.connectInputStream();
        int code = this.getResponseCode();
        if (code == 407) {
            throw new ProxyAuthException(this.proxy);
        }
        if (this.isOK() || code == 404 || code == 403 || code == 416 || code == 401 || code == 410) {
            if (this.convertedInputStream == null) {
                InputStream rawInputStream = this.getRawInputStream();
                if (this.contentDecoded && !HTTPConnection.RequestMethod.HEAD.equals((Object)this.getRequestMethod())) {
                    if (this.getContentLength() == 0L) {
                        this.convertedInputStream = new EmptyInputStream();
                        this.contentDecoded = false;
                    } else {
                        String encoding = this.getHeaderField("Content-Encoding");
                        if (encoding == null || encoding.length() == 0 || "none".equalsIgnoreCase(encoding) || "identity".equalsIgnoreCase(encoding)) {
                            this.convertedInputStream = new CountingInputStream(rawInputStream);
                            this.contentDecoded = false;
                        } else if ("gzip".equalsIgnoreCase(encoding) || "x-gzip".equalsIgnoreCase(encoding)) {
                            CountingInputStream countingInputStream = new CountingInputStream(rawInputStream);
                            try {
                                this.convertedInputStream = new CountingGZIPInputStream(countingInputStream);
                                this.contentDecoded = true;
                            }
                            catch (IOException e) {
                                if (rawInputStream instanceof StreamValidEOF && ((StreamValidEOF)((Object)rawInputStream)).isValidEOF()) {
                                    this.convertedInputStream = countingInputStream;
                                    this.contentDecoded = true;
                                }
                                throw e;
                            }
                        } else if ("deflate".equalsIgnoreCase(encoding) || "x-deflate".equalsIgnoreCase(encoding)) {
                            CountingInputStream countingInputStream = new CountingInputStream(rawInputStream);
                            try {
                                this.convertedInputStream = new CountingInflaterInputStream(countingInputStream);
                                this.contentDecoded = true;
                            }
                            catch (IOException e) {
                                if (rawInputStream instanceof StreamValidEOF && ((StreamValidEOF)((Object)rawInputStream)).isValidEOF()) {
                                    this.convertedInputStream = countingInputStream;
                                    this.contentDecoded = true;
                                }
                                throw e;
                            }
                        } else {
                            this.convertedInputStream = new CountingInputStream(rawInputStream);
                            this.contentDecoded = false;
                        }
                    }
                } else {
                    this.convertedInputStream = new CountingInputStream(rawInputStream);
                    this.contentDecoded = false;
                }
            }
            return this.convertedInputStream;
        }
        throw new IOException(this.getResponseCode() + " " + this.getResponseMessage());
    }

    @Override
    public HTTPOutputStream getOutputStream() throws IOException {
        if (this.outputStream != null && this.isRequiresOutputStream()) {
            return this.outputStream;
        }
        throw new IOException("OutputStream is not available");
    }

    @Override
    public long[] getRange() {
        if (this.ranges == null) {
            this.ranges = HTTPConnectionUtils.parseContentRange(this);
        }
        return this.ranges;
    }

    protected String getRequestInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("----------------(Native)Request Information-------------\r\n");
        sb.append("URL: ").append(this.getURL()).append("\r\n");
        sb.append("Host: ").append(this.getURL().getHost()).append("\r\n");
        if (this.proxy != null) {
            sb.append("Proxy: ").append(this.proxy.toString()).append("\r\n");
        }
        sb.append("Connection-Timeout: ").append(this.connectTimeout + "ms").append("\r\n");
        sb.append("Read-Timeout: ").append(this.readTimeout + "ms").append("\r\n");
        if (this.connectExceptions.size() > 0) {
            sb.append("----------------ConnectionExceptions-------------------------\r\n");
            int index = 0;
            for (String connectException : this.connectExceptions) {
                sb.append(index++).append(":").append(connectException).append("\r\n");
            }
        }
        sb.append("----------------(Native)Request-------------------------\r\n");
        if (this.isConnected() || this.wasConnected()) {
            sb.append(this.httpMethod.toString()).append(' ').append(this.getURL().getPath()).append(" HTTP/1.1\r\n");
            for (Map.Entry<String, String> next : this.getRequestProperties().entrySet()) {
                if (next.getValue() == null) continue;
                sb.append(next.getKey());
                sb.append(": ");
                sb.append(next.getValue());
                sb.append("\r\n");
            }
        } else {
            sb.append("-------------Not Connected Yet!-----------------\r\n");
        }
        return sb.toString();
    }

    @Override
    public HTTPConnection.RequestMethod getRequestMethod() {
        return this.httpMethod;
    }

    @Override
    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    @Override
    public String getRequestProperty(String string) {
        return this.requestProperties.get(string);
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    @Override
    public int getResponseCode() {
        return this.httpResponseCode;
    }

    protected String getResponseInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("----------------Response Information------------\r\n");
        try {
            if (this.isConnected() || this.wasConnected()) {
                sb.append("Connection-Time: ").append(this.requestTime + "ms").append("\r\n");
                sb.append("----------------Response------------------------\r\n");
                this.connectInputStream();
                sb.append((Object)this.getRequestMethod());
                sb.append(" ");
                sb.append(this.con.getURL());
                sb.append(" ");
                sb.append(this.getResponseCode());
                sb.append(" ");
                sb.append(this.getResponseMessage());
                sb.append("\r\n");
                for (Map.Entry<String, List<String>> next : this.getHeaderFields().entrySet()) {
                    for (int i = next.getValue().size() - 1; i >= 0; --i) {
                        if (next.getKey() == null) {
                            sb.append(next.getValue().get(i));
                            sb.append("\r\n");
                            continue;
                        }
                        sb.append(next.getKey());
                        sb.append(": ");
                        sb.append(next.getValue().get(i));
                        sb.append("\r\n");
                    }
                }
                sb.append("------------------------------------------------\r\n");
            } else {
                sb.append("-------------Not Connected Yet!------------------\r\n");
            }
        }
        catch (IOException nothing) {
            sb.append("----------No InputStream Available!--------------\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    @Override
    public String getResponseMessage() {
        return this.httpResponseMessage;
    }

    @Override
    public URL getURL() {
        return this.httpURL;
    }

    @Override
    public boolean isConnected() {
        return this.con != null && this.connected;
    }

    @Override
    public boolean isContentDecoded() {
        if (this.convertedInputStream == null && this.contentDecoded && this.isConnected()) {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        return this.contentDecoded;
    }

    @Override
    public boolean isContentDisposition() {
        return this.getHeaderField("Content-Disposition") != null;
    }

    @Override
    public boolean isOK() {
        int code = this.getResponseCode();
        if (code >= 200 && code < 400) {
            return true;
        }
        return this.isResponseCodeAllowed(code);
    }

    protected boolean isResponseCodeAllowed(int code) {
        for (int c : this.allowedResponseCodes) {
            if (c != code && c != -1) continue;
            return true;
        }
        return false;
    }

    protected boolean isRequiresOutputStream() {
        return this.httpMethod.requiresOutputStream;
    }

    @Override
    public void setAllowedResponseCodes(int[] codes) {
        if (codes == null) {
            throw new IllegalArgumentException("codes==null");
        }
        this.allowedResponseCodes = codes;
    }

    @Override
    public void setCharset(String Charset2) {
        this.customcharset = Charset2;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setContentDecoded(boolean b) {
        if (this.convertedInputStream != null) {
            throw new IllegalStateException("InputStream already in use!");
        }
        this.contentDecoded = b;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        try {
            this.readTimeout = Math.max(0, readTimeout);
            if (this.isConnected()) {
                this.con.setReadTimeout(this.readTimeout);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public HTTPProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setRequestMethod(HTTPConnection.RequestMethod method) {
        this.httpMethod = method;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRequestInfo());
        sb.append(this.getResponseInfo());
        return sb.toString();
    }

    private boolean wasConnected() {
        return this.wasConnected;
    }

    @Override
    public void setSSLTrustALL(boolean trustALL) {
        this.sslTrustALL = trustALL;
    }

    @Override
    public boolean isSSLTrustALL() {
        return this.sslTrustALL;
    }

    @Override
    public void setLegacyConnectEnabled(boolean enabled) {
        this.legacyConnectFlag = enabled;
    }

    @Override
    public boolean isLegacyConnectEnabled() {
        return this.legacyConnectFlag;
    }

    @Override
    public void setProfiler(HTTPConnectionProfilerInterface profiler) {
    }

    @Override
    public HTTPConnectionProfilerInterface getProfiler() {
        return null;
    }

    static {
        try {
            Authenticator.setDefault(new Authenticator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    HTTPProxy foundProxy = null;
                    WeakHashMap weakHashMap = CURRENT_THREAD_PROXY_AUTH;
                    synchronized (weakHashMap) {
                        foundProxy = (HTTPProxy)CURRENT_THREAD_PROXY_AUTH.remove(Thread.currentThread());
                    }
                    if (foundProxy != null) {
                        String user = foundProxy.getUser();
                        String pass = foundProxy.getPass();
                        if (user != null || pass != null) {
                            if (StringUtils.isEmpty(user)) {
                                user = "";
                            }
                            if (StringUtils.isEmpty(pass)) {
                                pass = "";
                            }
                            return new PasswordAuthentication(user, pass.toCharArray());
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            ProxySelector.setDefault(new ProxySelector(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<Proxy> select(URI uri) {
                    Proxy nativeProxy;
                    WeakHashMap weakHashMap = CURRENT_THREAD_NATIVE_PROXY;
                    synchronized (weakHashMap) {
                        if (!CURRENT_THREAD_NATIVE_PROXY.containsKey(Thread.currentThread()) && DEFAULT_PROXY_SELECTOR != null) {
                            return DEFAULT_PROXY_SELECTOR.select(uri);
                        }
                        nativeProxy = (Proxy)CURRENT_THREAD_NATIVE_PROXY.get(Thread.currentThread());
                    }
                    ArrayList<Proxy> ret = new ArrayList<Proxy>();
                    if (nativeProxy != null) {
                        ret.add(nativeProxy);
                    } else {
                        ret.add(Proxy.NO_PROXY);
                    }
                    return ret;
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                    if (DEFAULT_PROXY_SELECTOR != null) {
                        DEFAULT_PROXY_SELECTOR.connectFailed(uri, sa, ioe);
                    }
                }
            });
            proxySelectorSet = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        defaultSSLSocketStreamFactory = null;
    }
}

